/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.messaging.PrunableMessageHome;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONStreamAware;

public final class DownloadPrunableMessage
extends APIServlet.APIRequestHandler {
    static final DownloadPrunableMessage instance = new DownloadPrunableMessage();

    private DownloadPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transactionFullHash", "secretPhrase", "sharedKey", "retrieve", "save");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        Chain chain = ParameterParser.getChain(httpServletRequest);
        PrunableMessageHome prunableMessageHome = chain.getPrunableMessageHome();
        PrunableMessageHome.PrunableMessage prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        if (prunableMessage == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(chain, byArray) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray2 = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray2.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        byte[] byArray3 = null;
        if (prunableMessage != null) {
            try {
                byArray3 = string != null ? prunableMessage.decrypt(string) : (byArray2.length > 0 ? prunableMessage.decrypt(byArray2) : prunableMessage.getMessage());
            }
            catch (RuntimeException runtimeException) {
                Logger.logDebugMessage("Decryption of message to recipient failed: " + runtimeException.toString());
                return JSONResponses.error("Wrong secretPhrase or sharedKey");
            }
        }
        if (byArray3 == null) {
            byArray3 = Convert.EMPTY_BYTE;
        }
        String string2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("save")) ? "attachment" : "inline";
        httpServletResponse.setHeader("Content-Disposition", string2 + "; filename=" + Long.toUnsignedString(Convert.fullHashToId(byArray)));
        httpServletResponse.setContentLength(byArray3.length);
        try (ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            try {
                servletOutputStream.write(byArray3);
            }
            catch (IOException iOException) {
                throw new ParameterException(JSONResponses.RESPONSE_WRITE_ERROR);
            }
        }
        catch (IOException iOException) {
            throw new ParameterException(JSONResponses.RESPONSE_STREAM_ERROR);
        }
        return null;
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        throw new UnsupportedOperationException();
    }
}

