/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.Bundler;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBundlingOptions
extends APIServlet.APIRequestHandler {
    static final GetBundlingOptions instance = new GetBundlingOptions();

    private GetBundlingOptions() {
        super(new APITag[]{APITag.INFO}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        return Holder.OPTIONS;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    private static final class Holder {
        private static final JSONStreamAware OPTIONS;

        private Holder() {
        }

        static {
            try {
                JSONObject jSONObject = new JSONObject();
                Collection<Bundler.Filter> collection = Bundler.getAvailableFilters();
                JSONArray jSONArray = new JSONArray();
                collection.forEach(filter -> {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put((Object)"name", (Object)filter.getName());
                    jSONObject.put((Object)"description", (Object)filter.getDescription());
                    jSONArray.add((Object)jSONObject);
                });
                jSONObject.put((Object)"availableFilters", (Object)jSONArray);
                Collection<Bundler.FeeCalculator> collection2 = Bundler.getAvailableFeeCalculators();
                JSONArray jSONArray2 = new JSONArray();
                collection2.forEach(feeCalculator -> jSONArray2.add((Object)feeCalculator.getName()));
                jSONObject.put((Object)"availableFeeCalculators", (Object)jSONArray2);
                OPTIONS = JSON.prepare(jSONObject);
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.toString(), exception);
                throw exception;
            }
        }
    }
}

