/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.crypto.Crypto;
import nxt.dgs.DigitalGoodsHome;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetDGSPurchase
extends APIServlet.APIRequestHandler {
    static final GetDGSPurchase instance = new GetDGSPurchase();

    private GetDGSPurchase() {
        super(new APITag[]{APITag.DGS}, "purchase", "secretPhrase", "sharedKey");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        DigitalGoodsHome.Purchase purchase = ParameterParser.getPurchase(httpServletRequest);
        JSONObject jSONObject = JSONData.purchase(purchase);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        if (byArray.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        if (byArray.length == 0 && string == null) {
            return jSONObject;
        }
        if (purchase.getEncryptedGoods() != null) {
            byte[] byArray2 = purchase.getEncryptedGoods().getData();
            try {
                byte[] byArray3 = Convert.EMPTY_BYTE;
                if (byArray2.length != 0) {
                    if (string != null) {
                        byte[] byArray4;
                        byte[] byArray5 = Crypto.getPublicKey(string);
                        byte[] byArray6 = Account.getPublicKey(purchase.getSellerId());
                        byte[] byArray7 = Account.getPublicKey(purchase.getBuyerId());
                        byte[] byArray8 = byArray4 = Arrays.equals(byArray6, byArray5) ? byArray7 : byArray6;
                        if (byArray4 != null) {
                            byArray3 = Account.decryptFrom(byArray4, purchase.getEncryptedGoods(), string, true);
                        }
                    } else {
                        byArray3 = Crypto.aesDecrypt(purchase.getEncryptedGoods().getData(), byArray);
                        byArray3 = Convert.uncompress(byArray3);
                    }
                }
                jSONObject.put((Object)"decryptedGoods", (Object)Convert.toString(byArray3, purchase.goodsIsText()));
            }
            catch (RuntimeException runtimeException) {
                Logger.logDebugMessage(runtimeException.toString());
                return JSONResponses.DECRYPTION_FAILED;
            }
        }
        return jSONObject;
    }
}

