/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetECBlock
extends APIServlet.APIRequestHandler {
    static final GetECBlock instance = new GetECBlock();

    private GetECBlock() {
        super(new APITag[]{APITag.BLOCKS}, "timestamp");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getTimestamp(httpServletRequest);
        if (n == 0) {
            n = Nxt.getEpochTime();
        }
        Block block = Nxt.getBlockchain().getECBlock(n);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"ecBlockId", (Object)block.getStringId());
        jSONObject.put((Object)"ecBlockHeight", (Object)block.getHeight());
        jSONObject.put((Object)"timestamp", (Object)n);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

