/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.ms.CurrencyTransferAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedCurrencyTransfers
extends APIServlet.APIRequestHandler {
    static final GetExpectedCurrencyTransfers instance = new GetExpectedCurrencyTransfers();

    private GetExpectedCurrencyTransfers() {
        super(new APITag[]{APITag.MS}, "currency", "account", "includeCurrencyInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "account", false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != MonetarySystemTransactionType.CURRENCY_TRANSFER) {
                return false;
            }
            if (l2 != 0L && transaction.getSenderId() != l2 && transaction.getRecipientId() != l2) {
                return false;
            }
            if (childChain != null && transaction.getChain() != childChain) {
                return false;
            }
            CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)transaction.getAttachment();
            return l == 0L || currencyTransferAttachment.getCurrencyId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedCurrencyTransfer(transaction, bl)));
        jSONObject.put((Object)"transfers", (Object)jSONArray);
        return jSONObject;
    }
}

