/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class GetFxtTransaction
extends APIServlet.APIRequestHandler {
    static final GetFxtTransaction instance = new GetFxtTransaction();

    private GetFxtTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transaction", "fullHash", "includeChildTransactions");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "transaction", false);
        if (l == 0L) {
            byte[] byArray = ParameterParser.getBytes(httpServletRequest, "fullHash", true);
            l = Convert.fullHashToId(byArray);
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeChildTransactions"));
        try {
            FxtTransaction fxtTransaction = Nxt.getBlockchain().getFxtTransaction(l);
            if (fxtTransaction != null) {
                return JSONData.fxtTransaction(fxtTransaction, bl);
            }
            UnconfirmedTransaction unconfirmedTransaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(l);
            if (unconfirmedTransaction != null && unconfirmedTransaction.getChain() == FxtChain.FXT) {
                return JSONData.unconfirmedFxtTransaction((FxtTransaction)((Object)unconfirmedTransaction), bl);
            }
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

