/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.voting.PhasingParams;
import nxt.voting.PhasingPollHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetHashedSecretPhasedTransactions
extends APIServlet.APIRequestHandler {
    static final GetHashedSecretPhasedTransactions instance = new GetHashedSecretPhasedTransactions();

    private GetHashedSecretPhasedTransactions() {
        super(new APITag[]{APITag.PHASING}, "phasingHashedSecret", "phasingHashedSecretAlgorithm");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "phasingHashedSecret", true);
        byte by = ParameterParser.getByte(httpServletRequest, "phasingHashedSecretAlgorithm", (byte)0, (byte)127, true);
        PhasingParams.HashVoting hashVoting = new PhasingParams.HashVoting(byArray, by);
        JSONArray jSONArray = new JSONArray();
        List<ChainTransactionId> list = PhasingPollHome.getHashedSecretPhasedTransactionIds(hashVoting, Nxt.getBlockchain().getHeight());
        list.forEach(chainTransactionId -> jSONArray.add((Object)JSONData.transaction((Transaction)chainTransactionId.getChildTransaction(), true)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"transactions", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

