/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.ae.TradeHome;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetOrderTrades
extends APIServlet.APIRequestHandler {
    static final GetOrderTrades instance = new GetOrderTrades();

    private GetOrderTrades() {
        super(new APITag[]{APITag.AE}, "askOrderFullHash", "bidOrderFullHash", "includeAssetInfo", "firstIndex", "lastIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "askOrderFullHash", false);
        byte[] byArray2 = ParameterParser.getBytes(httpServletRequest, "bidOrderFullHash", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        if (byArray.length == 0 && byArray2.length == 0) {
            return JSONResponses.missing("askOrderFullHash", "bidOrderFullHash");
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        if (byArray.length != 0 && byArray2.length != 0) {
            TradeHome.Trade trade = childChain.getTradeHome().getTrade(byArray, byArray2);
            if (trade != null) {
                jSONArray.add((Object)JSONData.trade(trade, bl));
            }
        } else {
            DbIterator<TradeHome.Trade> dbIterator = null;
            try {
                dbIterator = byArray.length != 0 ? childChain.getTradeHome().getAskOrderTrades(byArray, n, n2) : childChain.getTradeHome().getBidOrderTrades(byArray2, n, n2);
                while (dbIterator.hasNext()) {
                    TradeHome.Trade trade = dbIterator.next();
                    jSONArray.add((Object)JSONData.trade(trade, bl));
                }
            }
            catch (Throwable throwable) {
                DbUtils.close(dbIterator);
                throw throwable;
            }
            DbUtils.close(dbIterator);
        }
        jSONObject.put((Object)"trades", (Object)jSONArray);
        return jSONObject;
    }
}

