/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.ae.TradeHome;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetTrades
extends APIServlet.APIRequestHandler {
    static final GetTrades instance = new GetTrades();

    private GetTrades() {
        super(new APITag[]{APITag.AE}, "asset", "account", "firstIndex", "lastIndex", "timestamp", "includeAssetInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.MISSING_ASSET_ACCOUNT;
        }
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        DbIterator<TradeHome.Trade> dbIterator = null;
        try {
            TradeHome.Trade trade;
            dbIterator = l2 == 0L ? childChain.getTradeHome().getAssetTrades(l, n2, n3) : (l == 0L ? childChain.getTradeHome().getAccountTrades(l2, n2, n3) : childChain.getTradeHome().getAccountAssetTrades(l2, l, n2, n3));
            while (dbIterator.hasNext() && (trade = dbIterator.next()).getTimestamp() >= n) {
                jSONArray.add((Object)JSONData.trade(trade, bl));
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(dbIterator);
            throw throwable;
        }
        DbUtils.close(dbIterator);
        jSONObject.put((Object)"trades", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean startDbTransaction() {
        return true;
    }
}

