/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetTransactionBytes
extends APIServlet.APIRequestHandler {
    static final GetTransactionBytes instance = new GetTransactionBytes();

    private GetTransactionBytes() {
        super(new APITag[]{APITag.TRANSACTIONS}, "fullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "fullHash", true);
        Chain chain = ParameterParser.getChain(httpServletRequest);
        Transaction transaction = Nxt.getBlockchain().getTransaction(chain, byArray);
        JSONObject jSONObject = new JSONObject();
        if (transaction == null) {
            transaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(Convert.fullHashToId(byArray));
            if (transaction == null) {
                return JSONResponses.UNKNOWN_TRANSACTION;
            }
        } else {
            jSONObject.put((Object)"confirmations", (Object)(Nxt.getBlockchain().getHeight() - transaction.getHeight()));
        }
        jSONObject.put((Object)"transactionBytes", (Object)Convert.toHexString(transaction.getBytes()));
        jSONObject.put((Object)"unsignedTransactionBytes", (Object)Convert.toHexString(transaction.getUnsignedBytes()));
        JSONData.putPrunableAttachment(jSONObject, transaction);
        return jSONObject;
    }
}

