/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ProcessVoucher
extends APIServlet.APIRequestHandler {
    static final ProcessVoucher instance = new ProcessVoucher();

    private ProcessVoucher() {
        super("voucher", new APITag[]{APITag.TRANSACTIONS}, "secretPhrase", "validate", "broadcast");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        boolean bl;
        ParameterParser.FileData fileData = ParameterParser.getFileData(httpServletRequest, "voucher", true);
        if (fileData == null) {
            return JSONResponses.INCORRECT_FILE;
        }
        byte[] byArray = fileData.getData();
        JSONObject jSONObject = ParameterParser.parseVoucher(byArray);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put((Object)"status", (Object)"valid");
        jSONObject2.put((Object)"voucher", (Object)jSONObject);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        if (string == null) {
            return jSONObject2;
        }
        boolean bl2 = !"false".equalsIgnoreCase(httpServletRequest.getParameter("validate"));
        JSONObject jSONObject3 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        jSONObject3.put((Object)"timestamp", (Object)Nxt.getEpochTime());
        Transaction.Builder builder = ParameterParser.parseTransaction(jSONObject3.toJSONString(), null, null);
        Transaction transaction = builder.build(string);
        if (bl2) {
            transaction.validate();
            jSONObject2.put((Object)"verify", (Object)transaction.verifySignature());
        }
        JSONObject jSONObject4 = JSONData.unconfirmedTransaction(transaction);
        jSONObject2.put((Object)"signedTransaction", (Object)jSONObject4);
        boolean bl3 = bl = !"false".equalsIgnoreCase(httpServletRequest.getParameter("broadcast"));
        if (bl) {
            Nxt.getTransactionProcessor().broadcast(transaction);
            jSONObject2.put((Object)"broadcast", (Object)"true");
        }
        return jSONObject2;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }
}

