/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.account.Account;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SearchAccounts
extends APIServlet.APIRequestHandler {
    static final SearchAccounts instance = new SearchAccounts();

    private SearchAccounts() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.SEARCH}, "query", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("query"));
        if (string.isEmpty()) {
            return JSONResponses.missing("query");
        }
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<Account.AccountInfo> dbIterator = Account.searchAccounts(string, n, n2);){
            for (Account.AccountInfo accountInfo : dbIterator) {
                JSONObject jSONObject2 = new JSONObject();
                JSONData.putAccount(jSONObject2, "account", accountInfo.getAccountId());
                if (accountInfo.getName() != null) {
                    jSONObject2.put((Object)"name", (Object)accountInfo.getName());
                }
                if (accountInfo.getDescription() != null) {
                    jSONObject2.put((Object)"description", (Object)accountInfo.getDescription());
                }
                jSONArray.add((Object)jSONObject2);
            }
        }
        jSONObject.put((Object)"accounts", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

