/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.voting.PhasingParams;
import nxt.voting.SetPhasingOnlyAttachment;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SetPhasingOnlyControl
extends CreateTransaction {
    static final SetPhasingOnlyControl instance = new SetPhasingOnlyControl();

    private SetPhasingOnlyControl() {
        super(new APITag[]{APITag.ACCOUNT_CONTROL, APITag.CREATE_TRANSACTION}, "controlVotingModel", "controlQuorum", "controlMinBalance", "controlMinBalanceModel", "controlHolding", "controlWhitelisted", "controlWhitelisted", "controlWhitelisted", "controlSenderPropertySetter", "controlSenderPropertyName", "controlSenderPropertyValue", "controlRecipientPropertySetter", "controlRecipientPropertyName", "controlRecipientPropertyValue", "controlExpression", "controlMaxFees", "controlMaxFees", "controlMaxFees", "controlMinDuration", "controlMaxDuration", "controlParams");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        JSONObject jSONObject = ParameterParser.getJson(httpServletRequest, "controlParams");
        PhasingParams phasingParams = jSONObject != null ? new PhasingParams(jSONObject) : ParameterParser.parsePhasingParams(httpServletRequest, "control");
        TreeMap<Integer, Long> treeMap = new TreeMap<Integer, Long>();
        String[] stringArray = httpServletRequest.getParameterValues("controlMaxFees");
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                String[] stringArray2 = string.split(":");
                if (stringArray2.length != 2) {
                    return JSONResponses.incorrect("controlMaxFees");
                }
                int n = Integer.parseInt(stringArray2[0]);
                ChildChain childChain = ChildChain.getChildChain(n);
                if (childChain == null) {
                    return JSONResponses.UNKNOWN_CHAIN;
                }
                long l = Long.parseLong(stringArray2[1]);
                if (l < 0L || l > 100000000000000000L) {
                    return JSONResponses.incorrect("controlMaxFees");
                }
                treeMap.put(n, l);
            }
        }
        short s = (short)ParameterParser.getInt(httpServletRequest, "controlMinDuration", 0, 20159, false);
        int n = (short)ParameterParser.getInt(httpServletRequest, "controlMaxDuration", 0, 20159, false);
        return this.createTransaction(httpServletRequest, account, new SetPhasingOnlyAttachment(phasingParams, treeMap, s, (short)n));
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

