/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingAttachment;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingStage;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ShufflingProcess
extends CreateTransaction {
    static final ShufflingProcess instance = new ShufflingProcess();

    private ShufflingProcess() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shufflingFullHash", "recipientSecretPhrase", "recipientPublicKey");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        ShufflingHome.Shuffling shuffling = ParameterParser.getShuffling(httpServletRequest);
        if (shuffling.getStage() != ShufflingStage.PROCESSING) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)11);
            jSONObject.put((Object)"errorDescription", (Object)("Shuffling is not in processing, stage " + (Object)((Object)shuffling.getStage())));
            return JSON.prepare(jSONObject);
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = account.getId();
        if (shuffling.getAssigneeAccountId() != l) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)12);
            jSONObject.put((Object)"errorDescription", (Object)String.format("Account %s cannot process shuffling since shuffling assignee is %s", Convert.rsAccount(l), Convert.rsAccount(shuffling.getAssigneeAccountId())));
            return JSON.prepare(jSONObject);
        }
        ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(l);
        if (shufflingParticipant == null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)13);
            jSONObject.put((Object)"errorDescription", (Object)String.format("Account %s is not a participant of shuffling %d", Convert.rsAccount(l), shuffling.getId()));
            return JSON.prepare(jSONObject);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        byte[] byArray = ParameterParser.getPublicKey(httpServletRequest, "recipient");
        if (Account.getAccount(byArray) != null) {
            return JSONResponses.INCORRECT_PUBLIC_KEY;
        }
        ShufflingAttachment shufflingAttachment = shuffling.process(l, string, byArray);
        return this.createTransaction(httpServletRequest, account, shufflingAttachment);
    }
}

