/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.responses;

import java.util.List;
import nxt.addons.JO;
import nxt.http.responses.TaggedDataResponse;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class TaggedDataResponseImpl
implements TaggedDataResponse {
    byte[] transactionFullHash;
    long account;
    String name;
    String description;
    String tags;
    List<String> parsedTags;
    String type;
    String channel;
    String filename;
    boolean isText;
    byte[] data;
    int transactionTimestamp;
    int blockTimestamp;

    public TaggedDataResponseImpl(JSONObject jSONObject) {
        this(new JO(jSONObject));
    }

    public TaggedDataResponseImpl(JO jO) {
        this.transactionFullHash = jO.parseHexString("transactionFullHash");
        this.account = jO.getEntityId("account");
        this.name = jO.getString("name");
        this.description = jO.getString("description");
        this.tags = jO.getString("tags");
        this.parsedTags = jO.getArray("parsedTags").values();
        this.type = jO.getString("type");
        this.channel = jO.getString("channel");
        this.filename = jO.getString("filename");
        this.isText = jO.getBoolean("isText");
        this.data = Convert.toBytes(jO.getString("data"), this.isText);
        this.transactionTimestamp = jO.getInt("transactionTimestamp");
        this.blockTimestamp = jO.getInt("blockTimestamp");
    }

    @Override
    public byte[] getTransactionFullHash() {
        return this.transactionFullHash;
    }

    @Override
    public long getAccount() {
        return this.account;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public List<String> getParsedTags() {
        return this.parsedTags;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isText() {
        return this.isText;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    @Override
    public int getBlockTimestamp() {
        return this.blockTimestamp;
    }
}

