/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.TransactionType;
import nxt.messaging.MessageAttachment;
import org.json.simple.JSONObject;

public abstract class MessagingTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_MESSAGING_ARBITRARY_MESSAGE = 0;
    public static final TransactionType ARBITRARY_MESSAGE = new MessagingTransactionType(){

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ARBITRARY_MESSAGE;
        }

        @Override
        public String getName() {
            return "ArbitraryMessage";
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(ByteBuffer byteBuffer) {
            return MessageAttachment.INSTANCE;
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(JSONObject jSONObject) {
            return MessageAttachment.INSTANCE;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            Attachment.AbstractAttachment abstractAttachment = childTransactionImpl.getAttachment();
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Invalid arbitrary message: " + abstractAttachment.getJSONObject());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean mustHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ARBITRARY_MESSAGE;
            }
        }
        return null;
    }

    private MessagingTransactionType() {
    }

    @Override
    public final byte getType() {
        return 1;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

