/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.messaging.PrunableMessageHome;
import nxt.messaging.UnencryptedPrunableEncryptedMessageAppendix;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class PrunableEncryptedMessageAppendix
extends Appendix.AbstractAppendix
implements Appendix.Prunable {
    public static final int appendixType = 16;
    public static final String appendixName = "PrunableEncryptedMessage";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new PrunableEncryptedMessageAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(PrunableEncryptedMessageAppendix.appendixName, jSONObject)) {
                return null;
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"encryptedMessage");
            if (jSONObject2 != null && jSONObject2.get((Object)"data") == null) {
                return new UnencryptedPrunableEncryptedMessageAppendix(jSONObject);
            }
            return new PrunableEncryptedMessageAppendix(jSONObject);
        }
    };
    private static final Fee PRUNABLE_ENCRYPTED_DATA_FEE = new Fee.SizeBasedFee(1000000L){

        @Override
        public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
            return appendix.getFullSize();
        }
    };
    private final byte[] hash;
    private EncryptedData encryptedData;
    private final boolean isText;
    private final boolean isCompressed;
    private volatile PrunableMessageHome.PrunableMessage prunableMessage;

    private PrunableEncryptedMessageAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 0) {
            this.isText = (by & 2) != 0;
            this.isCompressed = (by & 4) != 0;
            int n = byteBuffer.getInt();
            this.encryptedData = EncryptedData.readEncryptedData(byteBuffer, n, 43008);
            this.hash = null;
        } else {
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.encryptedData = null;
            this.isText = false;
            this.isCompressed = false;
        }
    }

    public PrunableEncryptedMessageAppendix(JSONObject jSONObject) {
        super(jSONObject);
        String string = Convert.emptyToNull((String)jSONObject.get((Object)"encryptedMessageHash"));
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"encryptedMessage");
        if (string != null && jSONObject2 == null) {
            this.hash = Convert.parseHexString(string);
            this.encryptedData = null;
            this.isText = false;
            this.isCompressed = false;
        } else {
            this.hash = null;
            byte[] byArray = Convert.parseHexString((String)jSONObject2.get((Object)"data"));
            byte[] byArray2 = Convert.parseHexString((String)jSONObject2.get((Object)"nonce"));
            this.encryptedData = new EncryptedData(byArray, byArray2);
            this.isText = Boolean.TRUE.equals(jSONObject2.get((Object)"isText"));
            this.isCompressed = Boolean.TRUE.equals(jSONObject2.get((Object)"isCompressed"));
        }
    }

    public PrunableEncryptedMessageAppendix(EncryptedData encryptedData, boolean bl, boolean bl2) {
        this.encryptedData = encryptedData;
        this.isText = bl;
        this.isCompressed = bl2;
        this.hash = null;
    }

    @Override
    public final Fee getBaselineFee(Transaction transaction) {
        return PRUNABLE_ENCRYPTED_DATA_FEE;
    }

    @Override
    protected final int getMySize() {
        return 33;
    }

    @Override
    public int getMyFullSize() {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        return 5 + this.getEncryptedData().getSize();
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)0);
        byteBuffer.put(this.getHash());
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        byte by = 1;
        if (this.isText()) {
            by = (byte)(by | 2);
        }
        if (this.isCompressed()) {
            by = (byte)(by | 4);
        }
        byteBuffer.put(by);
        byteBuffer.putInt(this.getEncryptedDataLength());
        byteBuffer.put(this.getEncryptedData().getData());
        byteBuffer.put(this.getEncryptedData().getNonce());
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.prunableMessage != null) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject.put((Object)"encryptedMessage", (Object)jSONObject2);
            jSONObject2.put((Object)"data", (Object)Convert.toHexString(this.prunableMessage.getEncryptedData().getData()));
            jSONObject2.put((Object)"nonce", (Object)Convert.toHexString(this.prunableMessage.getEncryptedData().getNonce()));
            jSONObject2.put((Object)"isText", (Object)this.prunableMessage.encryptedMessageIsText());
            jSONObject2.put((Object)"isCompressed", (Object)this.prunableMessage.isCompressed());
        } else if (this.encryptedData != null) {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject.put((Object)"encryptedMessage", (Object)jSONObject3);
            jSONObject3.put((Object)"data", (Object)Convert.toHexString(this.encryptedData.getData()));
            jSONObject3.put((Object)"nonce", (Object)Convert.toHexString(this.encryptedData.getNonce()));
            jSONObject3.put((Object)"isText", (Object)this.isText);
            jSONObject3.put((Object)"isCompressed", (Object)this.isCompressed);
        }
        jSONObject.put((Object)"encryptedMessageHash", (Object)Convert.toHexString(this.getHash()));
    }

    @Override
    public int getAppendixType() {
        return 16;
    }

    @Override
    public final String getAppendixName() {
        return appendixName;
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (transaction instanceof ChildTransaction && ((ChildTransaction)transaction).getEncryptedMessage() != null) {
            throw new NxtException.NotValidException("Cannot have both encrypted and prunable encrypted message attachments");
        }
        EncryptedData encryptedData = this.getEncryptedData();
        if (encryptedData == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
            throw new NxtException.NotCurrentlyValidException("Encrypted message has been pruned prematurely");
        }
        if (encryptedData != null) {
            if (encryptedData.getData().length > 43008) {
                throw new NxtException.NotValidException(String.format("Message length %d exceeds max prunable encrypted message length %d", encryptedData.getData().length, 43008));
            }
            if (encryptedData.getNonce().length != 32 && encryptedData.getData().length > 0 || encryptedData.getNonce().length != 0 && encryptedData.getData().length == 0) {
                throw new NxtException.NotValidException("Invalid nonce length " + encryptedData.getNonce().length);
            }
        }
        if (transaction.getRecipientId() == 0L) {
            throw new NxtException.NotValidException("Encrypted messages cannot be attached to transactions with no recipient");
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        if (Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MAX_PRUNABLE_LIFETIME) {
            transaction.getChain().getPrunableMessageHome().add((TransactionImpl)transaction, this);
        }
    }

    public final EncryptedData getEncryptedData() {
        if (this.prunableMessage != null) {
            return this.prunableMessage.getEncryptedData();
        }
        return this.encryptedData;
    }

    final void setEncryptedData(EncryptedData encryptedData) {
        this.encryptedData = encryptedData;
    }

    int getEncryptedDataLength() {
        return this.getEncryptedData() == null ? 0 : this.getEncryptedData().getData().length;
    }

    public final boolean isText() {
        if (this.prunableMessage != null) {
            return this.prunableMessage.encryptedMessageIsText();
        }
        return this.isText;
    }

    public final boolean isCompressed() {
        if (this.prunableMessage != null) {
            return this.prunableMessage.isCompressed();
        }
        return this.isCompressed;
    }

    @Override
    public final byte[] getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update((byte)(this.isText ? 1 : 0));
        messageDigest.update((byte)(this.isCompressed ? 1 : 0));
        messageDigest.update(this.encryptedData.getData());
        messageDigest.update(this.encryptedData.getNonce());
        return messageDigest.digest();
    }

    @Override
    public void loadPrunable(Transaction transaction, boolean bl) {
        PrunableMessageHome.PrunableMessage prunableMessage;
        if (!this.hasPrunableData() && this.shouldLoadPrunable(transaction, bl) && (prunableMessage = transaction.getChain().getPrunableMessageHome().getPrunableMessage(transaction.getFullHash())) != null && prunableMessage.getEncryptedData() != null) {
            this.prunableMessage = prunableMessage;
        }
    }

    @Override
    public final boolean isPhasable() {
        return false;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return true;
    }

    @Override
    public final boolean hasPrunableData() {
        return this.prunableMessage != null || this.encryptedData != null;
    }

    @Override
    public void restorePrunableData(Transaction transaction, int n, int n2) {
        transaction.getChain().getPrunableMessageHome().add((TransactionImpl)transaction, this, n, n2);
    }
}

