/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.messaging.EncryptToSelfMessageAppendix;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class UnencryptedEncryptToSelfMessageAppendix
extends EncryptToSelfMessageAppendix
implements Appendix.Encryptable {
    private final byte[] messageToEncrypt;

    UnencryptedEncryptToSelfMessageAppendix(JSONObject jSONObject) {
        super(jSONObject);
        this.setEncryptedData(null);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"encryptToSelfMessage");
        String string = (String)jSONObject2.get((Object)"messageToEncrypt");
        this.messageToEncrypt = this.isText() ? Convert.toBytes(string) : Convert.parseHexString(string);
    }

    public UnencryptedEncryptToSelfMessageAppendix(byte[] byArray, boolean bl, boolean bl2) {
        super(null, bl, bl2);
        this.messageToEncrypt = byArray;
    }

    @Override
    protected int getMySize() {
        if (this.getEncryptedData() != null) {
            return super.getMySize();
        }
        return 3 + EncryptedData.getEncryptedSize(this.getPlaintext());
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        if (this.getEncryptedData() == null) {
            throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
        }
        super.putMyBytes(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.getEncryptedData() == null) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"messageToEncrypt", (Object)(this.isText() ? Convert.toString(this.messageToEncrypt) : Convert.toHexString(this.messageToEncrypt)));
            jSONObject2.put((Object)"isText", (Object)this.isText());
            jSONObject2.put((Object)"isCompressed", (Object)this.isCompressed());
            jSONObject.put((Object)"encryptToSelfMessage", (Object)jSONObject2);
        } else {
            super.putMyJSON(jSONObject);
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        if (this.getEncryptedData() == null) {
            throw new NxtException.NotYetEncryptedException("Message not yet encrypted");
        }
        super.apply(transaction, account, account2);
    }

    @Override
    public void encrypt(String string) {
        this.setEncryptedData(EncryptedData.encrypt(this.getPlaintext(), string, Crypto.getPublicKey(string)));
    }

    @Override
    int getEncryptedDataLength() {
        return EncryptedData.getEncryptedDataLength(this.getPlaintext());
    }

    private byte[] getPlaintext() {
        return this.isCompressed() && this.messageToEncrypt.length > 0 ? Convert.compress(this.messageToEncrypt) : this.messageToEncrypt;
    }
}

