/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Transaction;
import nxt.crypto.EncryptedData;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class UnencryptedPrunableEncryptedMessageAppendix
extends PrunableEncryptedMessageAppendix
implements Appendix.Encryptable {
    private final byte[] messageToEncrypt;
    private final byte[] recipientPublicKey;

    UnencryptedPrunableEncryptedMessageAppendix(JSONObject jSONObject) {
        super(jSONObject);
        this.setEncryptedData(null);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"encryptedMessage");
        String string = (String)jSONObject2.get((Object)"messageToEncrypt");
        this.messageToEncrypt = this.isText() ? Convert.toBytes(string) : Convert.parseHexString(string);
        this.recipientPublicKey = Convert.parseHexString((String)jSONObject.get((Object)"recipientPublicKey"));
    }

    public UnencryptedPrunableEncryptedMessageAppendix(byte[] byArray, boolean bl, boolean bl2, byte[] byArray2) {
        super(null, bl, bl2);
        this.messageToEncrypt = byArray;
        this.recipientPublicKey = byArray2;
    }

    @Override
    public int getMyFullSize() {
        if (this.getEncryptedData() != null) {
            return super.getMyFullSize();
        }
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        return 5 + EncryptedData.getEncryptedSize(this.getPlaintext());
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        if (this.getEncryptedData() == null) {
            throw new NxtException.NotYetEncryptedException("Prunable encrypted message not yet encrypted");
        }
        super.putMyBytes(byteBuffer);
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (this.getEncryptedData() == null) {
            throw new NxtException.NotYetEncryptedException("Prunable encrypted message not yet encrypted");
        }
        super.putMyPrunableBytes(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.getEncryptedData() == null) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"messageToEncrypt", (Object)(this.isText() ? Convert.toString(this.messageToEncrypt) : Convert.toHexString(this.messageToEncrypt)));
            jSONObject2.put((Object)"isText", (Object)this.isText());
            jSONObject2.put((Object)"isCompressed", (Object)this.isCompressed());
            jSONObject.put((Object)"recipientPublicKey", (Object)Convert.toHexString(this.recipientPublicKey));
            jSONObject.put((Object)"encryptedMessage", (Object)jSONObject2);
        } else {
            super.putMyJSON(jSONObject);
        }
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (this.getEncryptedData() == null) {
            int n = this.getEncryptedDataLength();
            if (n > 43008) {
                throw new NxtException.NotValidException(String.format("Message length %d exceeds max prunable encrypted message length %d", n, 43008));
            }
        } else {
            super.validate(transaction);
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
        if (this.getEncryptedData() == null) {
            throw new NxtException.NotYetEncryptedException("Prunable encrypted message not yet encrypted");
        }
        super.apply(transaction, account, account2);
    }

    @Override
    public void loadPrunable(Transaction transaction, boolean bl) {
    }

    @Override
    public void encrypt(String string) {
        this.setEncryptedData(EncryptedData.encrypt(this.getPlaintext(), string, this.recipientPublicKey));
    }

    @Override
    int getEncryptedDataLength() {
        return EncryptedData.getEncryptedDataLength(this.getPlaintext());
    }

    private byte[] getPlaintext() {
        return this.isCompressed() && this.messageToEncrypt.length > 0 ? Convert.compress(this.messageToEncrypt) : this.messageToEncrypt;
    }
}

