/*
 * Decompiled with CFR 0.152.
 */
package nxt.migration;

import nxt.Constants;
import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.env.ServerStatus;
import nxt.freeze.FreezeMonitor;
import nxt.migration.HoldingMigration;
import nxt.util.Logger;

public class MigrationMonitor {
    public static void init() {
        HoldingMigration.init();
    }

    public static void scheduleMigration(ChildChain childChain, int n) {
        if (MigrationMonitor.tryScheduleMigration(HoldingMigration.getByChildChain(childChain), n)) {
            Logger.logDebugMessage(String.format("Scheduled loading of child chain %s at height %d", childChain.getName(), n));
        } else {
            Logger.logDebugMessage(String.format("Failed to schedule loading of child chain %s at height %d, current height %d", childChain.getName(), n, Nxt.getBlockchain().getHeight()));
        }
    }

    public static void scheduleMigration(HoldingType holdingType, long l, int n) {
        HoldingMigration holdingMigration = HoldingMigration.getByHoldingId(l, holdingType);
        if (MigrationMonitor.tryScheduleMigration(holdingMigration, n)) {
            Logger.logDebugMessage(String.format("Scheduled migration of %s %s to child chain %s at height %d", holdingType.name(), Long.toUnsignedString(l), holdingMigration.getChildChain().getName(), n));
        } else {
            Logger.logDebugMessage(String.format("Failed to schedule migration of %s %s at height %d, current height %d", new Object[0]), holdingType.name(), Long.toUnsignedString(l), n, Nxt.getBlockchain().getHeight());
        }
    }

    private static boolean tryScheduleMigration(HoldingMigration holdingMigration, int n) {
        if (holdingMigration == null) {
            return false;
        }
        int n2 = Nxt.getBlockchain().getHeight();
        if (n <= n2) {
            return false;
        }
        if (holdingMigration.getActualHeight() != 0 && holdingMigration.getActualHeight() <= n2) {
            return false;
        }
        if (n < holdingMigration.getMinHeight()) {
            return false;
        }
        holdingMigration.setActualHeight(n);
        HoldingMigration.insert(holdingMigration);
        return true;
    }

    public static void enableMigration(long l, HoldingType holdingType, ChildChain childChain, int n, int n2) {
        if (!Constants.isAutomatedTest && Nxt.getServerStatus() != ServerStatus.BEFORE_DATABASE) {
            throw new IllegalStateException("Setting migration only allowed during tests or in DbVersion");
        }
        HoldingMigration holdingMigration = HoldingMigration.getByChildChain(childChain);
        if (holdingMigration != null) {
            throw new IllegalStateException("Holding migration already set: " + holdingMigration.toString());
        }
        if (n <= 0 || n2 < 0 || n2 > 0 && n2 < n) {
            throw new IllegalArgumentException(String.format("Invalid minHeight %d or actualHeight %d", n, n2));
        }
        if (holdingType != HoldingType.COIN) {
            int n3 = FreezeMonitor.getMinFreezeHeight(l, holdingType);
            if (n3 == 0) {
                throw new IllegalStateException(String.format("%s %s not enabled for freezing", holdingType.name(), Long.toUnsignedString(l)));
            }
            if (n < n3) {
                throw new IllegalArgumentException(String.format("Migration minHeight %d before freezing minHeight %d", n, n3));
            }
        }
        HoldingMigration.insert(new HoldingMigration(l, holdingType, childChain, n, n2));
    }

    public static boolean hasMigrationsAt(int n) {
        try (DbIterator<HoldingMigration> dbIterator = HoldingMigration.getMigrations(n);){
            boolean bl = dbIterator.hasNext();
            return bl;
        }
    }
}

