/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.ChildChain;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.ms.Currency;
import nxt.util.Convert;

public final class CurrencyFounderHome {
    private final ChildChain childChain;
    private final DbKey.LongLongKeyFactory<CurrencyFounder> currencyFounderDbKeyFactory;
    private final VersionedEntityDbTable<CurrencyFounder> currencyFounderTable;

    public static CurrencyFounderHome forChain(ChildChain childChain) {
        if (childChain.getCurrencyFounderHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new CurrencyFounderHome(childChain);
    }

    private CurrencyFounderHome(ChildChain childChain) {
        this.childChain = childChain;
        this.currencyFounderDbKeyFactory = new DbKey.LongLongKeyFactory<CurrencyFounder>("currency_id", "account_id"){

            @Override
            public DbKey newKey(CurrencyFounder currencyFounder) {
                return currencyFounder.dbKey;
            }
        };
        this.currencyFounderTable = new VersionedEntityDbTable<CurrencyFounder>(childChain.getSchemaTable("currency_founder"), this.currencyFounderDbKeyFactory){

            @Override
            protected CurrencyFounder load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new CurrencyFounder(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, CurrencyFounder currencyFounder) throws SQLException {
                currencyFounder.save(connection);
            }

            @Override
            public String defaultSort() {
                return " ORDER BY height DESC ";
            }
        };
    }

    private void addOrUpdateFounder(long l, long l2, long l3, long l4) {
        CurrencyFounder currencyFounder = this.getFounder(l, l2);
        if (currencyFounder == null) {
            currencyFounder = new CurrencyFounder(l, l2, l3, l4);
        } else {
            CurrencyFounder currencyFounder2 = currencyFounder;
            currencyFounder2.amountPerUnitNQT = currencyFounder2.amountPerUnitNQT + l3;
            currencyFounder2 = currencyFounder;
            currencyFounder2.amountNQT = currencyFounder2.amountNQT + l4;
        }
        this.currencyFounderTable.insert(currencyFounder);
    }

    public CurrencyFounder getFounder(long l, long l2) {
        return (CurrencyFounder)this.currencyFounderTable.get(this.currencyFounderDbKeyFactory.newKey(l, l2));
    }

    public DbIterator<CurrencyFounder> getCurrencyFounders(long l, int n, int n2) {
        return this.currencyFounderTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public DbIterator<CurrencyFounder> getFounderCurrencies(long l, int n, int n2) {
        return this.currencyFounderTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    void remove(long l) {
        ArrayList<CurrencyFounder> arrayList = new ArrayList<CurrencyFounder>();
        try (DbIterator<CurrencyFounder> dbIterator = this.getCurrencyFounders(l, 0, Integer.MAX_VALUE);){
            for (CurrencyFounder currencyFounder : dbIterator) {
                arrayList.add(currencyFounder);
            }
        }
        arrayList.forEach(this.currencyFounderTable::delete);
    }

    void increaseReserve(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, Account account, long l, long l2) {
        Currency currency = Currency.getCurrency(l);
        long l3 = Convert.unitRateToAmount(currency.getReserveSupplyQNT(), currency.getDecimals(), l2, this.childChain.getDecimals());
        account.addToBalance(this.childChain, ledgerEvent, ledgerEventId, -l3);
        currency.increaseReserve(l2);
        this.addOrUpdateFounder(l, account.getId(), l2, l3);
    }

    public final class CurrencyFounder {
        private final DbKey dbKey;
        private final long currencyId;
        private final long accountId;
        private long amountPerUnitNQT;
        private long amountNQT;

        private CurrencyFounder(long l, long l2, long l3, long l4) {
            this.currencyId = l;
            this.dbKey = CurrencyFounderHome.this.currencyFounderDbKeyFactory.newKey(l, l2);
            this.accountId = l2;
            this.amountPerUnitNQT = l3;
            this.amountNQT = l4;
        }

        private CurrencyFounder(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.currencyId = resultSet.getLong("currency_id");
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.amountPerUnitNQT = resultSet.getLong("amount_per_unit");
            this.amountNQT = resultSet.getLong("amount");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency_founder (currency_id, account_id, amount_per_unit, amount, height, latest) KEY (currency_id, account_id, height) VALUES (?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.getCurrencyId());
                preparedStatement.setLong(++n, this.getAccountId());
                preparedStatement.setLong(++n, this.getAmountPerUnitNQT());
                preparedStatement.setLong(++n, this.getAmountNQT());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getAmountPerUnitNQT() {
            return this.amountPerUnitNQT;
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }

        public ChildChain getChildChain() {
            return CurrencyFounderHome.this.childChain;
        }
    }
}

