/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.util.Map;
import java.util.stream.Collectors;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.db.DbIterator;
import nxt.migration.HoldingSnapshot;

class CurrencySnapshot
extends HoldingSnapshot {
    CurrencySnapshot() {
        super(HoldingType.CURRENCY);
    }

    @Override
    protected Map<String, Long> takeSnapshot(long l) {
        try (DbIterator<Account.AccountCurrency> dbIterator = Account.getCurrencyAccounts(l, -1, -1);){
            Map<String, Long> map = dbIterator.stream().collect(Collectors.toMap(accountCurrency -> Long.toUnsignedString(accountCurrency.getAccountId()), Account.AccountCurrency::getUnits));
            return map;
        }
    }
}

