/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.ms.MonetarySystemAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class ExchangeAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long currencyId;
    private final long rateNQT;
    private final long unitsQNT;

    ExchangeAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.currencyId = byteBuffer.getLong();
        this.rateNQT = byteBuffer.getLong();
        this.unitsQNT = byteBuffer.getLong();
    }

    ExchangeAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        this.rateNQT = Convert.parseLong(jSONObject.get((Object)"rateNQTPerUnit"));
        this.unitsQNT = Convert.parseLong(jSONObject.get((Object)"unitsQNT"));
    }

    ExchangeAttachment(long l, long l2, long l3) {
        this.currencyId = l;
        this.rateNQT = l2;
        this.unitsQNT = l3;
    }

    @Override
    protected int getMySize() {
        return 24;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.currencyId);
        byteBuffer.putLong(this.rateNQT);
        byteBuffer.putLong(this.unitsQNT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
        jSONObject.put((Object)"rateNQTPerUnit", (Object)this.rateNQT);
        jSONObject.put((Object)"unitsQNT", (Object)this.unitsQNT);
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getRateNQT() {
        return this.rateNQT;
    }

    public long getUnitsQNT() {
        return this.unitsQNT;
    }
}

