/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class PublishExchangeOfferAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long currencyId;
    private final long buyRateNQT;
    private final long sellRateNQT;
    private final long totalBuyLimitQNT;
    private final long totalSellLimitQNT;
    private final long initialBuySupplyQNT;
    private final long initialSellSupplyQNT;
    private final int expirationHeight;

    public PublishExchangeOfferAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.currencyId = byteBuffer.getLong();
        this.buyRateNQT = byteBuffer.getLong();
        this.sellRateNQT = byteBuffer.getLong();
        this.totalBuyLimitQNT = byteBuffer.getLong();
        this.totalSellLimitQNT = byteBuffer.getLong();
        this.initialBuySupplyQNT = byteBuffer.getLong();
        this.initialSellSupplyQNT = byteBuffer.getLong();
        this.expirationHeight = byteBuffer.getInt();
    }

    public PublishExchangeOfferAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        this.buyRateNQT = Convert.parseLong(jSONObject.get((Object)"buyRateNQTPerUnit"));
        this.sellRateNQT = Convert.parseLong(jSONObject.get((Object)"sellRateNQTPerUnit"));
        this.totalBuyLimitQNT = Convert.parseLong(jSONObject.get((Object)"totalBuyLimitQNT"));
        this.totalSellLimitQNT = Convert.parseLong(jSONObject.get((Object)"totalSellLimitQNT"));
        this.initialBuySupplyQNT = Convert.parseLong(jSONObject.get((Object)"initialBuySupplyQNT"));
        this.initialSellSupplyQNT = Convert.parseLong(jSONObject.get((Object)"initialSellSupplyQNT"));
        this.expirationHeight = Convert.parseInt(jSONObject.get((Object)"expirationHeight"));
    }

    public PublishExchangeOfferAttachment(long l, long l2, long l3, long l4, long l5, long l6, long l7, int n) {
        this.currencyId = l;
        this.buyRateNQT = l2;
        this.sellRateNQT = l3;
        this.totalBuyLimitQNT = l4;
        this.totalSellLimitQNT = l5;
        this.initialBuySupplyQNT = l6;
        this.initialSellSupplyQNT = l7;
        this.expirationHeight = n;
    }

    @Override
    protected int getMySize() {
        return 60;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.currencyId);
        byteBuffer.putLong(this.buyRateNQT);
        byteBuffer.putLong(this.sellRateNQT);
        byteBuffer.putLong(this.totalBuyLimitQNT);
        byteBuffer.putLong(this.totalSellLimitQNT);
        byteBuffer.putLong(this.initialBuySupplyQNT);
        byteBuffer.putLong(this.initialSellSupplyQNT);
        byteBuffer.putInt(this.expirationHeight);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
        jSONObject.put((Object)"buyRateNQTPerUnit", (Object)this.buyRateNQT);
        jSONObject.put((Object)"sellRateNQTPerUnit", (Object)this.sellRateNQT);
        jSONObject.put((Object)"totalBuyLimitQNT", (Object)this.totalBuyLimitQNT);
        jSONObject.put((Object)"totalSellLimitQNT", (Object)this.totalSellLimitQNT);
        jSONObject.put((Object)"initialBuySupplyQNT", (Object)this.initialBuySupplyQNT);
        jSONObject.put((Object)"initialSellSupplyQNT", (Object)this.initialSellSupplyQNT);
        jSONObject.put((Object)"expirationHeight", (Object)this.expirationHeight);
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER;
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getBuyRateNQT() {
        return this.buyRateNQT;
    }

    public long getSellRateNQT() {
        return this.sellRateNQT;
    }

    public long getTotalBuyLimitQNT() {
        return this.totalBuyLimitQNT;
    }

    public long getTotalSellLimitQNT() {
        return this.totalSellLimitQNT;
    }

    public long getInitialBuySupplyQNT() {
        return this.initialBuySupplyQNT;
    }

    public long getInitialSellSupplyQNT() {
        return this.initialSellSupplyQNT;
    }

    public int getExpirationHeight() {
        return this.expirationHeight;
    }
}

