/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.ArrayList;
import java.util.List;
import nxt.Nxt;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.peer.NetworkMessage;
import nxt.peer.PeerImpl;
import nxt.peer.TransactionsInventory;

final class GetTransactions {
    private GetTransactions() {
    }

    static NetworkMessage processRequest(PeerImpl peerImpl, NetworkMessage.GetTransactionsMessage getTransactionsMessage) {
        List<ChainTransactionId> list = getTransactionsMessage.getTransactionIds();
        if (list.size() > 100) {
            throw new IllegalArgumentException("Too many transactions request");
        }
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>(list.size());
        for (ChainTransactionId chainTransactionId : list) {
            Transaction transaction = TransactionsInventory.getCachedTransaction(chainTransactionId);
            if (transaction == null) {
                transaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(chainTransactionId.getTransactionId());
            }
            if (transaction == null) {
                transaction = chainTransactionId.getTransaction();
            }
            if (transaction == null) continue;
            transaction.getAppendages(true);
            arrayList.add(transaction);
        }
        return new NetworkMessage.TransactionsMessage(getTransactionsMessage.getMessageId(), arrayList);
    }
}

