/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.Set;
import nxt.http.APIEnum;
import nxt.peer.NetworkMessage;

public interface Peer {
    public State getState();

    public String getHost();

    public String getAnnouncedAddress();

    public long getDownloadedVolume();

    public long getUploadedVolume();

    public String getApplication();

    public String getVersion();

    public String getPlatform();

    public String getSoftware();

    public int getPort();

    public int getApiPort();

    public int getApiSSLPort();

    public boolean shareAddress();

    public Set<APIEnum> getDisabledAPIs();

    public int getApiServerIdleTimeout();

    public BlockchainState getBlockchainState();

    public boolean isBlacklisted();

    public String getBlacklistingCause();

    public void connectPeer();

    public void disconnectPeer();

    public void blacklist(Exception var1);

    public void blacklist(String var1);

    public void unBlacklist();

    public int getLastUpdated();

    public int getLastConnectAttempt();

    public boolean isInbound();

    public boolean providesService(Service var1);

    public boolean isOpenAPI();

    public boolean isApiConnectable();

    public StringBuilder getPeerApiUri();

    public boolean providesServices(long var1);

    public void sendMessage(NetworkMessage var1);

    public NetworkMessage sendRequest(NetworkMessage var1);

    public static enum BlockchainState {
        UP_TO_DATE,
        DOWNLOADING,
        LIGHT_CLIENT,
        FORK;

    }

    public static enum Service {
        HALLMARK(1),
        PRUNABLE(2),
        API(4),
        API_SSL(8),
        CORS(16);

        private final long code;

        private Service(int n2) {
            this.code = n2;
        }

        public long getCode() {
            return this.code;
        }
    }

    public static enum State {
        NON_CONNECTED,
        CONNECTED,
        DISCONNECTED;

    }
}

