/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.TransactionType;
import nxt.shuffling.AbstractShufflingAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ShufflingRecipientsAttachment
extends AbstractShufflingAttachment {
    private final byte[][] recipientPublicKeys;

    ShufflingRecipientsAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        int n = byteBuffer.get();
        if (n > 30 || n < 0) {
            throw new NxtException.NotValidException("Invalid data count " + n);
        }
        this.recipientPublicKeys = new byte[n][];
        for (int i = 0; i < n; ++i) {
            this.recipientPublicKeys[i] = new byte[32];
            byteBuffer.get(this.recipientPublicKeys[i]);
        }
    }

    ShufflingRecipientsAttachment(JSONObject jSONObject) {
        super(jSONObject);
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"recipientPublicKeys");
        this.recipientPublicKeys = new byte[jSONArray.size()][];
        for (int i = 0; i < this.recipientPublicKeys.length; ++i) {
            this.recipientPublicKeys[i] = Convert.parseHexString((String)jSONArray.get(i));
        }
    }

    ShufflingRecipientsAttachment(byte[] byArray, byte[][] byArray2, byte[] byArray3) {
        super(byArray, byArray3);
        this.recipientPublicKeys = byArray2;
    }

    @Override
    protected int getMySize() {
        int n = super.getMySize();
        ++n;
        return n += 32 * this.recipientPublicKeys.length;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        super.putMyBytes(byteBuffer);
        byteBuffer.put((byte)this.recipientPublicKeys.length);
        for (byte[] byArray : this.recipientPublicKeys) {
            byteBuffer.put(byArray);
        }
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        super.putMyJSON(jSONObject);
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"recipientPublicKeys", (Object)jSONArray);
        for (byte[] byArray : this.recipientPublicKeys) {
            jSONArray.add((Object)Convert.toHexString(byArray));
        }
    }

    @Override
    public TransactionType getTransactionType() {
        return ShufflingTransactionType.SHUFFLING_RECIPIENTS;
    }

    public byte[][] getRecipientPublicKeys() {
        return this.recipientPublicKeys;
    }
}

