/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nxt.util.security.BlockchainPermission;

public final class VerifyTraceFile {
    private static final List<String> balanceHeaders = Arrays.asList("balance", "unconfirmed balance");
    private static final List<String> deltaHeaders = Arrays.asList("transaction amount", "transaction fee", "dividend", "generation fee", "trade cost", "purchase cost", "discount", "refund", "exchange cost", "currency cost");
    private static final List<String> assetQuantityHeaders = Arrays.asList("asset balance", "unconfirmed asset balance");
    private static final List<String> deltaAssetQuantityHeaders = Arrays.asList("asset quantity", "trade quantity");
    private static final List<String> currencyBalanceHeaders = Arrays.asList("currency balance", "unconfirmed currency balance");
    private static final List<String> deltaCurrencyUnitHeaders = Arrays.asList("currency units", "exchange quantity");
    private static final String beginQuote = "^\"";
    private static final String endQuote = "\"$";

    private static boolean isBalance(String string) {
        return balanceHeaders.contains(string);
    }

    private static boolean isDelta(String string) {
        return deltaHeaders.contains(string);
    }

    private static boolean isAssetQuantity(String string) {
        return assetQuantityHeaders.contains(string);
    }

    private static boolean isDeltaAssetQuantity(String string) {
        return deltaAssetQuantityHeaders.contains(string);
    }

    private static boolean isCurrencyBalance(String string) {
        return currencyBalanceHeaders.contains(string);
    }

    private static boolean isDeltaCurrencyUnits(String string) {
        return deltaCurrencyUnitHeaders.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        String string2 = stringArray.length == 1 ? stringArray[0] : "nxt-trace.csv";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));){
            Object object4;
            Object object2;
            HashSet<String> hashSet2;
            String[] stringArray2;
            String string3 = bufferedReader.readLine();
            String[] stringArray3 = VerifyTraceFile.unquote(string3.split("\t"));
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
            HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
            HashMap<Object, Long> hashMap4 = new HashMap<Object, Long>();
            HashMap<String, Map> hashMap5 = new HashMap<String, Map>();
            HashMap<String, Long> hashMap6 = new HashMap<String, Long>();
            HashMap<Object, Long> hashMap7 = new HashMap<Object, Long>();
            while ((string3 = bufferedReader.readLine()) != null) {
                void var16_21;
                stringArray2 = VerifyTraceFile.unquote(string3.split("\t"));
                hashSet2 = new HashMap();
                boolean i = false;
                while (var16_21 < stringArray3.length) {
                    hashSet2.put(stringArray3[var16_21], stringArray2[var16_21]);
                    ++var16_21;
                }
                String hashSet3 = (String)hashSet2.get("account");
                Map map = hashMap.computeIfAbsent(hashSet3, string -> new HashMap());
                Map map2 = hashMap2.computeIfAbsent(hashSet3, string -> new HashMap());
                String string4 = (String)hashSet2.get("event");
                if ("asset issuance".equals(string4)) {
                    String string5 = (String)hashSet2.get("asset");
                    hashMap3.put(string5, Long.parseLong((String)hashSet2.get("asset quantity")));
                }
                if ("asset delete".equals(string4)) {
                    String string6 = (String)hashSet2.get("asset");
                    long l = -Long.parseLong((String)hashSet2.get("asset quantity"));
                    long l2 = (Long)hashMap3.get(string6);
                    hashMap3.put(string6, l2 - l);
                }
                Map map3 = hashMap5.computeIfAbsent(hashSet3, string -> new HashMap());
                if ("currency issuance".equals(string4)) {
                    String string7 = (String)hashSet2.get("currency");
                    hashMap6.put(string7, Long.parseLong((String)hashSet2.get("currency units")));
                }
                if ("crowdfunding".equals(string4)) {
                    String string8 = (String)hashSet2.get("currency");
                    hashMap6.put(string8, Long.parseLong((String)hashSet2.get("crowdfunding")));
                }
                if ("currency mint".equals(string4)) {
                    String string9 = (String)hashSet2.get("currency");
                    hashMap6.put(string9, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string9)), Long.parseLong((String)hashSet2.get("currency units"))));
                }
                if ("currency claim".equals(string4)) {
                    String string10 = (String)hashSet2.get("currency");
                    hashMap6.put(string10, Math.addExact(VerifyTraceFile.nullToZero((Long)hashMap6.get(string10)), Long.parseLong((String)hashSet2.get("currency units"))));
                }
                if ("currency delete".equals(string4) || "undo crowdfunding".equals(string4)) {
                    String string11 = (String)hashSet2.get("currency");
                    hashMap6.put(string11, 0L);
                }
                for (Map.Entry entry : hashSet2.entrySet()) {
                    long l;
                    String string12 = (String)entry.getKey();
                    object2 = (String)entry.getValue();
                    if (object2 == null || "".equals(((String)object2).trim())) continue;
                    if (VerifyTraceFile.isBalance(string12)) {
                        map.put(string12, Long.parseLong((String)object2));
                        continue;
                    }
                    if (VerifyTraceFile.isDelta(string12)) {
                        long l3 = VerifyTraceFile.nullToZero((Long)map.get(string12));
                        map.put(string12, Math.addExact(l3, Long.parseLong((String)object2)));
                        continue;
                    }
                    if (VerifyTraceFile.isAssetQuantity(string12)) {
                        String string13 = (String)hashSet2.get("asset");
                        object4 = map2.computeIfAbsent(string13, string -> new HashMap());
                        object4.put(string12, Long.parseLong((String)object2));
                        continue;
                    }
                    if (VerifyTraceFile.isDeltaAssetQuantity(string12)) {
                        String string14 = (String)hashSet2.get("asset");
                        object4 = map2.computeIfAbsent(string14, string -> new HashMap());
                        l = VerifyTraceFile.nullToZero((Long)object4.get(string12));
                        object4.put(string12, Math.addExact(l, Long.parseLong((String)object2)));
                        continue;
                    }
                    if (VerifyTraceFile.isCurrencyBalance(string12)) {
                        String string15 = (String)hashSet2.get("currency");
                        object4 = map3.computeIfAbsent(string15, string -> new HashMap());
                        object4.put(string12, Long.parseLong((String)object2));
                        continue;
                    }
                    if (!VerifyTraceFile.isDeltaCurrencyUnits(string12)) continue;
                    String string16 = (String)hashSet2.get("currency");
                    object4 = map3.computeIfAbsent(string16, string -> new HashMap());
                    l = VerifyTraceFile.nullToZero((Long)object4.get(string12));
                    object4.put(string12, Math.addExact(l, Long.parseLong((String)object2)));
                }
            }
            stringArray2 = new HashSet();
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object3;
                String string17 = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                System.out.println("account: " + string17);
                for (String string18 : balanceHeaders) {
                    System.out.println(string18 + ": " + VerifyTraceFile.nullToZero((Long)map.get(string18)));
                }
                System.out.println("totals:");
                long l = 0L;
                for (String string19 : deltaHeaders) {
                    long l4 = VerifyTraceFile.nullToZero((Long)map.get(string19));
                    l = Math.addExact(l, l4);
                    System.out.println(string19 + ": " + l4);
                }
                System.out.println("total confirmed balance change: " + l);
                long l5 = VerifyTraceFile.nullToZero((Long)map.get("balance"));
                if (l5 != l) {
                    System.out.println("ERROR: balance doesn't match total change!!!");
                    stringArray2.add(string17);
                }
                Map map4 = (Map)hashMap2.get(string17);
                for (Map.Entry entry2 : map4.entrySet()) {
                    long l6;
                    object4 = (String)entry2.getKey();
                    object3 = (Map)entry2.getValue();
                    System.out.println("asset: " + (String)object4);
                    for (Map.Entry entry3 : object3.entrySet()) {
                        System.out.println((String)entry3.getKey() + ": " + entry3.getValue());
                    }
                    long l7 = 0L;
                    for (String string20 : deltaAssetQuantityHeaders) {
                        l6 = VerifyTraceFile.nullToZero((Long)object3.get(string20));
                        l7 = Math.addExact(l7, l6);
                    }
                    System.out.println("total confirmed asset quantity change: " + l7);
                    long l8 = VerifyTraceFile.nullToZero((Long)object3.get("asset balance"));
                    if (l8 != l7) {
                        System.out.println("ERROR: asset balance doesn't match total asset quantity change!!!");
                        stringArray2.add(string17);
                    }
                    l6 = VerifyTraceFile.nullToZero((Long)hashMap4.get(object4));
                    hashMap4.put(object4, Math.addExact(l6, l8));
                }
                object2 = (Map)hashMap5.get(string17);
                for (Object object4 : object2.entrySet()) {
                    long l9;
                    object3 = (String)object4.getKey();
                    Map map5 = (Map)object4.getValue();
                    System.out.println("currency: " + (String)object3);
                    for (Map.Entry entry4 : map5.entrySet()) {
                        System.out.println((String)entry4.getKey() + ": " + entry4.getValue());
                    }
                    long l10 = 0L;
                    for (String string21 : deltaCurrencyUnitHeaders) {
                        l9 = VerifyTraceFile.nullToZero((Long)map5.get(string21));
                        l10 = Math.addExact(l10, l9);
                    }
                    System.out.println("total confirmed currency units change: " + l10);
                    long l11 = VerifyTraceFile.nullToZero((Long)map5.get("currency balance"));
                    if (l11 != l10) {
                        System.out.println("ERROR: currency balance doesn't match total currency units change!!!");
                        stringArray2.add(string17);
                    }
                    l9 = VerifyTraceFile.nullToZero((Long)hashMap7.get(object3));
                    hashMap7.put(object3, Math.addExact(l9, l11));
                }
                System.out.println();
            }
            hashSet2 = new HashSet<String>();
            for (Map.Entry entry : hashMap3.entrySet()) {
                String string22 = (String)entry.getKey();
                long l = (Long)entry.getValue();
                if (l == VerifyTraceFile.nullToZero((Long)hashMap4.get(string22))) continue;
                System.out.println("ERROR: asset " + string22 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap4.get(string22));
                hashSet2.add(string22);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : hashMap6.entrySet()) {
                String string23 = (String)entry.getKey();
                long l = (Long)entry.getValue();
                if (l == VerifyTraceFile.nullToZero((Long)hashMap7.get(string23))) continue;
                System.out.println("ERROR: currency " + string23 + " balances don't match, issued: " + l + ", total of account balances: " + hashMap7.get(string23));
                hashSet.add(string23);
            }
            if (stringArray2.size() > 0) {
                System.out.println("ERROR: " + stringArray2.size() + " accounts have incorrect balances");
                System.out.println(stringArray2);
            } else {
                System.out.println("SUCCESS: all " + hashMap.size() + " account balances and asset balances match the transaction and trade totals!");
            }
            if (hashSet2.size() > 0) {
                System.out.println("ERROR: " + hashSet2.size() + " assets have incorrect balances");
                System.out.println(hashSet2);
            } else {
                System.out.println("SUCCESS: all " + hashMap3.size() + " assets quantities are correct!");
            }
            if (hashSet.size() > 0) {
                System.out.println("ERROR: " + hashSet.size() + " currencies have incorrect balances");
                System.out.println(hashSet);
            } else {
                System.out.println("SUCCESS: all " + hashMap6.size() + " currency units are correct!");
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            throw new RuntimeException(iOException);
        }
    }

    private static String[] unquote(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replaceFirst(beginQuote, "").replaceFirst(endQuote, "");
        }
        return stringArray2;
    }

    private static long nullToZero(Long l) {
        return l == null ? 0L : l;
    }
}

