/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.concurrent.atomic.AtomicInteger;
import nxt.util.Convert;

public interface Time {
    public int getTime();

    public static final class CounterTime
    implements Time {
        private final AtomicInteger counter;

        public CounterTime(int n) {
            this.counter = new AtomicInteger(n);
        }

        @Override
        public int getTime() {
            return this.counter.incrementAndGet();
        }
    }

    public static final class FasterTime
    implements Time {
        private final int multiplier;
        private final long systemStartTime;
        private final int time;

        public FasterTime(int n, int n2) {
            if (n2 > 1000 || n2 <= 0) {
                throw new IllegalArgumentException("Time multiplier must be between 1 and 1000");
            }
            this.multiplier = n2;
            this.time = n;
            this.systemStartTime = System.currentTimeMillis();
        }

        @Override
        public int getTime() {
            return this.time + (int)((System.currentTimeMillis() - this.systemStartTime) / (long)(1000 / this.multiplier));
        }
    }

    public static final class ConstantTime
    implements Time {
        private final int time;

        public ConstantTime(int n) {
            this.time = n;
        }

        @Override
        public int getTime() {
            return this.time;
        }
    }

    public static final class EpochTime
    implements Time {
        @Override
        public int getTime() {
            return Convert.toEpochTime(System.currentTimeMillis());
        }
    }
}

