/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.bbh;

import java.nio.ByteBuffer;
import java.util.function.ToIntFunction;
import nxt.util.bbh.IntConsumer;
import nxt.util.bbh.LengthRw;

public enum LengthRwPrimitiveType implements LengthRw
{
    BYTE(1, 127, ByteBuffer::get, (byteBuffer, n) -> byteBuffer.put((byte)n)),
    UBYTE(1, 255, byteBuffer -> byteBuffer.get() & 0xFF, (byteBuffer, n) -> byteBuffer.put((byte)n)),
    SHORT(2, Short.MAX_VALUE, ByteBuffer::getShort, (byteBuffer, n) -> byteBuffer.putShort((short)n)),
    INTEGER(4, Integer.MAX_VALUE, ByteBuffer::getInt, ByteBuffer::putInt);

    private final int size;
    private final int maxLength;
    private final ToIntFunction<ByteBuffer> readLength;
    private final IntConsumer<ByteBuffer> writeLength;

    private LengthRwPrimitiveType(int n2, int n3, ToIntFunction<ByteBuffer> toIntFunction, IntConsumer<ByteBuffer> intConsumer) {
        this.size = n2;
        this.maxLength = n3;
        this.readLength = toIntFunction;
        this.writeLength = intConsumer;
    }

    static LengthRw getByMaxLength(int n) {
        LengthRwPrimitiveType lengthRwPrimitiveType = null;
        LengthRwPrimitiveType lengthRwPrimitiveType2 = null;
        for (LengthRwPrimitiveType lengthRwPrimitiveType3 : LengthRwPrimitiveType.values()) {
            if (lengthRwPrimitiveType != null && lengthRwPrimitiveType3.maxLength < lengthRwPrimitiveType.maxLength) {
                throw new RuntimeException("Primitive types not ordered according to their max length");
            }
            if (lengthRwPrimitiveType2 == null && n <= lengthRwPrimitiveType3.maxLength) {
                lengthRwPrimitiveType2 = lengthRwPrimitiveType3;
            }
            lengthRwPrimitiveType = lengthRwPrimitiveType3;
        }
        return lengthRwPrimitiveType2;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int readFromBuffer(ByteBuffer byteBuffer) {
        return this.readLength.applyAsInt(byteBuffer);
    }

    @Override
    public void writeToBuffer(ByteBuffer byteBuffer, int n) {
        this.writeLength.consume(byteBuffer, n);
    }

    @Override
    public boolean validate(int n) {
        return n >= 0 && n <= this.maxLength;
    }
}

