/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.bbh;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.util.Convert;
import nxt.util.bbh.LengthRw;

class StringLengthRw
implements LengthRw {
    private final LengthRw lengthRw;
    private final int maxCharCount;

    StringLengthRw(LengthRw lengthRw, int n) {
        this.lengthRw = lengthRw;
        this.maxCharCount = n;
    }

    @Override
    public int getSize() {
        return this.lengthRw.getSize();
    }

    @Override
    public int readFromBuffer(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        int n = this.lengthRw.readFromBuffer(byteBuffer);
        if (!this.validate(n)) {
            throw new NxtException.NotValidException("Read invalid length " + n);
        }
        return n;
    }

    @Override
    public void writeToBuffer(ByteBuffer byteBuffer, int n) {
        this.lengthRw.writeToBuffer(byteBuffer, n);
    }

    @Override
    public boolean validate(int n) {
        return this.lengthRw.validate(n) && n <= Convert.getMaxStringSize(this.maxCharCount);
    }

    public int getMaxCharCount() {
        return this.maxCharCount;
    }
}

