/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import nxt.NxtException;
import nxt.blockchain.ChildTransaction;
import nxt.util.BooleanExpression;
import nxt.voting.AbstractPoll;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingParams;
import nxt.voting.VoteWeighting;

public abstract class PhasingControl {
    protected PhasingParams params;

    protected PhasingControl() {
    }

    protected PhasingControl(PhasingParams phasingParams) {
        this.params = phasingParams;
    }

    protected void init(ResultSet resultSet, Supplier<List<? extends SubPoll>> supplier) throws SQLException {
        Object object;
        Object object2;
        VoteWeighting voteWeighting = AbstractPoll.readVoteWeighting(resultSet);
        long[] lArray = PhasingParams.readWhitelist(resultSet);
        PhasingParams.CompositeVoting compositeVoting = null;
        if (voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
            object2 = supplier.get();
            object = new TreeMap();
            object2.forEach(subPoll -> object.put(subPoll.getVariableName(), subPoll.getParams()));
            compositeVoting = new PhasingParams.CompositeVoting(resultSet.getString("expression"), (SortedMap<String, PhasingParams>)object);
        }
        object2 = PhasingParams.readPropertyVoting(resultSet, "sender_", voteWeighting);
        object = PhasingParams.readPropertyVoting(resultSet, "recipient_", voteWeighting);
        this.params = new PhasingParams(voteWeighting, resultSet.getLong("quorum"), lArray, Collections.emptyList(), null, compositeVoting, (PhasingParams.PropertyVoting)object2, (PhasingParams.PropertyVoting)object);
    }

    protected final void checkPhasing(PhasingAppendix phasingAppendix) throws NxtException.AccountControlException {
        block9: {
            if (phasingAppendix == null) {
                throw new NxtException.AccountControlException("Non-phased transaction when phasing " + this.getControlType() + " control is enabled");
            }
            PhasingParams phasingParams = phasingAppendix.getParams();
            if (phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
                Map<String, PhasingParams> map;
                BooleanExpression booleanExpression;
                SortedMap<String, PhasingParams> sortedMap = phasingParams.getSubPolls();
                BooleanExpression booleanExpression2 = phasingParams.getExpression();
                if (this.params.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
                    booleanExpression = this.params.getExpression();
                    map = this.params.getSubPolls();
                } else {
                    booleanExpression = new BooleanExpression(this.getDefaultControlVariable());
                    map = Collections.singletonMap(this.getDefaultControlVariable(), this.params);
                }
                HashSet hashSet = new HashSet(map.keySet());
                hashSet.retainAll(sortedMap.keySet());
                for (String string : hashSet) {
                    PhasingParams phasingParams2;
                    PhasingParams phasingParams3 = (PhasingParams)sortedMap.get(string);
                    if (phasingParams3.equals(phasingParams2 = map.get(string))) continue;
                    throw new NxtException.AccountControlException("Sub-poll for variable \"" + string + "\" does not match the sub-poll for the same variable in " + this.getControlType() + " control. Expected: " + phasingParams2.toString() + ". Actual: " + phasingParams3.toString());
                }
                try {
                    if (!BooleanExpression.fastImplicationCheck(booleanExpression2, booleanExpression)) {
                        throw new NxtException.AccountControlException("Phasing expression does not imply the " + this.getControlType() + " control expression, i.e. it is less restrictive. Phasing expression: \"" + phasingParams.getExpressionStr() + "\". Control expression: \"" + this.params.getExpressionStr() + "\"");
                    }
                    break block9;
                }
                catch (BooleanExpression.BooleanExpressionException booleanExpressionException) {
                    throw new NxtException.AccountControlException("Failed to parse boolean expression \"" + booleanExpressionException.getMessage() + "\"", booleanExpressionException);
                }
            }
            if (!this.params.equals(phasingParams)) {
                throw new NxtException.AccountControlException("Phasing parameters do not match phasing " + this.getControlType() + " control. Expected: " + this.params.toString() + " . Actual: " + phasingParams.toString());
            }
        }
    }

    public final PhasingParams getPhasingParams() {
        return this.params;
    }

    public abstract String getControlType();

    public abstract String getDefaultControlVariable();

    protected abstract void checkTransaction(ChildTransaction var1) throws NxtException.AccountControlException;

    public static abstract class SubPoll {
        protected final String variableName;
        protected final PhasingParams params;

        protected SubPoll(String string, PhasingParams phasingParams) {
            this.variableName = string;
            this.params = phasingParams;
        }

        protected SubPoll(ResultSet resultSet) throws SQLException {
            this.variableName = resultSet.getString("name");
            VoteWeighting voteWeighting = AbstractPoll.readVoteWeighting(resultSet);
            long[] lArray = PhasingParams.readWhitelist(resultSet);
            PhasingParams.PropertyVoting propertyVoting = PhasingParams.readPropertyVoting(resultSet, "sender_", voteWeighting);
            PhasingParams.PropertyVoting propertyVoting2 = PhasingParams.readPropertyVoting(resultSet, "recipient_", voteWeighting);
            this.params = new PhasingParams(voteWeighting, resultSet.getLong("quorum"), lArray, null, null, null, propertyVoting, propertyVoting2);
        }

        public String getVariableName() {
            return this.variableName;
        }

        public PhasingParams getParams() {
            return this.params;
        }
    }
}

