/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.crypto.HashFunction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.DerivedDbTable;
import nxt.db.EntityDbTable;
import nxt.db.ValuesDbTable;
import nxt.util.BooleanExpression;
import nxt.util.Convert;
import nxt.voting.AbstractPoll;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingParams;
import nxt.voting.PhasingVoteCastingAttachment;
import nxt.voting.PhasingVoteHome;
import nxt.voting.VoteWeighting;

public final class PhasingPollHome {
    public static final Set<HashFunction> acceptedHashFunctions = Collections.unmodifiableSet(EnumSet.of(HashFunction.SHA256, HashFunction.RIPEMD160, HashFunction.RIPEMD160_SHA256));
    private static final DerivedDbTable phasingPollFinishTable = new DerivedDbTable("public.phasing_poll_finish"){};
    public static final Comparator<ChildTransaction> finishingTransactionsComparator = Comparator.comparingInt(Transaction::getHeight).thenComparingInt(Transaction::getIndex).thenComparingLong(Transaction::getId);
    private static final DbKey.HashKeyFactory<PhasingPoll> linkedTransactionDbKeyFactory = new DbKey.HashKeyFactory<PhasingPoll>("transaction_full_hash", "transaction_id"){

        @Override
        public DbKey newKey(PhasingPoll phasingPoll) {
            return phasingPoll.dbKey == null ? this.newKey(phasingPoll.hash, phasingPoll.id) : phasingPoll.dbKey;
        }
    };
    private static final ValuesDbTable<PhasingPoll, LinkedTransaction> linkedTransactionTable = new ValuesDbTable<PhasingPoll, LinkedTransaction>("public.phasing_poll_linked_transaction", linkedTransactionDbKeyFactory){

        @Override
        protected LinkedTransaction load(Connection connection, ResultSet resultSet) throws SQLException {
            return new LinkedTransaction(resultSet);
        }

        @Override
        protected void save(Connection connection, PhasingPoll phasingPoll, LinkedTransaction linkedTransaction) throws SQLException {
            linkedTransaction.save(connection, phasingPoll);
        }
    };
    private static final DbKey.HashHashLongKeyFactory<HashedSecretPhasedTransaction> hashedSecretPhasedTransactionDbKeyFactory = new DbKey.HashHashLongKeyFactory<HashedSecretPhasedTransaction>("hashed_secret", "hashed_secret_id", "transaction_full_hash", "transaction_id", "algorithm"){

        @Override
        public DbKey newKey(HashedSecretPhasedTransaction hashedSecretPhasedTransaction) {
            return hashedSecretPhasedTransaction.dbKey;
        }
    };
    private static final EntityDbTable<HashedSecretPhasedTransaction> hashedSecretPhasedTransactionTable = new EntityDbTable<HashedSecretPhasedTransaction>("public.phasing_poll_hashed_secret", hashedSecretPhasedTransactionDbKeyFactory){

        @Override
        protected HashedSecretPhasedTransaction load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new HashedSecretPhasedTransaction(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, HashedSecretPhasedTransaction hashedSecretPhasedTransaction) throws SQLException {
            hashedSecretPhasedTransaction.save(connection);
        }
    };
    private static final DbKey.HashKeyFactory<PhasingPollResult> resultDbKeyFactory = new DbKey.HashKeyFactory<PhasingPollResult>("full_hash", "id"){

        @Override
        public DbKey newKey(PhasingPollResult phasingPollResult) {
            return phasingPollResult.dbKey;
        }
    };
    private static final EntityDbTable<PhasingPollResult> resultTable = new EntityDbTable<PhasingPollResult>("public.phasing_poll_result", resultDbKeyFactory){

        @Override
        protected PhasingPollResult load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingPollResult(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingPollResult phasingPollResult) throws SQLException {
            phasingPollResult.save(connection);
        }
    };
    private final ChildChain childChain;
    private final PhasingVoteHome phasingVoteHome;
    private final DbKey.HashKeyFactory<PhasingPoll> phasingPollDbKeyFactory;
    private final EntityDbTable<PhasingPoll> phasingPollTable;
    private final DbKey.HashKeyFactory<PhasingPoll> votersDbKeyFactory;
    private final ValuesDbTable<PhasingPoll, PhasingPollVoter> votersTable;
    private final DbKey.HashKeyFactory<PhasingPoll> subPollsDbKeyFactory;
    private final ValuesDbTable<PhasingPoll, PhasingSubPoll> subPollsTable;

    public static HashFunction getHashFunction(byte by) {
        try {
            HashFunction hashFunction = HashFunction.getHashFunction(by);
            if (acceptedHashFunctions.contains((Object)hashFunction)) {
                return hashFunction;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static PhasingPollHome forChain(ChildChain childChain) {
        if (childChain.getPhasingPollHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new PhasingPollHome(childChain);
    }

    /*
     * Exception decompiling
     */
    public static List<? extends ChildTransaction> getFinishingTransactions(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean hasUnfinishedPhasedTransaction(long var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean checkSecretMatch(byte[] byArray, PhasingParams phasingParams) {
        HashFunction hashFunction = PhasingPollHome.getHashFunction(phasingParams.getAlgorithm());
        return hashFunction != null && Arrays.equals(phasingParams.getHashedSecret(), hashFunction.hash(byArray));
    }

    public static List<? extends ChildTransaction> getLinkedPhasedTransactions(Transaction transaction) {
        return PhasingPollHome.getLinkedPhasedTransactions(transaction.getFullHash(), transaction.getId());
    }

    public static List<? extends ChildTransaction> getLinkedPhasedTransactions(byte[] byArray) {
        return PhasingPollHome.getLinkedPhasedTransactions(byArray, Convert.fullHashToId(byArray));
    }

    /*
     * Exception decompiling
     */
    private static List<? extends ChildTransaction> getLinkedPhasedTransactions(byte[] var0, long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<ChainTransactionId> getHashedSecretPhasedTransactionIds(PhasingParams.HashVoting hashVoting, int n) {
        ArrayList<ChainTransactionId> arrayList = new ArrayList<ChainTransactionId>();
        try (DbIterator<HashedSecretPhasedTransaction> dbIterator = hashedSecretPhasedTransactionTable.getManyBy(new DbClause.HashClause("hashed_secret", "hashed_secret_id", hashVoting.getHashedSecret()).and(new DbClause.ByteClause("algorithm", hashVoting.getAlgorithm())).and(new DbClause.IntClause("finish_height", DbClause.Op.GTE, n)), 0, -1);){
            while (dbIterator.hasNext()) {
                arrayList.add(dbIterator.next().getPhasedTransactionId());
            }
        }
        return arrayList;
    }

    public static Set<ChainTransactionId> getVotedTransactionIds(ChildTransaction childTransaction) {
        PhasingVoteCastingAttachment phasingVoteCastingAttachment = (PhasingVoteCastingAttachment)childTransaction.getAttachment();
        HashSet<ChainTransactionId> hashSet = new HashSet<ChainTransactionId>(phasingVoteCastingAttachment.getPhasedTransactionsIds());
        if (Nxt.getBlockchain().getHeight() >= Constants.LIGHT_CONTRACTS_BLOCK) {
            for (byte[] byArray : phasingVoteCastingAttachment.getRevealedSecrets()) {
                for (HashFunction hashFunction : acceptedHashFunctions) {
                    PhasingParams.HashVoting hashVoting = new PhasingParams.HashVoting(hashFunction.hash(byArray), hashFunction.getId());
                    List<ChainTransactionId> list = PhasingPollHome.getHashedSecretPhasedTransactionIds(hashVoting, phasingVoteCastingAttachment.getFinishValidationHeight(childTransaction) + 1);
                    for (ChainTransactionId chainTransactionId : list) {
                        ChildTransaction childTransaction2;
                        PhasingPoll phasingPoll;
                        if (hashSet.contains(chainTransactionId) || (phasingPoll = (childTransaction2 = chainTransactionId.getChildTransaction()).getChain().getPhasingPollHome().getPoll(childTransaction2)) == null || !phasingPoll.getParams().isAccountWhitelisted(childTransaction.getSenderId()) || PhasingPollHome.getResult(childTransaction2) != null) continue;
                        hashSet.add(chainTransactionId);
                    }
                }
            }
        }
        return hashSet;
    }

    public static PhasingPollResult getResult(Transaction transaction) {
        return resultTable.get(resultDbKeyFactory.newKey(transaction.getFullHash(), transaction.getId()));
    }

    public static PhasingPollResult getResult(byte[] byArray) {
        return resultTable.get(resultDbKeyFactory.newKey(byArray));
    }

    public static DbIterator<PhasingPollResult> getApproved(int n) {
        return resultTable.getManyBy(new DbClause.IntClause("height", n).and(new DbClause.BooleanClause("approved", true)), 0, -1, " ORDER BY db_id ASC ");
    }

    private PhasingPollHome(ChildChain childChain) {
        this.childChain = childChain;
        this.phasingVoteHome = childChain.getPhasingVoteHome();
        this.phasingPollDbKeyFactory = new DbKey.HashKeyFactory<PhasingPoll>("full_hash", "id"){

            @Override
            public DbKey newKey(PhasingPoll phasingPoll) {
                return phasingPoll.dbKey;
            }
        };
        this.phasingPollTable = new EntityDbTable<PhasingPoll>(childChain.getSchemaTable("phasing_poll"), this.phasingPollDbKeyFactory){

            @Override
            protected PhasingPoll load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new PhasingPoll(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, PhasingPoll phasingPoll) throws SQLException {
                phasingPoll.save(connection);
            }

            @Override
            public void trim(int n) {
                super.trim(n);
                try (Connection connection = this.getConnection();
                     DbIterator dbIterator = PhasingPollHome.this.phasingPollTable.getManyBy(new DbClause.IntClause("finish_height", DbClause.Op.LT, n), 0, -1);
                     PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM phasing_poll WHERE id = ? AND full_hash = ?");
                     PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM phasing_poll_voter WHERE transaction_id = ? AND transaction_full_hash = ?");
                     PreparedStatement preparedStatement3 = connection.prepareStatement("DELETE FROM phasing_vote_sub_poll WHERE transaction_id = ? AND transaction_full_hash = ?");
                     PreparedStatement preparedStatement4 = connection.prepareStatement("DELETE FROM phasing_vote WHERE transaction_id = ? AND transaction_full_hash = ?");
                     PreparedStatement preparedStatement5 = connection.prepareStatement("DELETE FROM phasing_poll_linked_transaction WHERE transaction_id = ? AND transaction_full_hash = ?");
                     PreparedStatement preparedStatement6 = connection.prepareStatement("DELETE FROM phasing_poll_finish WHERE transaction_id = ? AND full_hash = ?");
                     PreparedStatement preparedStatement7 = connection.prepareStatement("DELETE FROM phasing_sub_poll WHERE transaction_id = ? AND transaction_full_hash = ?");
                     PreparedStatement preparedStatement8 = connection.prepareStatement("DELETE FROM phasing_poll_hashed_secret WHERE transaction_id = ? AND transaction_full_hash = ?");){
                    while (dbIterator.hasNext()) {
                        PhasingPoll phasingPoll = (PhasingPoll)dbIterator.next();
                        long l = phasingPoll.getId();
                        byte[] byArray = phasingPoll.getFullHash();
                        preparedStatement.setLong(1, l);
                        preparedStatement.setBytes(2, byArray);
                        preparedStatement.executeUpdate();
                        preparedStatement2.setLong(1, l);
                        preparedStatement2.setBytes(2, byArray);
                        preparedStatement2.executeUpdate();
                        preparedStatement3.setLong(1, l);
                        preparedStatement3.setBytes(2, byArray);
                        preparedStatement3.executeUpdate();
                        preparedStatement4.setLong(1, l);
                        preparedStatement4.setBytes(2, byArray);
                        preparedStatement4.executeUpdate();
                        preparedStatement5.setLong(1, l);
                        preparedStatement5.setBytes(2, byArray);
                        preparedStatement5.executeUpdate();
                        preparedStatement6.setLong(1, l);
                        preparedStatement6.setBytes(2, byArray);
                        preparedStatement6.executeUpdate();
                        preparedStatement7.setLong(1, l);
                        preparedStatement7.setBytes(2, byArray);
                        preparedStatement7.executeUpdate();
                        preparedStatement8.setLong(1, l);
                        preparedStatement8.setBytes(2, byArray);
                        preparedStatement8.executeUpdate();
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
        };
        this.votersDbKeyFactory = new DbKey.HashKeyFactory<PhasingPoll>("transaction_full_hash", "transaction_id"){

            @Override
            public DbKey newKey(PhasingPoll phasingPoll) {
                return phasingPoll.dbKey == null ? this.newKey(phasingPoll.hash, phasingPoll.id) : phasingPoll.dbKey;
            }
        };
        this.votersTable = new ValuesDbTable<PhasingPoll, PhasingPollVoter>(childChain.getSchemaTable("phasing_poll_voter"), this.votersDbKeyFactory){

            @Override
            protected PhasingPollVoter load(Connection connection, ResultSet resultSet) throws SQLException {
                return new PhasingPollVoter(resultSet);
            }

            @Override
            protected void save(Connection connection, PhasingPoll phasingPoll, PhasingPollVoter phasingPollVoter) throws SQLException {
                phasingPollVoter.save(connection, phasingPoll);
            }
        };
        this.subPollsDbKeyFactory = new DbKey.HashKeyFactory<PhasingPoll>("transaction_full_hash", "transaction_id"){

            @Override
            public DbKey newKey(PhasingPoll phasingPoll) {
                return phasingPoll.dbKey == null ? this.newKey(phasingPoll.hash, phasingPoll.id) : phasingPoll.dbKey;
            }
        };
        this.subPollsTable = new ValuesDbTable<PhasingPoll, PhasingSubPoll>(childChain.getSchemaTable("phasing_sub_poll"), this.subPollsDbKeyFactory){

            @Override
            protected PhasingSubPoll load(Connection connection, ResultSet resultSet) throws SQLException {
                return new PhasingSubPoll(resultSet);
            }

            @Override
            protected void save(Connection connection, PhasingPoll phasingPoll, PhasingSubPoll phasingSubPoll) throws SQLException {
                phasingSubPoll.save(connection);
            }
        };
    }

    public PhasingPoll getPoll(Transaction transaction) {
        return this.phasingPollTable.get(this.phasingPollDbKeyFactory.newKey(transaction.getFullHash(), transaction.getId()));
    }

    public PhasingPoll getPoll(byte[] byArray) {
        return this.phasingPollTable.get(this.phasingPollDbKeyFactory.newKey(byArray));
    }

    public DbIterator<? extends ChildTransaction> getVoterPhasedTransactions(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.phasingPollTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll_voter, phasing_poll LEFT JOIN phasing_poll_result ON phasing_poll.id = phasing_poll_result.id AND phasing_poll.full_hash = phasing_poll_result.full_hash WHERE transaction.id = phasing_poll.id AND transaction.full_hash = phasing_poll.full_hash AND phasing_poll.finish_height > ? AND phasing_poll.id = phasing_poll_voter.transaction_id AND phasing_poll.full_hash = phasing_poll_voter.transaction_full_hash AND phasing_poll_voter.voter_id = ? AND phasing_poll_result.id IS NULL AND phasing_poll_result.full_hash IS NULL GROUP BY transaction.id, transaction.full_hash ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return Nxt.getBlockchain().getTransactions(this.childChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<? extends ChildTransaction> getHoldingPhasedTransactions(long l, VoteWeighting.VotingModel votingModel, long l2, boolean bl, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.phasingPollTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll WHERE phasing_poll.holding_id = ? AND phasing_poll.voting_model = ? AND phasing_poll.id = transaction.id AND phasing_poll.full_hash = transaction.full_hash AND phasing_poll.finish_height > ? " + (l2 != 0L ? "AND phasing_poll.account_id = ? " : "") + (bl ? "AND phasing_poll.whitelist_size = 0 " : "") + "ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setByte(++n3, votingModel.getCode());
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            if (l2 != 0L) {
                preparedStatement.setLong(++n3, l2);
            }
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return Nxt.getBlockchain().getTransactions(this.childChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<? extends ChildTransaction> getAccountPhasedTransactions(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.phasingPollTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, phasing_poll  LEFT JOIN phasing_poll_result ON phasing_poll.id = phasing_poll_result.id  AND phasing_poll.full_hash = phasing_poll_result.full_hash  WHERE phasing_poll.id = transaction.id AND (transaction.sender_id = ? OR transaction.recipient_id = ?)  AND phasing_poll.full_hash = transaction.full_hash  AND phasing_poll_result.id IS NULL AND phasing_poll_result.full_hash IS NULL  AND phasing_poll.finish_height > ? ORDER BY transaction.height DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setInt(++n3, Nxt.getBlockchain().getHeight());
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return Nxt.getBlockchain().getTransactions(this.childChain, connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    /*
     * Exception decompiling
     */
    public int getAccountPhasedTransactionCount(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getSenderPhasedTransactionFees(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void addPoll(Transaction transaction, PhasingAppendix phasingAppendix) {
        PhasingPoll phasingPoll = new PhasingPoll(transaction, phasingAppendix);
        this.phasingPollTable.insert(phasingPoll);
        ArrayList<PhasingPollVoter> arrayList = new ArrayList<PhasingPollVoter>();
        for (long l : phasingPoll.getWhitelist()) {
            arrayList.add(new PhasingPollVoter(l, null));
        }
        ArrayList arrayList2 = new ArrayList();
        phasingAppendix.getLinkedTransactionsIds().forEach(chainTransactionId -> arrayList2.add(new LinkedTransaction((ChainTransactionId)chainTransactionId, null)));
        SortedMap<String, PhasingParams> sortedMap = phasingAppendix.getParams().getSubPolls();
        if (!sortedMap.isEmpty()) {
            ArrayList chainTransactionId2 = new ArrayList(sortedMap.size());
            sortedMap.forEach((string, phasingParams) -> {
                for (long l : phasingParams.getWhitelist()) {
                    arrayList.add(new PhasingPollVoter(l, (String)string));
                }
                phasingParams.getLinkedTransactionsIds().forEach(chainTransactionId -> arrayList2.add(new LinkedTransaction((ChainTransactionId)chainTransactionId, (String)string)));
                chainTransactionId2.add(new PhasingSubPoll(transaction, (String)string, (PhasingParams)phasingParams));
            });
            this.subPollsTable.insert(phasingPoll, chainTransactionId2);
        }
        this.votersTable.insert(phasingPoll, arrayList);
        linkedTransactionTable.insert(phasingPoll, arrayList2);
        ChainTransactionId chainTransactionId3 = ChainTransactionId.getChainTransactionId(transaction);
        phasingPoll.getHashedSecretParams().forEach(phasingParams -> {
            HashedSecretPhasedTransaction hashedSecretPhasedTransaction = new HashedSecretPhasedTransaction(phasingParams.getHashVoting(), chainTransactionId2, phasingPoll.getFinishHeight());
            if (hashedSecretPhasedTransactionTable.get(hashedSecretPhasedTransaction.dbKey) == null) {
                hashedSecretPhasedTransactionTable.insert(hashedSecretPhasedTransaction);
            }
        });
    }

    public final class PhasingPollVoter {
        private final long accountId;
        private final String subPollName;

        private PhasingPollVoter(long l, String string) {
            this.accountId = l;
            this.subPollName = string;
        }

        PhasingPollVoter(ResultSet resultSet) throws SQLException {
            this.accountId = resultSet.getLong("voter_id");
            this.subPollName = resultSet.getString("sub_poll_name");
        }

        void save(Connection connection, PhasingPoll phasingPoll) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_voter (transaction_id, transaction_full_hash, voter_id, sub_poll_name, height) VALUES (?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, phasingPoll.getId());
                preparedStatement.setBytes(++n, phasingPoll.getFullHash());
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setString(++n, this.subPollName);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getAccountId() {
            return this.accountId;
        }
    }

    public final class PhasingSubPoll {
        private final long id;
        private final byte[] hash;
        private final String variableName;
        private final PhasingParams params;

        private PhasingSubPoll(Transaction transaction, String string, PhasingParams phasingParams) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.variableName = string;
            this.params = phasingParams;
        }

        private PhasingSubPoll(ResultSet resultSet) throws SQLException {
            this.id = resultSet.getLong("transaction_id");
            this.hash = resultSet.getBytes("transaction_full_hash");
            this.variableName = Convert.nullToEmpty(resultSet.getString("name"));
            VoteWeighting voteWeighting = AbstractPoll.readVoteWeighting(resultSet);
            Supplier<long[]> supplier = null;
            if (resultSet.getByte("whitelist_size") > 0) {
                supplier = () -> Convert.toArray((Long[])PhasingPollHome.this.votersTable.get(PhasingPollHome.this.votersDbKeyFactory.newKey(this.hash, this.id)).stream().filter(phasingPollVoter -> this.variableName.equals(((PhasingPollVoter)phasingPollVoter).subPollName)).map(PhasingPollVoter::getAccountId).toArray(Long[]::new));
            }
            Supplier<List<ChainTransactionId>> supplier2 = null;
            if (voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
                supplier2 = () -> linkedTransactionTable.get(linkedTransactionDbKeyFactory.newKey(this.hash, this.id)).stream().filter(linkedTransaction -> this.variableName.equals(((LinkedTransaction)linkedTransaction).subPollName)).map(LinkedTransaction::getTransactionId).collect(Collectors.toList());
            }
            PhasingParams.PropertyVoting propertyVoting = PhasingParams.readPropertyVoting(resultSet, "sender_", voteWeighting);
            PhasingParams.PropertyVoting propertyVoting2 = PhasingParams.readPropertyVoting(resultSet, "recipient_", voteWeighting);
            this.params = new PhasingParams(voteWeighting, resultSet.getLong("quorum"), supplier, supplier2, new PhasingParams.HashVoting(resultSet.getBytes("hashed_secret"), resultSet.getByte("algorithm")), null, propertyVoting, propertyVoting2);
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_sub_poll (transaction_id, transaction_full_hash, name, whitelist_size, hashed_secret, algorithm, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setString(++n, this.variableName);
                preparedStatement.setByte(++n, (byte)this.params.getWhitelist().length);
                DbUtils.setBytes(preparedStatement, ++n, this.params.getHashedSecret());
                preparedStatement.setByte(++n, this.params.getAlgorithm());
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public String getVariableName() {
            return this.variableName;
        }

        public PhasingParams getParams() {
            return this.params;
        }
    }

    public final class PhasingPoll
    extends AbstractPoll {
        private final long recipientAccountId;
        private final byte[] hash;
        private final DbKey dbKey;
        private final PhasingParams params;

        private PhasingPoll(Transaction transaction, PhasingAppendix phasingAppendix) {
            super(transaction.getId(), transaction.getSenderId(), phasingAppendix.getFinishHeight());
            this.recipientAccountId = transaction.getRecipientId();
            this.hash = transaction.getFullHash();
            this.dbKey = PhasingPollHome.this.phasingPollDbKeyFactory.newKey(this.hash, this.id);
            this.params = phasingAppendix.getParams();
        }

        private PhasingPoll(ResultSet resultSet, DbKey dbKey) throws SQLException {
            Object object;
            Object object2;
            super(resultSet);
            this.recipientAccountId = resultSet.getLong("recipient_account_id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            VoteWeighting voteWeighting = PhasingPoll.readVoteWeighting(resultSet);
            Supplier<long[]> supplier = resultSet.getByte("whitelist_size") == 0 || voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE ? null : () -> Convert.toArray((Long[])PhasingPollHome.this.votersTable.get(PhasingPollHome.this.votersDbKeyFactory.newKey(this)).stream().map(PhasingPollVoter::getAccountId).toArray(Long[]::new));
            PhasingParams.HashVoting hashVoting = new PhasingParams.HashVoting(resultSet.getBytes("hashed_secret"), resultSet.getByte("algorithm"));
            PhasingParams.CompositeVoting compositeVoting = null;
            if (voteWeighting.getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
                object2 = PhasingPollHome.this.subPollsTable.get(PhasingPollHome.this.subPollsDbKeyFactory.newKey(this));
                object = new TreeMap();
                object2.forEach(arg_0 -> PhasingPoll.lambda$new$2((SortedMap)object, arg_0));
                compositeVoting = new PhasingParams.CompositeVoting(resultSet.getString("expression"), (SortedMap<String, PhasingParams>)object);
            }
            object2 = null;
            if (voteWeighting.getVotingModel() == VoteWeighting.VotingModel.TRANSACTION) {
                object2 = () -> linkedTransactionTable.get(linkedTransactionDbKeyFactory.newKey(this)).stream().map(LinkedTransaction::getTransactionId).collect(Collectors.toList());
            }
            object = PhasingParams.readPropertyVoting(resultSet, "sender_", voteWeighting);
            PhasingParams.PropertyVoting propertyVoting = PhasingParams.readPropertyVoting(resultSet, "recipient_", voteWeighting);
            this.params = new PhasingParams(voteWeighting, resultSet.getLong("quorum"), supplier, (Supplier<List<ChainTransactionId>>)object2, hashVoting, compositeVoting, (PhasingParams.PropertyVoting)object, propertyVoting);
        }

        public ChildChain getChildChain() {
            return PhasingPollHome.this.childChain;
        }

        void finish(long l) {
            PhasingPollResult phasingPollResult = new PhasingPollResult(this, l);
            resultTable.insert(phasingPollResult);
        }

        public PhasingParams getParams() {
            return this.params;
        }

        public VoteWeighting getVoteWeighting() {
            return this.params.getVoteWeighting();
        }

        public long[] getWhitelist() {
            return this.params.getWhitelist();
        }

        public long getQuorum() {
            return this.params.getQuorum();
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public List<ChainTransactionId> getLinkedTransactions() {
            return this.params.getLinkedTransactionsIds();
        }

        public byte[] getHashedSecret() {
            return this.params.getHashedSecret();
        }

        public byte getAlgorithm() {
            return this.params.getAlgorithm();
        }

        Iterable<PhasingParams> getHashedSecretParams() {
            if (this.params.getVoteWeighting().getVotingModel().equals((Object)VoteWeighting.VotingModel.HASH)) {
                return Collections.singletonList(this.params);
            }
            if (this.params.getVoteWeighting().getVotingModel().equals((Object)VoteWeighting.VotingModel.COMPOSITE)) {
                return this.params.getSubPolls().values().stream().filter(phasingParams -> phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH)::iterator;
            }
            return Collections.emptyList();
        }

        public boolean isCompositeVoting() {
            return this.params.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE;
        }

        public long countVotes() {
            return this.countVotes(null, this.params);
        }

        BooleanExpression.Value getCompositeVotingResult() {
            Map<String, BooleanExpression.Value> map = this.params.getSubPolls().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                PhasingParams phasingParams = (PhasingParams)entry.getValue();
                long l = phasingParams.getQuorum();
                if (this.finishHeight <= Nxt.getBlockchain().getHeight()) {
                    return BooleanExpression.Value.fromBoolean(this.countVotes((String)entry.getKey(), phasingParams) >= l);
                }
                if (phasingParams.allowEarlyFinish()) {
                    if (this.countVotes((String)entry.getKey(), phasingParams) >= l) {
                        return BooleanExpression.Value.TRUE;
                    }
                    return BooleanExpression.Value.UNKNOWN;
                }
                return BooleanExpression.Value.UNKNOWN;
            }));
            try {
                return this.params.getExpression().evaluate(map);
            }
            catch (BooleanExpression.BooleanExpressionException booleanExpressionException) {
                throw new RuntimeException("Invalid boolean expression while counting votes.", booleanExpressionException);
            }
        }

        private boolean isPropertyVotingValid(PhasingParams.PropertyVoting propertyVoting, Account.AccountProperty accountProperty) {
            return accountProperty != null && accountProperty.getValue() != null && (propertyVoting.getValue().isEmpty() || propertyVoting.getValue().equals(accountProperty.getValue()));
        }

        private long countVotes(String string, PhasingParams phasingParams) {
            VoteWeighting voteWeighting = phasingParams.getVoteWeighting();
            VoteWeighting.VotingModel votingModel = voteWeighting.getVotingModel();
            if (votingModel == VoteWeighting.VotingModel.NONE) {
                return 0L;
            }
            int n = Math.min(this.finishHeight, Nxt.getBlockchain().getHeight());
            if (votingModel == VoteWeighting.VotingModel.TRANSACTION) {
                int n2 = 0;
                for (ChainTransactionId chainTransactionId : phasingParams.getLinkedTransactionsIds()) {
                    if (!chainTransactionId.getChain().getTransactionHome().hasTransaction(chainTransactionId.getFullHash(), chainTransactionId.getTransactionId(), n)) continue;
                    ++n2;
                }
                return n2;
            }
            if (votingModel == VoteWeighting.VotingModel.PROPERTY) {
                Account.AccountProperty accountProperty;
                PhasingParams.PropertyVoting propertyVoting;
                if (this.recipientAccountId != 0L && (propertyVoting = phasingParams.getRecipientPropertyVoting()).getSetterId() != 0L && !this.isPropertyVotingValid(propertyVoting, accountProperty = Account.getProperty(this.recipientAccountId, propertyVoting.getName(), propertyVoting.getSetterId()))) {
                    return 0L;
                }
                propertyVoting = phasingParams.getSenderPropertyVoting();
                if (propertyVoting.getSetterId() == 0L) {
                    return 1L;
                }
                accountProperty = Account.getProperty(this.accountId, propertyVoting.getName(), propertyVoting.getSetterId());
                return this.isPropertyVotingValid(propertyVoting, accountProperty) ? 1L : 0L;
            }
            if (votingModel == VoteWeighting.VotingModel.COMPOSITE) {
                BooleanExpression.Value value = this.getCompositeVotingResult();
                switch (value) {
                    case TRUE: {
                        return 1L;
                    }
                }
                return 0L;
            }
            if (voteWeighting.isBalanceIndependent()) {
                if (string == null) {
                    return PhasingPollHome.this.phasingVoteHome.getVoteCount(this.hash);
                }
                return PhasingPollHome.this.phasingVoteHome.getSubPollVoteCount(this.hash, string);
            }
            long l = 0L;
            if (string == null) {
                try (DbIterator<PhasingVoteHome.PhasingVote> dbIterator = PhasingPollHome.this.phasingVoteHome.getVotes(this.hash, 0, Integer.MAX_VALUE);){
                    for (PhasingVoteHome.PhasingVote phasingVote : dbIterator) {
                        l += votingModel.calcWeight(voteWeighting, phasingVote.getVoterId(), n);
                    }
                }
            }
            try (DbIterator<PhasingVoteHome.PhasingVoteSubPoll> dbIterator = PhasingPollHome.this.phasingVoteHome.getSubPollVotes(this.hash, string);){
                for (PhasingVoteHome.PhasingVoteSubPoll phasingVoteSubPoll : dbIterator) {
                    l += votingModel.calcWeight(voteWeighting, phasingVoteSubPoll.getVoterId(), n);
                }
            }
            return l;
        }

        public boolean allowEarlyFinish() {
            return this.params.allowEarlyFinish();
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll (id, full_hash, account_id, recipient_account_id, finish_height, whitelist_size, expression, hashed_secret, algorithm, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.recipientAccountId);
                preparedStatement.setInt(++n, this.finishHeight);
                preparedStatement.setByte(++n, (byte)this.getWhitelist().length);
                preparedStatement.setString(++n, this.params.getExpressionStr());
                DbUtils.setBytes(preparedStatement, ++n, this.params.getHashedSecret());
                preparedStatement.setByte(++n, this.params.getAlgorithm());
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
            preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_finish (transaction_id, full_hash, chain_id, finish_height, height) VALUES (?, ?, ?, ?, ?)");
            var3_3 = null;
            try {
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setInt(++n, PhasingPollHome.this.childChain.getId());
                preparedStatement.setInt(++n, this.finishHeight);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (preparedStatement != null) {
                    if (var3_3 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }

        private static /* synthetic */ void lambda$new$2(SortedMap sortedMap, PhasingSubPoll phasingSubPoll) {
            sortedMap.put(phasingSubPoll.getVariableName(), phasingSubPoll.getParams());
        }
    }

    public static final class PhasingPollResult {
        private final long id;
        private final byte[] hash;
        private final DbKey dbKey;
        private final ChildChain childChain;
        private final long result;
        private final boolean approved;
        private final int height;

        private PhasingPollResult(PhasingPoll phasingPoll, long l) {
            this.id = phasingPoll.getId();
            this.hash = phasingPoll.getFullHash();
            this.dbKey = resultDbKeyFactory.newKey(this.hash, this.id);
            this.childChain = phasingPoll.getChildChain();
            this.result = l;
            this.approved = l >= phasingPoll.getQuorum();
            this.height = Nxt.getBlockchain().getHeight();
        }

        private PhasingPollResult(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.childChain = ChildChain.getChildChain(resultSet.getInt("chain_id"));
            this.result = resultSet.getLong("result");
            this.approved = resultSet.getBoolean("approved");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_result (id, full_hash, chain_id, result, approved, height) VALUES (?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setInt(++n, this.childChain.getId());
                preparedStatement.setLong(++n, this.result);
                preparedStatement.setBoolean(++n, this.approved);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getResult() {
            return this.result;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public int getHeight() {
            return this.height;
        }

        public ChildChain getChildChain() {
            return this.childChain;
        }
    }

    private static final class HashedSecretPhasedTransaction {
        private final PhasingParams.HashVoting hashVoting;
        private final ChainTransactionId phasedTransactionId;
        private final DbKey dbKey;
        private final int finishHeight;

        private HashedSecretPhasedTransaction(PhasingParams.HashVoting hashVoting, ChainTransactionId chainTransactionId, int n) {
            this.hashVoting = hashVoting;
            this.phasedTransactionId = chainTransactionId;
            this.dbKey = hashedSecretPhasedTransactionDbKeyFactory.newKey(hashVoting.getHashedSecret(), chainTransactionId.getFullHash(), hashVoting.getAlgorithm());
            this.finishHeight = n;
        }

        private HashedSecretPhasedTransaction(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.hashVoting = new PhasingParams.HashVoting(resultSet.getBytes("hashed_secret"), resultSet.getByte("algorithm"));
            this.phasedTransactionId = new ChainTransactionId(resultSet.getInt("chain_id"), resultSet.getBytes("transaction_full_hash"));
            this.dbKey = dbKey;
            this.finishHeight = resultSet.getInt("finish_height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_hashed_secret (hashed_secret, hashed_secret_id, algorithm, transaction_full_hash, transaction_id, chain_id, finish_height, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setBytes(++n, this.hashVoting.getHashedSecret());
                preparedStatement.setLong(++n, Convert.fullHashToId(this.hashVoting.getHashedSecret()));
                preparedStatement.setByte(++n, this.hashVoting.getAlgorithm());
                preparedStatement.setBytes(++n, this.phasedTransactionId.getFullHash());
                preparedStatement.setLong(++n, this.phasedTransactionId.getTransactionId());
                preparedStatement.setInt(++n, this.phasedTransactionId.getChainId());
                preparedStatement.setInt(++n, this.finishHeight);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public ChainTransactionId getPhasedTransactionId() {
            return this.phasedTransactionId;
        }
    }

    private static final class LinkedTransaction {
        private final ChainTransactionId transactionId;
        private final String subPollName;

        private LinkedTransaction(ChainTransactionId chainTransactionId, String string) {
            this.transactionId = chainTransactionId;
            this.subPollName = string;
        }

        private LinkedTransaction(ResultSet resultSet) throws SQLException {
            this.transactionId = new ChainTransactionId(resultSet.getInt("linked_chain_id"), resultSet.getBytes("linked_full_hash"));
            this.subPollName = resultSet.getString("sub_poll_name");
        }

        void save(Connection connection, PhasingPoll phasingPoll) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_poll_linked_transaction (chain_id, transaction_id, transaction_full_hash, sub_poll_name, linked_chain_id, linked_full_hash, linked_transaction_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setInt(++n, phasingPoll.getChildChain().getId());
                preparedStatement.setLong(++n, phasingPoll.getId());
                preparedStatement.setBytes(++n, phasingPoll.getFullHash());
                preparedStatement.setString(++n, this.subPollName);
                preparedStatement.setInt(++n, this.transactionId.getChainId());
                preparedStatement.setBytes(++n, this.transactionId.getFullHash());
                preparedStatement.setLong(++n, this.transactionId.getTransactionId());
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public ChainTransactionId getTransactionId() {
            return this.transactionId;
        }
    }
}

