/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.voting.VotingTransactionType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class PhasingVoteCastingAttachment
extends Attachment.AbstractAttachment {
    private final List<ChainTransactionId> phasedTransactionsIds;
    private final List<byte[]> revealedSecrets;

    PhasingVoteCastingAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        int n;
        int n2 = byteBuffer.get();
        this.phasedTransactionsIds = new ArrayList<ChainTransactionId>(n2);
        for (n = 0; n < n2; ++n) {
            this.phasedTransactionsIds.add(ChainTransactionId.parse(byteBuffer));
        }
        n = byteBuffer.getShort();
        if (n > 0) {
            this.revealedSecrets = new ArrayList<byte[]>(n);
            for (int i = 0; i < n; ++i) {
                short s = byteBuffer.getShort();
                if (s <= 0 || s > 100) {
                    throw new NxtException.NotValidException("Invalid revealed secret length " + s);
                }
                byte[] byArray = new byte[s];
                byteBuffer.get(byArray);
                this.revealedSecrets.add(byArray);
            }
        } else {
            this.revealedSecrets = Collections.emptyList();
        }
    }

    PhasingVoteCastingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"phasedTransactions");
        this.phasedTransactionsIds = new ArrayList<ChainTransactionId>(jSONArray.size());
        jSONArray.forEach(object -> this.phasedTransactionsIds.add(ChainTransactionId.parse((JSONObject)object)));
        JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"revealedSecrets");
        if (jSONArray2 == null) {
            this.revealedSecrets = Collections.emptyList();
        } else {
            this.revealedSecrets = new ArrayList<byte[]>(jSONArray2.size());
            jSONArray2.forEach(object -> this.revealedSecrets.add(Convert.parseHexString((String)object)));
        }
    }

    public PhasingVoteCastingAttachment(List<ChainTransactionId> list, List<byte[]> list2) {
        this.phasedTransactionsIds = list;
        this.revealedSecrets = list2;
    }

    @Override
    protected int getMySize() {
        int n = 1 + 36 * this.phasedTransactionsIds.size();
        n += 2;
        for (byte[] byArray : this.revealedSecrets) {
            n += 2 + byArray.length;
        }
        return n;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)this.phasedTransactionsIds.size());
        this.phasedTransactionsIds.forEach(chainTransactionId -> chainTransactionId.put(byteBuffer));
        byteBuffer.putShort((short)this.revealedSecrets.size());
        this.revealedSecrets.forEach(byArray -> {
            byteBuffer.putShort((short)((byte[])byArray).length);
            byteBuffer.put((byte[])byArray);
        });
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        JSONArray jSONArray = new JSONArray();
        this.phasedTransactionsIds.forEach(chainTransactionId -> jSONArray.add((Object)chainTransactionId.getJSON()));
        jSONObject.put((Object)"phasedTransactions", (Object)jSONArray);
        if (!this.revealedSecrets.isEmpty()) {
            JSONArray jSONArray2 = new JSONArray();
            this.revealedSecrets.forEach(byArray -> jSONArray2.add((Object)Convert.toHexString(byArray)));
            jSONObject.put((Object)"revealedSecrets", (Object)jSONArray2);
        }
    }

    @Override
    public TransactionType getTransactionType() {
        return VotingTransactionType.PHASING_VOTE_CASTING;
    }

    public List<ChainTransactionId> getPhasedTransactionsIds() {
        return this.phasedTransactionsIds;
    }

    public List<byte[]> getRevealedSecrets() {
        return this.revealedSecrets;
    }
}

