/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.voting.PhasingParams;
import nxt.voting.PhasingPollHome;
import nxt.voting.PhasingVoteCastingAttachment;
import nxt.voting.PollCreationAttachment;
import nxt.voting.PollHome;
import nxt.voting.VoteCastingAttachment;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;

public abstract class VotingTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_VOTING_POLL_CREATION = 0;
    private static final byte SUBTYPE_VOTING_VOTE_CASTING = 1;
    private static final byte SUBTYPE_VOTING_PHASING_VOTE_CASTING = 2;
    public static final TransactionType POLL_CREATION = new VotingTransactionType(){
        private final Fee POLL_OPTIONS_FEE = new Fee.SizeBasedFee(100000000L, 10000000L, 1){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                int n = ((PollCreationAttachment)appendix).getPollOptions().length;
                return n <= 19 ? 0 : n - 19;
            }
        };
        private final Fee POLL_SIZE_FEE = new Fee.SizeBasedFee(0L, 20000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                PollCreationAttachment pollCreationAttachment = (PollCreationAttachment)appendix;
                int n = pollCreationAttachment.getPollName().length() + pollCreationAttachment.getPollDescription().length();
                for (String string : ((PollCreationAttachment)appendix).getPollOptions()) {
                    n += string.length();
                }
                return n <= 288 ? 0 : n - 288;
            }
        };
        private final Fee POLL_FEE = (transactionImpl, appendix) -> this.POLL_OPTIONS_FEE.getFee(transactionImpl, appendix) + this.POLL_SIZE_FEE.getFee(transactionImpl, appendix);

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.POLL_CREATION;
        }

        @Override
        public String getName() {
            return "PollCreation";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.POLL_FEE;
        }

        @Override
        public PollCreationAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new PollCreationAttachment(byteBuffer);
        }

        @Override
        public PollCreationAttachment parseAttachment(JSONObject jSONObject) {
            return new PollCreationAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            PollCreationAttachment pollCreationAttachment = (PollCreationAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getPollHome().addPoll(childTransactionImpl, pollCreationAttachment);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            PollCreationAttachment pollCreationAttachment = (PollCreationAttachment)childTransactionImpl.getAttachment();
            int n = pollCreationAttachment.getPollOptions().length;
            if (pollCreationAttachment.getPollName().length() > 100 || pollCreationAttachment.getPollName().isEmpty() || pollCreationAttachment.getPollDescription().length() > 1000 || n > 100 || n == 0) {
                throw new NxtException.NotValidException("Invalid poll attachment: " + pollCreationAttachment.getJSONObject());
            }
            if (pollCreationAttachment.getMinNumberOfOptions() < 1 || pollCreationAttachment.getMinNumberOfOptions() > n) {
                throw new NxtException.NotValidException("Invalid min number of options: " + pollCreationAttachment.getJSONObject());
            }
            if (pollCreationAttachment.getMaxNumberOfOptions() < 1 || pollCreationAttachment.getMaxNumberOfOptions() < pollCreationAttachment.getMinNumberOfOptions() || pollCreationAttachment.getMaxNumberOfOptions() > n) {
                throw new NxtException.NotValidException("Invalid max number of options: " + pollCreationAttachment.getJSONObject());
            }
            for (int i = 0; i < n; ++i) {
                if (pollCreationAttachment.getPollOptions()[i].length() <= 100 && !pollCreationAttachment.getPollOptions()[i].isEmpty()) continue;
                throw new NxtException.NotValidException("Invalid poll options length: " + pollCreationAttachment.getJSONObject());
            }
            if (pollCreationAttachment.getMinRangeValue() < -92 || pollCreationAttachment.getMaxRangeValue() > 92 || pollCreationAttachment.getMaxRangeValue() < pollCreationAttachment.getMinRangeValue()) {
                throw new NxtException.NotValidException("Invalid range: " + pollCreationAttachment.getJSONObject());
            }
            if (pollCreationAttachment.getFinishHeight() <= pollCreationAttachment.getFinishValidationHeight(childTransactionImpl) + 1 || pollCreationAttachment.getFinishHeight() >= pollCreationAttachment.getFinishValidationHeight(childTransactionImpl) + 20160) {
                throw new NxtException.NotCurrentlyValidException("Invalid finishing height" + pollCreationAttachment.getJSONObject());
            }
            if (!pollCreationAttachment.getVoteWeighting().acceptsVotes() || pollCreationAttachment.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.HASH || pollCreationAttachment.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.COMPOSITE) {
                throw new NxtException.NotValidException("VotingModel " + (Object)((Object)pollCreationAttachment.getVoteWeighting().getVotingModel()) + " not valid for regular polls");
            }
            pollCreationAttachment.getVoteWeighting().validate();
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getPollHome().getPoll(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate poll id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return 1.isDuplicate(POLL_CREATION, this.getName(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType VOTE_CASTING = new VotingTransactionType(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.VOTE_CASTING;
        }

        @Override
        public String getName() {
            return "VoteCasting";
        }

        @Override
        public VoteCastingAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new VoteCastingAttachment(byteBuffer);
        }

        @Override
        public VoteCastingAttachment parseAttachment(JSONObject jSONObject) {
            return new VoteCastingAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            VoteCastingAttachment voteCastingAttachment = (VoteCastingAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getVoteHome().addVote(childTransactionImpl, voteCastingAttachment);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            VoteCastingAttachment voteCastingAttachment = (VoteCastingAttachment)childTransactionImpl.getAttachment();
            if (voteCastingAttachment.getPollId() == 0L || voteCastingAttachment.getPollVote() == null || voteCastingAttachment.getPollVote().length > 100) {
                throw new NxtException.NotValidException("Invalid vote casting attachment: " + voteCastingAttachment.getJSONObject());
            }
            long l = voteCastingAttachment.getPollId();
            PollHome.Poll poll = childTransactionImpl.getChain().getPollHome().getPoll(l);
            if (poll == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid poll: " + Long.toUnsignedString(voteCastingAttachment.getPollId()));
            }
            if (childTransactionImpl.getChain().getVoteHome().getVote(l, childTransactionImpl.getSenderId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Double voting attempt");
            }
            if (poll.getFinishHeight() <= voteCastingAttachment.getFinishValidationHeight(childTransactionImpl)) {
                throw new NxtException.NotCurrentlyValidException("Voting for this poll finishes at " + poll.getFinishHeight());
            }
            byte[] byArray = voteCastingAttachment.getPollVote();
            int n = 0;
            for (byte by : byArray) {
                if (by != -128 && (by < poll.getMinRangeValue() || by > poll.getMaxRangeValue())) {
                    throw new NxtException.NotValidException(String.format("Invalid vote %d, vote must be between %d and %d", by, poll.getMinRangeValue(), poll.getMaxRangeValue()));
                }
                if (by == -128) continue;
                ++n;
            }
            if (n < poll.getMinNumberOfOptions() || n > poll.getMaxNumberOfOptions()) {
                throw new NxtException.NotValidException(String.format("Invalid num of choices %d, number of choices must be between %d and %d", n, poll.getMinNumberOfOptions(), poll.getMaxNumberOfOptions()));
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            VoteCastingAttachment voteCastingAttachment = (VoteCastingAttachment)transaction.getAttachment();
            String string = Long.toUnsignedString(voteCastingAttachment.getPollId()) + ":" + Long.toUnsignedString(transaction.getSenderId());
            return 2.isDuplicate(VOTE_CASTING, string, map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType PHASING_VOTE_CASTING = new VotingTransactionType(){
        private final Fee PHASING_VOTE_FEE = (transactionImpl, appendix) -> {
            PhasingVoteCastingAttachment phasingVoteCastingAttachment = (PhasingVoteCastingAttachment)transactionImpl.getAttachment();
            return (long)Math.max(1, phasingVoteCastingAttachment.getPhasedTransactionsIds().size()) * 100000000L / 100L;
        };

        @Override
        public final byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.PHASING_VOTE_CASTING;
        }

        @Override
        public String getName() {
            return "PhasingVoteCasting";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.PHASING_VOTE_FEE;
        }

        @Override
        public PhasingVoteCastingAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new PhasingVoteCastingAttachment(byteBuffer);
        }

        @Override
        public PhasingVoteCastingAttachment parseAttachment(JSONObject jSONObject) {
            return new PhasingVoteCastingAttachment(jSONObject);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            PhasingPollHome.PhasingPoll phasingPoll;
            ChildChain childChain;
            PhasingVoteCastingAttachment phasingVoteCastingAttachment = (PhasingVoteCastingAttachment)childTransactionImpl.getAttachment();
            List<byte[]> list = phasingVoteCastingAttachment.getRevealedSecrets();
            if (list.size() > 10) {
                throw new NxtException.NotValidException("Revealing more than 10 secrets in a single transaction is not allowed");
            }
            PhasingParams[] phasingParamsArray = new PhasingParams[list.size()];
            for (byte[] byArray : list) {
                if (byArray.length <= 100 && byArray.length != 0) continue;
                throw new NxtException.NotValidException("Invalid revealed secret length " + byArray.length);
            }
            List<ChainTransactionId> list2 = phasingVoteCastingAttachment.getPhasedTransactionsIds();
            if (list2.size() > 10) {
                throw new NxtException.NotValidException("No more than 10 votes allowed for two-phased multi-voting");
            }
            long l = childTransactionImpl.getSenderId();
            for (ChainTransactionId chainTransactionId : list2) {
                childChain = chainTransactionId.getChildChain();
                if (childChain == null) {
                    throw new NxtException.NotValidException("Invalid child chain id " + chainTransactionId.getChainId());
                }
                phasingPoll = childChain.getPhasingPollHome().getPoll(chainTransactionId.getFullHash());
                if (phasingPoll == null) {
                    throw new NxtException.NotCurrentlyValidException("Invalid phased transaction " + chainTransactionId.getStringId() + ", or phasing is finished");
                }
                if (!phasingPoll.getParams().acceptsVotes()) {
                    throw new NxtException.NotValidException("This phased transaction does not require or accept voting");
                }
                if (!phasingPoll.getParams().isAccountWhitelisted(l)) {
                    throw new NxtException.NotValidException("Voter is not in the phased transaction whitelist");
                }
                if (phasingPoll.getFinishHeight() <= phasingVoteCastingAttachment.getFinishValidationHeight(childTransactionImpl) + 1) {
                    throw new NxtException.NotCurrentlyValidException(String.format("Phased transaction %s finishes at height %d which is not after approval transaction height %d", chainTransactionId.getStringId(), phasingPoll.getFinishHeight(), phasingVoteCastingAttachment.getFinishValidationHeight(childTransactionImpl) + 1));
                }
                if (!list.isEmpty() || phasingPoll.getVoteWeighting().getVotingModel() != VoteWeighting.VotingModel.HASH) continue;
                throw new NxtException.NotValidException("Phased transaction " + chainTransactionId.getStringId() + " requires revealed secret for approval");
            }
            if (!list.isEmpty()) {
                for (ChainTransactionId chainTransactionId : PhasingPollHome.getVotedTransactionIds(childTransactionImpl)) {
                    childChain = chainTransactionId.getChildChain();
                    phasingPoll = childChain.getPhasingPollHome().getPoll(chainTransactionId.getFullHash());
                    Iterator<PhasingParams> iterator = phasingPoll.getHashedSecretParams().iterator();
                    if (!iterator.hasNext()) {
                        throw new NxtException.NotValidException("Phased transaction " + chainTransactionId.getStringId() + " does not accept by-hash voting");
                    }
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        PhasingParams phasingParams = iterator.next();
                        for (int i = 0; i < list.size(); ++i) {
                            if (phasingParamsArray[i] == null) {
                                if (!PhasingPollHome.checkSecretMatch(list.get(i), phasingParams)) continue;
                                phasingParamsArray[i] = phasingParams;
                                bl = true;
                                continue;
                            }
                            if (!phasingParamsArray[i].getHashVoting().equals(phasingParams.getHashVoting())) continue;
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    throw new NxtException.NotValidException("Hashed secret(s) in phased transaction " + chainTransactionId.getStringId() + " do not match any of the revealed secrets");
                }
                for (int i = 0; i < phasingParamsArray.length; ++i) {
                    if (phasingParamsArray[i] != null) continue;
                    throw new NxtException.NotValidException("Revealed secret with index " + i + " is not used");
                }
            }
        }

        @Override
        public final void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            PhasingPollHome.getVotedTransactionIds(childTransactionImpl).forEach(chainTransactionId -> chainTransactionId.getChildChain().getPhasingVoteHome().addVote(childTransactionImpl, account, chainTransactionId.getFullHash()));
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return POLL_CREATION;
            }
            case 1: {
                return VOTE_CASTING;
            }
            case 2: {
                return PHASING_VOTE_CASTING;
            }
        }
        return null;
    }

    private VotingTransactionType() {
    }

    @Override
    public final byte getType() {
        return 9;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

