/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.account.PublicKeyAnnouncementAppendix;
import nxt.ae.AssetTransfer;
import nxt.ae.TradeHome;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.DerivedDbTable;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedPersistentDbTable;
import nxt.ms.CurrencyTransfer;
import nxt.ms.ExchangeHome;
import nxt.shuffling.ShufflingRecipientsAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import nxt.util.security.BlockchainPermission;

public final class Account {
    public static final StringRw PROPERTY_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 32);
    public static final StringRw PROPERTY_VALUE_RW = new StringRw(LengthRwPrimitiveType.BYTE, 160);
    private static final DbKey.LongKeyFactory<Account> accountDbKeyFactory = new DbKey.LongKeyFactory<Account>("id"){

        @Override
        public DbKey newKey(Account account) {
            return account.dbKey == null ? this.newKey(account.id) : account.dbKey;
        }

        @Override
        public Account newEntity(DbKey dbKey) {
            return new Account(((DbKey.LongKey)dbKey).getId());
        }
    };
    private static final VersionedEntityDbTable<Account> accountTable = new VersionedEntityDbTable<Account>("public.account", accountDbKeyFactory){

        @Override
        protected Account load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Account(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Account account) throws SQLException {
            account.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<AccountInfo> accountInfoDbKeyFactory = new DbKey.LongKeyFactory<AccountInfo>("account_id"){

        @Override
        public DbKey newKey(AccountInfo accountInfo) {
            return accountInfo.dbKey;
        }
    };
    private static final DbKey.LongKeyFactory<AccountLease> accountLeaseDbKeyFactory = new DbKey.LongKeyFactory<AccountLease>("lessor_id"){

        @Override
        public DbKey newKey(AccountLease accountLease) {
            return accountLease.dbKey;
        }
    };
    private static final VersionedEntityDbTable<AccountLease> accountLeaseTable = new VersionedEntityDbTable<AccountLease>("public.account_lease", accountLeaseDbKeyFactory){

        @Override
        protected AccountLease load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AccountLease(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AccountLease accountLease) throws SQLException {
            accountLease.save(connection);
        }
    };
    private static final VersionedEntityDbTable<AccountInfo> accountInfoTable = new VersionedEntityDbTable<AccountInfo>("public.account_info", accountInfoDbKeyFactory, "name,description"){

        @Override
        protected AccountInfo load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AccountInfo(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AccountInfo accountInfo) throws SQLException {
            accountInfo.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<PublicKey> publicKeyDbKeyFactory = new DbKey.LongKeyFactory<PublicKey>("account_id"){

        @Override
        public DbKey newKey(PublicKey publicKey) {
            return publicKey.dbKey;
        }

        @Override
        public PublicKey newEntity(DbKey dbKey) {
            return new PublicKey(((DbKey.LongKey)dbKey).getId(), null);
        }
    };
    private static final VersionedPersistentDbTable<PublicKey> publicKeyTable = new VersionedPersistentDbTable<PublicKey>("public.public_key", publicKeyDbKeyFactory){

        @Override
        protected PublicKey load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PublicKey(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PublicKey publicKey) throws SQLException {
            publicKey.save(connection);
        }

        @Override
        public void checkAvailable(int n) {
            if (n > Nxt.getBlockchain().getHeight()) {
                throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
            }
        }
    };
    private static final DbKey.LongLongKeyFactory<AccountAsset> accountAssetDbKeyFactory = new DbKey.LongLongKeyFactory<AccountAsset>("account_id", "asset_id"){

        @Override
        public DbKey newKey(AccountAsset accountAsset) {
            return accountAsset.dbKey;
        }
    };
    private static final VersionedEntityDbTable<AccountAsset> accountAssetTable = new VersionedEntityDbTable<AccountAsset>("public.account_asset", accountAssetDbKeyFactory){

        @Override
        protected AccountAsset load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AccountAsset(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AccountAsset accountAsset) throws SQLException {
            accountAsset.save(connection);
        }

        @Override
        public void trim(int n) {
            super.trim(Math.max(0, n - 1441));
        }

        @Override
        public void checkAvailable(int n) {
            if (n + 1441 < Nxt.getBlockchainProcessor().getMinRollbackHeight()) {
                throw new IllegalArgumentException("Historical data as of height " + n + " not available.");
            }
            if (n > Nxt.getBlockchain().getHeight()) {
                throw new IllegalArgumentException("Height " + n + " exceeds blockchain height " + Nxt.getBlockchain().getHeight());
            }
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY quantity DESC, account_id, asset_id ";
        }
    };
    private static final DbKey.LongLongKeyFactory<AccountCurrency> accountCurrencyDbKeyFactory = new DbKey.LongLongKeyFactory<AccountCurrency>("account_id", "currency_id"){

        @Override
        public DbKey newKey(AccountCurrency accountCurrency) {
            return accountCurrency.dbKey;
        }
    };
    private static final VersionedEntityDbTable<AccountCurrency> accountCurrencyTable = new VersionedEntityDbTable<AccountCurrency>("public.account_currency", accountCurrencyDbKeyFactory){

        @Override
        protected AccountCurrency load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AccountCurrency(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AccountCurrency accountCurrency) throws SQLException {
            accountCurrency.save(connection);
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY units DESC, account_id, currency_id ";
        }
    };
    private static final DerivedDbTable accountGuaranteedBalanceTable = new DerivedDbTable("public.account_guaranteed_balance"){

        @Override
        public void trim(int n) {
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM account_guaranteed_balance WHERE height < ? AND height >= 0 LIMIT " + Constants.BATCH_COMMIT_SIZE);){
                int n2;
                preparedStatement.setInt(1, n - Constants.GUARANTEED_BALANCE_CONFIRMATIONS);
                do {
                    n2 = preparedStatement.executeUpdate();
                    db.commitTransaction();
                } while (n2 >= Constants.BATCH_COMMIT_SIZE);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
        }
    };
    private static final DbKey.LongKeyFactory<AccountProperty> accountPropertyDbKeyFactory = new DbKey.LongKeyFactory<AccountProperty>("id"){

        @Override
        public DbKey newKey(AccountProperty accountProperty) {
            return accountProperty.dbKey;
        }
    };
    private static final VersionedEntityDbTable<AccountProperty> accountPropertyTable = new VersionedEntityDbTable<AccountProperty>("public.account_property", accountPropertyDbKeyFactory){

        @Override
        protected AccountProperty load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AccountProperty(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AccountProperty accountProperty) throws SQLException {
            accountProperty.save(connection);
        }
    };
    private static final ConcurrentMap<DbKey, byte[]> publicKeyCache = Nxt.getBooleanProperty("nxt.enablePublicKeyCache") ? new ConcurrentHashMap() : null;
    private static final Listeners<AccountAsset, Event> assetListeners = new Listeners();
    private static final Listeners<AccountCurrency, Event> currencyListeners = new Listeners();
    private static final Listeners<AccountLease, Event> leaseListeners = new Listeners();
    private static final Listeners<AccountProperty, Event> propertyListeners = new Listeners();
    private final long id;
    private final DbKey dbKey;
    private PublicKey publicKey;
    private long forgedBalanceFQT;
    private long activeLesseeId;
    private Set<ControlType> controls;

    public static boolean addAssetListener(Listener<AccountAsset> listener, Event event) {
        return assetListeners.addListener(listener, event);
    }

    public static boolean removeAssetListener(Listener<AccountAsset> listener, Event event) {
        return assetListeners.removeListener(listener, event);
    }

    public static boolean addCurrencyListener(Listener<AccountCurrency> listener, Event event) {
        return currencyListeners.addListener(listener, event);
    }

    public static boolean removeCurrencyListener(Listener<AccountCurrency> listener, Event event) {
        return currencyListeners.removeListener(listener, event);
    }

    public static boolean addLeaseListener(Listener<AccountLease> listener, Event event) {
        return leaseListeners.addListener(listener, event);
    }

    public static boolean removeLeaseListener(Listener<AccountLease> listener, Event event) {
        return leaseListeners.removeListener(listener, event);
    }

    public static boolean addPropertyListener(Listener<AccountProperty> listener, Event event) {
        return propertyListeners.addListener(listener, event);
    }

    public static boolean removePropertyListener(Listener<AccountProperty> listener, Event event) {
        return propertyListeners.removeListener(listener, event);
    }

    public static int getCount() {
        return publicKeyTable.getCount();
    }

    public static int getAssetAccountCount(long l) {
        return accountAssetTable.getCount(new DbClause.LongClause("asset_id", l));
    }

    public static int getAssetAccountCount(long l, int n) {
        return accountAssetTable.getCount(new DbClause.LongClause("asset_id", l), n);
    }

    public static int getAccountAssetCount(long l) {
        return accountAssetTable.getCount(new DbClause.LongClause("account_id", l));
    }

    public static int getAccountAssetCount(long l, int n) {
        return accountAssetTable.getCount(new DbClause.LongClause("account_id", l), n);
    }

    public static int getCurrencyAccountCount(long l) {
        return accountCurrencyTable.getCount(new DbClause.LongClause("currency_id", l));
    }

    public static int getCurrencyAccountCount(long l, int n) {
        return accountCurrencyTable.getCount(new DbClause.LongClause("currency_id", l), n);
    }

    public static int getAccountCurrencyCount(long l) {
        return accountCurrencyTable.getCount(new DbClause.LongClause("account_id", l));
    }

    public static int getAccountCurrencyCount(long l, int n) {
        return accountCurrencyTable.getCount(new DbClause.LongClause("account_id", l), n);
    }

    public static int getAccountLeaseCount() {
        return accountLeaseTable.getCount();
    }

    public static int getActiveLeaseCount() {
        return accountTable.getCount(new DbClause.NotNullClause("active_lessee_id"));
    }

    public static AccountProperty getProperty(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.property"));
        }
        return (AccountProperty)accountPropertyTable.get(accountPropertyDbKeyFactory.newKey(l));
    }

    public static DbIterator<AccountProperty> getProperties(long l, long l2, String string, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.property"));
        }
        if (l == 0L && l2 == 0L) {
            throw new IllegalArgumentException("At least one of recipientId and setterId must be specified");
        }
        DbClause dbClause = null;
        if (l2 == l) {
            dbClause = new DbClause.NullClause("setter_id");
        } else if (l2 != 0L) {
            dbClause = new DbClause.LongClause("setter_id", l2);
        }
        if (l != 0L) {
            dbClause = dbClause != null ? dbClause.and(new DbClause.LongClause("recipient_id", l)) : new DbClause.LongClause("recipient_id", l);
        }
        if (string != null) {
            dbClause = dbClause.and(new DbClause.StringClause("property", string));
        }
        return accountPropertyTable.getManyBy(dbClause, n, n2, " ORDER BY property ");
    }

    public static AccountProperty getProperty(long l, String string) {
        return Account.getProperty(l, string, l);
    }

    public static AccountProperty getProperty(long l, String string, long l2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.property"));
        }
        if (l == 0L || l2 == 0L) {
            throw new IllegalArgumentException("Both recipientId and setterId must be specified");
        }
        DbClause dbClause = new DbClause.LongClause("recipient_id", l);
        dbClause = dbClause.and(new DbClause.StringClause("property", string));
        dbClause = l2 != l ? dbClause.and(new DbClause.LongClause("setter_id", l2)) : dbClause.and(new DbClause.NullClause("setter_id"));
        return (AccountProperty)accountPropertyTable.getBy(dbClause);
    }

    public static Account getAccount(long l) {
        PublicKey publicKey;
        DbKey dbKey;
        Account account;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        if ((account = (Account)accountTable.get(dbKey = accountDbKeyFactory.newKey(l))) == null && (publicKey = (PublicKey)publicKeyTable.get(dbKey)) != null) {
            account = (Account)accountTable.newEntity(dbKey);
            account.publicKey = publicKey;
        }
        return account;
    }

    public static Account getAccount(long l, int n) {
        PublicKey publicKey;
        DbKey dbKey;
        Account account;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        if ((account = (Account)accountTable.get(dbKey = accountDbKeyFactory.newKey(l), n)) == null && (publicKey = (PublicKey)publicKeyTable.get(dbKey, n)) != null) {
            account = new Account(l);
            account.publicKey = publicKey;
        }
        return account;
    }

    public static boolean hasAccount(long l, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        DbKey dbKey = accountDbKeyFactory.newKey(l);
        if (publicKeyCache != null && Nxt.getBlockchain().getHeight() == n && !Nxt.getBlockchainProcessor().isScanning() && publicKeyCache.containsKey(dbKey)) {
            return true;
        }
        return publicKeyTable.get(dbKey, n) != null;
    }

    public static Account getAccount(byte[] byArray) {
        long l;
        Account account;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        if ((account = Account.getAccount(l = Account.getId(byArray))) == null) {
            return null;
        }
        if (account.publicKey == null) {
            account.publicKey = (PublicKey)publicKeyTable.get(accountDbKeyFactory.newKey(account));
        }
        if (account.publicKey == null || account.publicKey.publicKey == null || Arrays.equals(account.publicKey.publicKey, byArray)) {
            return account;
        }
        throw new RuntimeException("DUPLICATE KEY for account " + Long.toUnsignedString(l) + " existing key " + Convert.toHexString(account.publicKey.publicKey) + " new key " + Convert.toHexString(byArray));
    }

    public static long getId(byte[] byArray) {
        byte[] byArray2 = Crypto.sha256().digest(byArray);
        return Convert.fullHashToId(byArray2);
    }

    public static byte[] getPublicKey(long l) {
        DbKey dbKey = publicKeyDbKeyFactory.newKey(l);
        byte[] byArray = null;
        if (publicKeyCache != null) {
            byArray = (byte[])publicKeyCache.get(dbKey);
        }
        if (byArray == null) {
            PublicKey publicKey = (PublicKey)publicKeyTable.get(dbKey);
            if (publicKey == null || (byArray = publicKey.publicKey) == null) {
                return null;
            }
            if (publicKeyCache != null) {
                publicKeyCache.put(dbKey, byArray);
            }
        }
        return byArray;
    }

    public static Account addOrGetAccount(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        if (l == 0L) {
            throw new IllegalArgumentException("Invalid accountId 0");
        }
        DbKey dbKey = accountDbKeyFactory.newKey(l);
        Account account = (Account)accountTable.get(dbKey);
        if (account == null) {
            account = (Account)accountTable.newEntity(dbKey);
            PublicKey publicKey = (PublicKey)publicKeyTable.get(dbKey);
            if (publicKey == null) {
                publicKey = (PublicKey)publicKeyTable.newEntity(dbKey);
                publicKeyTable.insert(publicKey);
            }
            account.publicKey = publicKey;
        }
        return account;
    }

    private static DbIterator<AccountLease> getLeaseChangingAccounts(int n) {
        Connection connection = null;
        try {
            connection = accountLeaseTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM account_lease WHERE current_leasing_height_from = ? AND latest = TRUE UNION ALL SELECT * FROM account_lease WHERE current_leasing_height_to = ? AND latest = TRUE ORDER BY current_lessee_id, lessor_id");
            int n2 = 0;
            preparedStatement.setInt(++n2, n);
            preparedStatement.setInt(++n2, n);
            return accountLeaseTable.getManyBy(connection, preparedStatement, true);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<AccountAsset> getAccountAssets(long l, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return accountAssetTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static DbIterator<AccountAsset> getAccountAssets(long l, int n, int n2, int n3) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return accountAssetTable.getManyBy((DbClause)new DbClause.LongClause("account_id", l), n, n2, n3);
    }

    public static AccountAsset getAccountAsset(long l, long l2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(l, l2));
    }

    public static AccountAsset getAccountAsset(long l, long l2, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(l, l2), n);
    }

    public static DbIterator<AccountAsset> getAssetAccounts(long l, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return accountAssetTable.getManyBy((DbClause)new DbClause.LongClause("asset_id", l), n, n2, " ORDER BY quantity DESC, account_id ");
    }

    public static DbIterator<AccountAsset> getAssetAccounts(long l, int n, int n2, int n3) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return accountAssetTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2, n3, " ORDER BY quantity DESC, account_id ");
    }

    public static AccountCurrency getAccountCurrency(long l, long l2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(l, l2));
    }

    public static AccountCurrency getAccountCurrency(long l, long l2, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(l, l2), n);
    }

    public static DbIterator<AccountCurrency> getAccountCurrencies(long l, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return accountCurrencyTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static DbIterator<AccountCurrency> getAccountCurrencies(long l, int n, int n2, int n3) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return accountCurrencyTable.getManyBy((DbClause)new DbClause.LongClause("account_id", l), n, n2, n3);
    }

    public static DbIterator<AccountCurrency> getCurrencyAccounts(long l, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return accountCurrencyTable.getManyBy(new DbClause.LongClause("currency_id", l), n, n2);
    }

    public static DbIterator<AccountCurrency> getCurrencyAccounts(long l, int n, int n2, int n3) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return accountCurrencyTable.getManyBy((DbClause)new DbClause.LongClause("currency_id", l), n, n2, n3);
    }

    public static long getAssetBalanceQNT(long l, long l2, int n) {
        AccountAsset accountAsset;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return (accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(l, l2), n)) == null ? 0L : accountAsset.quantityQNT;
    }

    public static long getAssetBalanceQNT(long l, long l2) {
        AccountAsset accountAsset;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return (accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(l, l2))) == null ? 0L : accountAsset.quantityQNT;
    }

    public static long getUnconfirmedAssetBalanceQNT(long l, long l2) {
        AccountAsset accountAsset;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.asset"));
        }
        return (accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(l, l2))) == null ? 0L : accountAsset.unconfirmedQuantityQNT;
    }

    public static long getCurrencyUnits(long l, long l2, int n) {
        AccountCurrency accountCurrency;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return (accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(l, l2), n)) == null ? 0L : accountCurrency.units;
    }

    public static long getCurrencyUnits(long l, long l2) {
        AccountCurrency accountCurrency;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return (accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(l, l2))) == null ? 0L : accountCurrency.units;
    }

    public static long getUnconfirmedCurrencyUnits(long l, long l2) {
        AccountCurrency accountCurrency;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.currency"));
        }
        return (accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(l, l2))) == null ? 0L : accountCurrency.unconfirmedUnits;
    }

    public static DbIterator<AccountInfo> searchAccounts(String string, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        return accountInfoTable.search(string, DbClause.EMPTY_CLAUSE, n, n2);
    }

    public static void init() {
    }

    private Account(long l) {
        if (l != Convert.rsDecode(Convert.rsEncode(l))) {
            Logger.logMessage("CRITICAL ERROR: Reed-Solomon encoding fails for " + l);
        }
        this.id = l;
        this.dbKey = accountDbKeyFactory.newKey(this.id);
        this.controls = Collections.emptySet();
    }

    private Account(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.forgedBalanceFQT = resultSet.getLong("forged_balance");
        this.activeLesseeId = resultSet.getLong("active_lessee_id");
        this.controls = resultSet.getBoolean("has_control_phasing") ? Collections.unmodifiableSet(EnumSet.of(ControlType.PHASING_ONLY)) : Collections.emptySet();
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account (id, forged_balance, active_lessee_id, has_control_phasing, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.forgedBalanceFQT);
            DbUtils.setLongZeroToNull(preparedStatement, ++n, this.activeLesseeId);
            preparedStatement.setBoolean(++n, this.controls.contains((Object)ControlType.PHASING_ONLY));
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    private void save() {
        if (this.forgedBalanceFQT == 0L && this.activeLesseeId == 0L && this.controls.isEmpty()) {
            accountTable.delete(this, true);
        } else {
            accountTable.insert(this);
        }
    }

    public long getId() {
        return this.id;
    }

    public AccountInfo getAccountInfo() {
        return (AccountInfo)accountInfoTable.get(accountDbKeyFactory.newKey(this));
    }

    public void setAccountInfo(String string, String string2) {
        string = Convert.emptyToNull(string.trim());
        string2 = Convert.emptyToNull(string2.trim());
        AccountInfo accountInfo = this.getAccountInfo();
        if (accountInfo == null) {
            accountInfo = new AccountInfo(this.id, string, string2);
        } else {
            accountInfo.name = string;
            accountInfo.description = string2;
        }
        accountInfo.save();
    }

    public AccountLease getAccountLease() {
        return (AccountLease)accountLeaseTable.get(accountDbKeyFactory.newKey(this));
    }

    public EncryptedData encryptTo(byte[] byArray, String string, boolean bl) {
        byte[] byArray2 = Account.getPublicKey(this.id);
        if (byArray2 == null) {
            throw new IllegalArgumentException("Recipient account doesn't have a public key set");
        }
        return Account.encryptTo(byArray2, byArray, string, bl);
    }

    public static EncryptedData encryptTo(byte[] byArray, byte[] byArray2, String string, boolean bl) {
        if (bl && byArray2.length > 0) {
            byArray2 = Convert.compress(byArray2);
        }
        return EncryptedData.encrypt(byArray2, string, byArray);
    }

    public byte[] decryptFrom(EncryptedData encryptedData, String string, boolean bl) {
        byte[] byArray = Account.getPublicKey(this.id);
        if (byArray == null) {
            throw new IllegalArgumentException("Sender account doesn't have a public key set");
        }
        return Account.decryptFrom(byArray, encryptedData, string, bl);
    }

    public static byte[] decryptFrom(byte[] byArray, EncryptedData encryptedData, String string, boolean bl) {
        byte[] byArray2 = encryptedData.decrypt(string, byArray);
        if (bl && byArray2.length > 0) {
            byArray2 = Convert.uncompress(byArray2);
        }
        return byArray2;
    }

    public long getForgedBalanceFQT() {
        return this.forgedBalanceFQT;
    }

    public long getEffectiveBalanceFXT() {
        Nxt.getBlockchain().readLock();
        try {
            long l = this.getEffectiveBalanceFXT(Nxt.getBlockchain().getHeight());
            return l;
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
    }

    public long getEffectiveBalanceFXT(int n) {
        if (n <= Constants.GUARANTEED_BALANCE_CONFIRMATIONS) {
            BalanceHome.Balance balance = FxtChain.FXT.getBalanceHome().getBalance(this.id, 0);
            return balance.getBalance() / 100000000L;
        }
        if (this.publicKey == null) {
            this.publicKey = (PublicKey)publicKeyTable.get(accountDbKeyFactory.newKey(this));
        }
        if (this.publicKey == null || this.publicKey.publicKey == null || n - this.publicKey.height <= Constants.GUARANTEED_BALANCE_CONFIRMATIONS) {
            return 0L;
        }
        long l = this.getLessorsGuaranteedBalanceFQT(n);
        if (this.activeLesseeId == 0L) {
            l += this.getGuaranteedBalanceFQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, n);
        }
        return l < 100000000000L ? 0L : l / 100000000L;
    }

    /*
     * Exception decompiling
     */
    private long getLessorsGuaranteedBalanceFQT(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<Account> getLessors() {
        return accountTable.getManyBy((DbClause)new DbClause.LongClause("active_lessee_id", this.id), 0, -1, " ORDER BY id ASC ");
    }

    public DbIterator<Account> getLessors(int n) {
        return accountTable.getManyBy(new DbClause.LongClause("active_lessee_id", this.id), n, 0, -1, " ORDER BY id ASC ");
    }

    public long getGuaranteedBalanceFQT() {
        return this.getGuaranteedBalanceFQT(Constants.GUARANTEED_BALANCE_CONFIRMATIONS, Nxt.getBlockchain().getHeight());
    }

    /*
     * Exception decompiling
     */
    public long getGuaranteedBalanceFQT(int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<AccountAsset> getAssets(int n, int n2) {
        return accountAssetTable.getManyBy(new DbClause.LongClause("account_id", this.id), n, n2);
    }

    public DbIterator<AccountAsset> getAssets(int n, int n2, int n3) {
        return accountAssetTable.getManyBy((DbClause)new DbClause.LongClause("account_id", this.id), n, n2, n3);
    }

    public DbIterator<TradeHome.Trade> getTrades(ChildChain childChain, int n, int n2) {
        return childChain.getTradeHome().getAccountTrades(this.id, n, n2);
    }

    public DbIterator<AssetTransfer> getAssetTransfers(int n, int n2) {
        return AssetTransfer.getAccountAssetTransfers(this.id, n, n2);
    }

    public DbIterator<CurrencyTransfer> getCurrencyTransfers(int n, int n2) {
        return CurrencyTransfer.getAccountCurrencyTransfers(this.id, n, n2);
    }

    public DbIterator<ExchangeHome.Exchange> getExchanges(ChildChain childChain, int n, int n2) {
        return childChain.getExchangeHome().getAccountExchanges(this.id, n, n2);
    }

    public AccountAsset getAsset(long l) {
        return (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(this.id, l));
    }

    public AccountAsset getAsset(long l, int n) {
        return (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(this.id, l), n);
    }

    public long getAssetBalanceQNT(long l) {
        return Account.getAssetBalanceQNT(this.id, l);
    }

    public long getAssetBalanceQNT(long l, int n) {
        return Account.getAssetBalanceQNT(this.id, l, n);
    }

    public long getUnconfirmedAssetBalanceQNT(long l) {
        return Account.getUnconfirmedAssetBalanceQNT(this.id, l);
    }

    public AccountCurrency getCurrency(long l) {
        return (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(this.id, l));
    }

    public AccountCurrency getCurrency(long l, int n) {
        return (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(this.id, l), n);
    }

    public DbIterator<AccountCurrency> getCurrencies(int n, int n2) {
        return accountCurrencyTable.getManyBy(new DbClause.LongClause("account_id", this.id), n, n2);
    }

    public DbIterator<AccountCurrency> getCurrencies(int n, int n2, int n3) {
        return accountCurrencyTable.getManyBy((DbClause)new DbClause.LongClause("account_id", this.id), n, n2, n3);
    }

    public long getCurrencyUnits(long l) {
        return Account.getCurrencyUnits(this.id, l);
    }

    public long getCurrencyUnits(long l, int n) {
        return Account.getCurrencyUnits(this.id, l, n);
    }

    public long getUnconfirmedCurrencyUnits(long l) {
        return Account.getUnconfirmedCurrencyUnits(this.id, l);
    }

    public Set<ControlType> getControls() {
        return this.controls;
    }

    public void leaseEffectiveBalance(long l, int n) {
        int n2 = Nxt.getBlockchain().getHeight();
        AccountLease accountLease = (AccountLease)accountLeaseTable.get(accountDbKeyFactory.newKey(this));
        if (accountLease == null) {
            accountLease = new AccountLease(this.id, n2 + Constants.LEASING_DELAY, n2 + Constants.LEASING_DELAY + n, l);
        } else if (accountLease.currentLesseeId == 0L) {
            accountLease.currentLeasingHeightFrom = n2 + Constants.LEASING_DELAY;
            accountLease.currentLeasingHeightTo = n2 + Constants.LEASING_DELAY + n;
            accountLease.currentLesseeId = l;
        } else {
            accountLease.nextLeasingHeightFrom = n2 + Constants.LEASING_DELAY;
            if (accountLease.nextLeasingHeightFrom < accountLease.currentLeasingHeightTo) {
                accountLease.nextLeasingHeightFrom = accountLease.currentLeasingHeightTo;
            }
            accountLease.nextLeasingHeightTo = accountLease.nextLeasingHeightFrom + n;
            accountLease.nextLesseeId = l;
        }
        accountLeaseTable.insert(accountLease);
        leaseListeners.notify(accountLease, Event.LEASE_SCHEDULED);
    }

    void addControl(ControlType controlType) {
        if (this.controls.contains((Object)controlType)) {
            return;
        }
        EnumSet<ControlType> enumSet = EnumSet.of(controlType);
        enumSet.addAll(this.controls);
        this.controls = Collections.unmodifiableSet(enumSet);
        accountTable.insert(this);
    }

    void removeControl(ControlType controlType) {
        if (!this.controls.contains((Object)controlType)) {
            return;
        }
        EnumSet<ControlType> enumSet = EnumSet.copyOf(this.controls);
        enumSet.remove((Object)controlType);
        this.controls = Collections.unmodifiableSet(enumSet);
        this.save();
    }

    public void setProperty(Transaction transaction, Account account, String string, String string2) {
        string2 = Convert.emptyToNull(string2);
        AccountProperty accountProperty = Account.getProperty(this.id, string, account.id);
        if (accountProperty == null) {
            accountProperty = new AccountProperty(transaction.getId(), this.id, account.id, string, string2);
        } else {
            accountProperty.value = string2;
        }
        accountPropertyTable.insert(accountProperty);
        propertyListeners.notify(accountProperty, Event.SET_PROPERTY);
    }

    public static void importProperty(long l, long l2, long l3, String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.property"));
        }
        string2 = Convert.emptyToNull(string2);
        AccountProperty accountProperty = new AccountProperty(l, l2, l3, string, string2);
        accountPropertyTable.insert(accountProperty);
    }

    public void deleteProperty(long l) {
        AccountProperty accountProperty;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account.property"));
        }
        if ((accountProperty = (AccountProperty)accountPropertyTable.get(accountPropertyDbKeyFactory.newKey(l))) == null) {
            return;
        }
        if (accountProperty.getSetterId() != this.id && accountProperty.getRecipientId() != this.id) {
            throw new RuntimeException("Property " + Long.toUnsignedString(l) + " cannot be deleted by " + Long.toUnsignedString(this.id));
        }
        accountPropertyTable.delete(accountProperty);
        propertyListeners.notify(accountProperty, Event.DELETE_PROPERTY);
    }

    public static boolean setOrVerify(long l, byte[] byArray) {
        DbKey dbKey;
        PublicKey publicKey;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("account"));
        }
        if ((publicKey = (PublicKey)publicKeyTable.get(dbKey = publicKeyDbKeyFactory.newKey(l))) == null) {
            publicKey = (PublicKey)publicKeyTable.newEntity(dbKey);
        }
        if (publicKey.publicKey == null) {
            PublicKey.access$3302(publicKey, byArray);
            publicKey.height = Nxt.getBlockchain().getHeight();
            return true;
        }
        return Arrays.equals(publicKey.publicKey, byArray);
    }

    public void apply(byte[] byArray) {
        PublicKey publicKey = (PublicKey)publicKeyTable.get(this.dbKey);
        if (publicKey == null) {
            publicKey = (PublicKey)publicKeyTable.newEntity(this.dbKey);
        }
        if (publicKey.publicKey == null) {
            PublicKey.access$3302(publicKey, byArray);
            publicKeyTable.insert(publicKey);
        } else {
            PublicKey publicKey2;
            if (!Arrays.equals(publicKey.publicKey, byArray)) {
                throw new IllegalStateException("Public key mismatch");
            }
            if (publicKey.height >= Nxt.getBlockchain().getHeight() - 1 && ((publicKey2 = (PublicKey)publicKeyTable.get(this.dbKey, false)) == null || publicKey2.publicKey == null)) {
                publicKeyTable.insert(publicKey);
            }
        }
        if (publicKeyCache != null) {
            publicKeyCache.put(this.dbKey, byArray);
        }
        this.publicKey = publicKey;
    }

    public void addToAssetBalanceQNT(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountAsset accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(this.id, l));
        long l3 = accountAsset == null ? 0L : accountAsset.quantityQNT;
        l3 = Math.addExact(l3, l2);
        if (accountAsset == null) {
            accountAsset = new AccountAsset(this.id, l, l3, 0L);
        } else {
            accountAsset.quantityQNT = l3;
        }
        accountAsset.save();
        assetListeners.notify(accountAsset, Event.ASSET_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, false)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.ASSET_BALANCE, l, l2, l3));
        }
    }

    public void addToUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountAsset accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(this.id, l));
        long l3 = accountAsset == null ? 0L : accountAsset.unconfirmedQuantityQNT;
        l3 = Math.addExact(l3, l2);
        if (accountAsset == null) {
            accountAsset = new AccountAsset(this.id, l, 0L, l3);
        } else {
            accountAsset.unconfirmedQuantityQNT = l3;
        }
        accountAsset.save();
        assetListeners.notify(accountAsset, Event.UNCONFIRMED_ASSET_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, true)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.UNCONFIRMED_ASSET_BALANCE, l, l2, l3));
        }
    }

    public void addToAssetAndUnconfirmedAssetBalanceQNT(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountAsset accountAsset = (AccountAsset)accountAssetTable.get(accountAssetDbKeyFactory.newKey(this.id, l));
        long l3 = accountAsset == null ? 0L : accountAsset.quantityQNT;
        l3 = Math.addExact(l3, l2);
        long l4 = accountAsset == null ? 0L : accountAsset.unconfirmedQuantityQNT;
        l4 = Math.addExact(l4, l2);
        if (accountAsset == null) {
            accountAsset = new AccountAsset(this.id, l, l3, l4);
        } else {
            accountAsset.quantityQNT = l3;
            accountAsset.unconfirmedQuantityQNT = l4;
        }
        accountAsset.save();
        assetListeners.notify(accountAsset, Event.ASSET_BALANCE);
        assetListeners.notify(accountAsset, Event.UNCONFIRMED_ASSET_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, true)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.UNCONFIRMED_ASSET_BALANCE, l, l2, l4));
        }
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, false)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.ASSET_BALANCE, l, l2, l3));
        }
    }

    public void addToCurrencyUnits(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountCurrency accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(this.id, l));
        long l3 = accountCurrency == null ? 0L : accountCurrency.units;
        l3 = Math.addExact(l3, l2);
        if (accountCurrency == null) {
            accountCurrency = new AccountCurrency(this.id, l, l3, 0L);
        } else {
            accountCurrency.units = l3;
        }
        accountCurrency.save();
        currencyListeners.notify(accountCurrency, Event.CURRENCY_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, false)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.CURRENCY_BALANCE, l, l2, l3));
        }
    }

    public void addToUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountCurrency accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(this.id, l));
        long l3 = accountCurrency == null ? 0L : accountCurrency.unconfirmedUnits;
        l3 = Math.addExact(l3, l2);
        if (accountCurrency == null) {
            accountCurrency = new AccountCurrency(this.id, l, 0L, l3);
        } else {
            accountCurrency.unconfirmedUnits = l3;
        }
        accountCurrency.save();
        currencyListeners.notify(accountCurrency, Event.UNCONFIRMED_CURRENCY_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, true)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.UNCONFIRMED_CURRENCY_BALANCE, l, l2, l3));
        }
    }

    public void addToCurrencyAndUnconfirmedCurrencyUnits(AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        AccountCurrency accountCurrency = (AccountCurrency)accountCurrencyTable.get(accountCurrencyDbKeyFactory.newKey(this.id, l));
        long l3 = accountCurrency == null ? 0L : accountCurrency.units;
        l3 = Math.addExact(l3, l2);
        long l4 = accountCurrency == null ? 0L : accountCurrency.unconfirmedUnits;
        l4 = Math.addExact(l4, l2);
        if (accountCurrency == null) {
            accountCurrency = new AccountCurrency(this.id, l, l3, l4);
        } else {
            accountCurrency.units = l3;
            accountCurrency.unconfirmedUnits = l4;
        }
        accountCurrency.save();
        currencyListeners.notify(accountCurrency, Event.CURRENCY_BALANCE);
        currencyListeners.notify(accountCurrency, Event.UNCONFIRMED_CURRENCY_BALANCE);
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, true)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.UNCONFIRMED_CURRENCY_BALANCE, l, l2, l4));
        }
        if (AccountLedger.mustLogEntry(ledgerEvent, this.id, false)) {
            AccountLedger.logEntry(new AccountLedger.LedgerEntry(ledgerEvent, ledgerEventId, this.id, AccountLedger.LedgerHolding.CURRENCY_BALANCE, l, l2, l3));
        }
    }

    public void addToBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        chain.getBalanceHome().getBalance(this.id).addToBalance(ledgerEvent, ledgerEventId, l, l2);
    }

    public void addToUnconfirmedBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        chain.getBalanceHome().getBalance(this.id).addToUnconfirmedBalance(ledgerEvent, ledgerEventId, l, l2);
    }

    public void addToBalanceAndUnconfirmedBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l, long l2) {
        chain.getBalanceHome().getBalance(this.id).addToBalanceAndUnconfirmedBalance(ledgerEvent, ledgerEventId, l, l2);
    }

    public void addToBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
        chain.getBalanceHome().getBalance(this.id).addToBalance(ledgerEvent, ledgerEventId, l);
    }

    public void addToUnconfirmedBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
        chain.getBalanceHome().getBalance(this.id).addToUnconfirmedBalance(ledgerEvent, ledgerEventId, l);
    }

    public void addToBalanceAndUnconfirmedBalance(Chain chain, AccountLedger.LedgerEvent ledgerEvent, AccountLedger.LedgerEventId ledgerEventId, long l) {
        chain.getBalanceHome().getBalance(this.id).addToBalanceAndUnconfirmedBalance(ledgerEvent, ledgerEventId, l);
    }

    public void addToForgedBalanceFQT(long l) {
        if (l == 0L) {
            return;
        }
        this.forgedBalanceFQT = Math.addExact(this.forgedBalanceFQT, l);
        this.save();
    }

    static void checkBalance(long l, long l2, long l3) {
        if (l2 < 0L) {
            throw new DoubleSpendingException("Negative balance or quantity: ", l, l2, l3);
        }
        if (l3 < 0L) {
            throw new DoubleSpendingException("Negative unconfirmed balance or quantity: ", l, l2, l3);
        }
        if (l3 > l2) {
            throw new DoubleSpendingException("Unconfirmed exceeds confirmed balance or quantity: ", l, l2, l3);
        }
    }

    static void addToGuaranteedBalanceFQT(long l, long l2) {
        if (l2 <= 0L) {
            return;
        }
        int n = Nxt.getBlockchain().getHeight();
        try (Connection connection = accountGuaranteedBalanceTable.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT additions FROM account_guaranteed_balance WHERE account_id = ? and height = ?");
             PreparedStatement preparedStatement2 = connection.prepareStatement("MERGE INTO account_guaranteed_balance (account_id,  additions, height) KEY (account_id, height) VALUES(?, ?, ?)");){
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                long l3 = l2;
                if (resultSet.next()) {
                    l3 = Math.addExact(l3, resultSet.getLong("additions"));
                }
                preparedStatement2.setLong(1, l);
                preparedStatement2.setLong(2, l3);
                preparedStatement2.setInt(3, n);
                preparedStatement2.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public String toString() {
        return "Account " + Long.toUnsignedString(this.getId());
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            int n = block.getHeight();
            ArrayList<AccountLease> arrayList = new ArrayList<AccountLease>();
            Throwable object2 = null;
            try (Iterator<AccountLease> iterator = Account.getLeaseChangingAccounts(n);){
                while (((DbIterator)iterator).hasNext()) {
                    arrayList.add((AccountLease)((DbIterator)iterator).next());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
            for (AccountLease accountLease : arrayList) {
                Account account = Account.getAccount(accountLease.lessorId);
                if (n == accountLease.currentLeasingHeightFrom) {
                    account.activeLesseeId = accountLease.currentLesseeId;
                    leaseListeners.notify(accountLease, Event.LEASE_STARTED);
                } else if (n == accountLease.currentLeasingHeightTo) {
                    leaseListeners.notify(accountLease, Event.LEASE_ENDED);
                    account.activeLesseeId = 0L;
                    if (accountLease.nextLeasingHeightFrom == 0) {
                        accountLease.currentLeasingHeightFrom = 0;
                        accountLease.currentLeasingHeightTo = 0;
                        accountLease.currentLesseeId = 0L;
                        accountLeaseTable.delete(accountLease);
                    } else {
                        accountLease.currentLeasingHeightFrom = accountLease.nextLeasingHeightFrom;
                        accountLease.currentLeasingHeightTo = accountLease.nextLeasingHeightTo;
                        accountLease.currentLesseeId = accountLease.nextLesseeId;
                        accountLease.nextLeasingHeightFrom = 0;
                        accountLease.nextLeasingHeightTo = 0;
                        accountLease.nextLesseeId = 0L;
                        accountLeaseTable.insert(accountLease);
                        if (n == accountLease.currentLeasingHeightFrom) {
                            account.activeLesseeId = accountLease.currentLesseeId;
                            leaseListeners.notify(accountLease, Event.LEASE_STARTED);
                        }
                    }
                }
                account.save();
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
        if (publicKeyCache != null) {
            Nxt.getBlockchainProcessor().addListener(block -> {
                publicKeyCache.remove(accountDbKeyFactory.newKey(block.getGeneratorId()));
                block.getFxtTransactions().forEach(fxtTransaction -> {
                    publicKeyCache.remove(accountDbKeyFactory.newKey(fxtTransaction.getSenderId()));
                    fxtTransaction.getChildTransactions().forEach(childTransaction -> {
                        publicKeyCache.remove(accountDbKeyFactory.newKey(childTransaction.getSenderId()));
                        if (!childTransaction.getAppendages(appendix -> appendix instanceof PublicKeyAnnouncementAppendix, false).isEmpty()) {
                            publicKeyCache.remove(accountDbKeyFactory.newKey(childTransaction.getRecipientId()));
                        }
                        if (childTransaction.getType() == ShufflingTransactionType.SHUFFLING_RECIPIENTS) {
                            ShufflingRecipientsAttachment shufflingRecipientsAttachment = (ShufflingRecipientsAttachment)childTransaction.getAttachment();
                            for (byte[] byArray : shufflingRecipientsAttachment.getRecipientPublicKeys()) {
                                publicKeyCache.remove(accountDbKeyFactory.newKey(Account.getId(byArray)));
                            }
                        }
                    });
                });
            }, BlockchainProcessor.Event.BLOCK_POPPED);
            Nxt.getBlockchainProcessor().addListener(block -> publicKeyCache.clear(), BlockchainProcessor.Event.RESCAN_BEGIN);
        }
    }

    static class DoubleSpendingException
    extends RuntimeException {
        DoubleSpendingException(String string, long l, long l2, long l3) {
            super(string + " account: " + Long.toUnsignedString(l) + " confirmed: " + l2 + " unconfirmed: " + l3);
        }
    }

    public static final class PublicKey {
        private final long accountId;
        private final DbKey dbKey;
        private byte[] publicKey;
        private int height;

        private PublicKey(long l, byte[] byArray) {
            this.accountId = l;
            this.dbKey = publicKeyDbKeyFactory.newKey(l);
            this.publicKey = byArray;
            this.height = Nxt.getBlockchain().getHeight();
        }

        private PublicKey(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.publicKey = resultSet.getBytes("public_key");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            this.height = Nxt.getBlockchain().getHeight();
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO public_key (account_id, public_key, height, latest) KEY (account_id, height) VALUES (?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setBytes(preparedStatement, ++n, this.publicKey);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getAccountId() {
            return this.accountId;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public int getHeight() {
            return this.height;
        }

        static /* synthetic */ byte[] access$3302(PublicKey publicKey, byte[] byArray) {
            publicKey.publicKey = byArray;
            return byArray;
        }
    }

    public static final class AccountProperty {
        private final long id;
        private final DbKey dbKey;
        private final long recipientId;
        private final long setterId;
        private String property;
        private String value;

        private AccountProperty(long l, long l2, long l3, String string, String string2) {
            this.id = l;
            this.dbKey = accountPropertyDbKeyFactory.newKey(this.id);
            this.recipientId = l2;
            this.setterId = l3;
            this.property = string;
            this.value = string2;
        }

        private AccountProperty(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.recipientId = resultSet.getLong("recipient_id");
            long l = resultSet.getLong("setter_id");
            this.setterId = l == 0L ? this.recipientId : l;
            this.property = resultSet.getString("property");
            this.value = resultSet.getString("value");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_property (id, recipient_id, setter_id, property, value, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.recipientId);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.setterId != this.recipientId ? this.setterId : 0L);
                DbUtils.setString(preparedStatement, ++n, this.property);
                DbUtils.setString(preparedStatement, ++n, this.value);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public long getRecipientId() {
            return this.recipientId;
        }

        public long getSetterId() {
            return this.setterId;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class AccountInfo {
        private final long accountId;
        private final DbKey dbKey;
        private String name;
        private String description;

        private AccountInfo(long l, String string, String string2) {
            this.accountId = l;
            this.dbKey = accountInfoDbKeyFactory.newKey(this.accountId);
            this.name = string;
            this.description = string2;
        }

        private AccountInfo(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.name = resultSet.getString("name");
            this.description = resultSet.getString("description");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_info (account_id, name, description, height, latest) KEY (account_id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setString(preparedStatement, ++n, this.name);
                DbUtils.setString(preparedStatement, ++n, this.description);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getAccountId() {
            return this.accountId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        private void save() {
            if (this.name != null || this.description != null) {
                accountInfoTable.insert(this);
            } else {
                accountInfoTable.delete(this);
            }
        }
    }

    public static final class AccountLease {
        private final long lessorId;
        private final DbKey dbKey;
        private long currentLesseeId;
        private int currentLeasingHeightFrom;
        private int currentLeasingHeightTo;
        private long nextLesseeId;
        private int nextLeasingHeightFrom;
        private int nextLeasingHeightTo;

        private AccountLease(long l, int n, int n2, long l2) {
            this.lessorId = l;
            this.dbKey = accountLeaseDbKeyFactory.newKey(this.lessorId);
            this.currentLeasingHeightFrom = n;
            this.currentLeasingHeightTo = n2;
            this.currentLesseeId = l2;
        }

        private AccountLease(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.lessorId = resultSet.getLong("lessor_id");
            this.dbKey = dbKey;
            this.currentLeasingHeightFrom = resultSet.getInt("current_leasing_height_from");
            this.currentLeasingHeightTo = resultSet.getInt("current_leasing_height_to");
            this.currentLesseeId = resultSet.getLong("current_lessee_id");
            this.nextLeasingHeightFrom = resultSet.getInt("next_leasing_height_from");
            this.nextLeasingHeightTo = resultSet.getInt("next_leasing_height_to");
            this.nextLesseeId = resultSet.getLong("next_lessee_id");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_lease (lessor_id, current_leasing_height_from, current_leasing_height_to, current_lessee_id, next_leasing_height_from, next_leasing_height_to, next_lessee_id, height, latest) KEY (lessor_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.lessorId);
                DbUtils.setIntZeroToNull(preparedStatement, ++n, this.currentLeasingHeightFrom);
                DbUtils.setIntZeroToNull(preparedStatement, ++n, this.currentLeasingHeightTo);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.currentLesseeId);
                DbUtils.setIntZeroToNull(preparedStatement, ++n, this.nextLeasingHeightFrom);
                DbUtils.setIntZeroToNull(preparedStatement, ++n, this.nextLeasingHeightTo);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.nextLesseeId);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getLessorId() {
            return this.lessorId;
        }

        public long getCurrentLesseeId() {
            return this.currentLesseeId;
        }

        public int getCurrentLeasingHeightFrom() {
            return this.currentLeasingHeightFrom;
        }

        public int getCurrentLeasingHeightTo() {
            return this.currentLeasingHeightTo;
        }

        public long getNextLesseeId() {
            return this.nextLesseeId;
        }

        public int getNextLeasingHeightFrom() {
            return this.nextLeasingHeightFrom;
        }

        public int getNextLeasingHeightTo() {
            return this.nextLeasingHeightTo;
        }
    }

    public static final class AccountCurrency {
        private final long accountId;
        private final long currencyId;
        private final DbKey dbKey;
        private long units;
        private long unconfirmedUnits;

        private AccountCurrency(long l, long l2, long l3, long l4) {
            this.accountId = l;
            this.currencyId = l2;
            this.dbKey = accountCurrencyDbKeyFactory.newKey(this.accountId, this.currencyId);
            this.units = l3;
            this.unconfirmedUnits = l4;
        }

        private AccountCurrency(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.currencyId = resultSet.getLong("currency_id");
            this.dbKey = dbKey;
            this.units = resultSet.getLong("units");
            this.unconfirmedUnits = resultSet.getLong("unconfirmed_units");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_currency (account_id, currency_id, units, unconfirmed_units, height, latest) KEY (account_id, currency_id, height) VALUES (?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.currencyId);
                preparedStatement.setLong(++n, this.units);
                preparedStatement.setLong(++n, this.unconfirmedUnits);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getCurrencyId() {
            return this.currencyId;
        }

        public long getUnits() {
            return this.units;
        }

        public long getUnconfirmedUnits() {
            return this.unconfirmedUnits;
        }

        private void save() {
            Account.checkBalance(this.accountId, this.units, this.unconfirmedUnits);
            if (this.units > 0L || this.unconfirmedUnits > 0L) {
                accountCurrencyTable.insert(this);
            } else if (this.units == 0L && this.unconfirmedUnits == 0L) {
                accountCurrencyTable.delete(this);
            }
        }

        public String toString() {
            return "AccountCurrency account_id: " + Long.toUnsignedString(this.accountId) + " currency_id: " + Long.toUnsignedString(this.currencyId) + " quantity: " + this.units + " unconfirmedQuantity: " + this.unconfirmedUnits;
        }
    }

    public static final class AccountAsset {
        private final long accountId;
        private final long assetId;
        private final DbKey dbKey;
        private long quantityQNT;
        private long unconfirmedQuantityQNT;

        private AccountAsset(long l, long l2, long l3, long l4) {
            this.accountId = l;
            this.assetId = l2;
            this.dbKey = accountAssetDbKeyFactory.newKey(this.accountId, this.assetId);
            this.quantityQNT = l3;
            this.unconfirmedQuantityQNT = l4;
        }

        private AccountAsset(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.assetId = resultSet.getLong("asset_id");
            this.dbKey = dbKey;
            this.quantityQNT = resultSet.getLong("quantity");
            this.unconfirmedQuantityQNT = resultSet.getLong("unconfirmed_quantity");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_asset (account_id, asset_id, quantity, unconfirmed_quantity, height, latest) KEY (account_id, asset_id, height) VALUES (?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setLong(++n, this.assetId);
                preparedStatement.setLong(++n, this.quantityQNT);
                preparedStatement.setLong(++n, this.unconfirmedQuantityQNT);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getQuantityQNT() {
            return this.quantityQNT;
        }

        public long getUnconfirmedQuantityQNT() {
            return this.unconfirmedQuantityQNT;
        }

        private void save() {
            Account.checkBalance(this.accountId, this.quantityQNT, this.unconfirmedQuantityQNT);
            if (this.quantityQNT > 0L || this.unconfirmedQuantityQNT > 0L) {
                accountAssetTable.insert(this);
            } else {
                accountAssetTable.delete(this);
            }
        }

        public String toString() {
            return "AccountAsset account_id: " + Long.toUnsignedString(this.accountId) + " asset_id: " + Long.toUnsignedString(this.assetId) + " quantity: " + this.quantityQNT + " unconfirmedQuantity: " + this.unconfirmedQuantityQNT;
        }
    }

    public static enum ControlType {
        PHASING_ONLY;

    }

    public static enum Event {
        ASSET_BALANCE,
        UNCONFIRMED_ASSET_BALANCE,
        CURRENCY_BALANCE,
        UNCONFIRMED_CURRENCY_BALANCE,
        LEASE_SCHEDULED,
        LEASE_STARTED,
        LEASE_ENDED,
        SET_PROPERTY,
        DELETE_PROPERTY;

    }
}

