/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedValuesDbTable;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;
import nxt.voting.AccountControlTransactionType;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingControl;
import nxt.voting.PhasingParams;
import nxt.voting.SetPhasingOnlyAttachment;
import nxt.voting.VoteWeighting;
import nxt.voting.VotingTransactionType;

public final class AccountRestrictions {
    private static final DbKey.LongKeyFactory<PhasingOnly> phasingControlDbKeyFactory = new DbKey.LongKeyFactory<PhasingOnly>("account_id"){

        @Override
        public DbKey newKey(PhasingOnly phasingOnly) {
            return phasingOnly.dbKey;
        }
    };
    private static final VersionedEntityDbTable<PhasingOnly> phasingControlTable = new VersionedEntityDbTable<PhasingOnly>("public.account_control_phasing", phasingControlDbKeyFactory){

        @Override
        protected PhasingOnly load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingOnly(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingOnly phasingOnly) throws SQLException {
            phasingOnly.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<PhasingOnly> phasingControlSubPollDbKeyFactory = new DbKey.LongKeyFactory<PhasingOnly>("account_id"){

        @Override
        public DbKey newKey(PhasingOnly phasingOnly) {
            return phasingOnly.dbKey == null ? this.newKey(phasingOnly.accountId) : phasingOnly.dbKey;
        }
    };
    private static final VersionedValuesDbTable<PhasingOnly, PhasingOnlySubPoll> phasingControlSubPollTable = new VersionedValuesDbTable<PhasingOnly, PhasingOnlySubPoll>("public.account_control_phasing_sub_poll", phasingControlSubPollDbKeyFactory){

        @Override
        protected PhasingOnlySubPoll load(Connection connection, ResultSet resultSet) throws SQLException {
            return new PhasingOnlySubPoll(resultSet);
        }

        @Override
        protected void save(Connection connection, PhasingOnly phasingOnly, PhasingOnlySubPoll phasingOnlySubPoll) throws SQLException {
            phasingOnlySubPoll.save(connection);
        }
    };

    public static void init() {
    }

    public static void checkTransaction(ChildTransaction childTransaction) throws NxtException.NotCurrentlyValidException {
        Account account = Account.getAccount(childTransaction.getSenderId());
        if (account == null) {
            if (Nxt.getBlockchain().getHeight() >= Constants.MISSING_TX_SENDER_BLOCK) {
                return;
            }
            throw new NxtException.NotCurrentlyValidException("Account " + Convert.rsAccount(childTransaction.getSenderId()) + " does not exist yet");
        }
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            PhasingOnly phasingOnly = PhasingOnly.get(childTransaction.getSenderId());
            phasingOnly.checkTransaction(childTransaction);
        }
    }

    public static void checkTransaction(FxtTransaction fxtTransaction) throws NxtException.NotCurrentlyValidException {
        Account account = Account.getAccount(fxtTransaction.getSenderId());
        if (account == null) {
            throw new NxtException.NotCurrentlyValidException("Account " + Convert.rsAccount(fxtTransaction.getSenderId()) + " does not exist yet");
        }
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            throw new NxtException.AccountControlException(String.format("Account %s is under account control and cannot submit forging chain transaction %d:%s", Convert.rsAccount(fxtTransaction.getSenderId()), fxtTransaction.getChain().getId(), Convert.toHexString(fxtTransaction.getFullHash())));
        }
    }

    public static boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        Account account = Account.getAccount(transaction.getSenderId());
        if (account == null) {
            return false;
        }
        if (!account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return false;
        }
        if (PhasingOnly.get(transaction.getSenderId()).getMaxFees().get(transaction.getChain().getId()) == null) {
            return false;
        }
        return transaction.getType() != AccountControlTransactionType.SET_PHASING_ONLY && TransactionType.isDuplicate(AccountControlTransactionType.SET_PHASING_ONLY, Long.toUnsignedString(account.getId()), map, true);
    }

    static final class PhasingOnlySubPoll
    extends PhasingControl.SubPoll {
        private final long accountId;

        private PhasingOnlySubPoll(long l, String string, PhasingParams phasingParams) {
            super(string, phasingParams);
            this.accountId = l;
        }

        private PhasingOnlySubPoll(ResultSet resultSet) throws SQLException {
            super(resultSet);
            this.accountId = resultSet.getLong("account_id");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO account_control_phasing_sub_poll (account_id, name, whitelist, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height, latest) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setString(++n, this.variableName);
                DbUtils.setArray(preparedStatement, ++n, Convert.toArray(this.params.getWhitelist()));
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }

    public static final class PhasingOnly
    extends PhasingControl {
        public static final String DEFAULT_ACCOUNT_CONTROL_VARIABLE = "ACC";
        private final DbKey dbKey;
        private final long accountId;
        private Map<Integer, Long> maxFees;
        private short minDuration;
        private short maxDuration;

        public static PhasingOnly get(long l) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("phasing"));
            }
            return (PhasingOnly)phasingControlTable.getBy(new DbClause.LongClause("account_id", l).and(new DbClause.ByteClause("voting_model", DbClause.Op.NE, VoteWeighting.VotingModel.NONE.getCode())));
        }

        public static int getCount() {
            return phasingControlTable.getCount();
        }

        public static DbIterator<PhasingOnly> getAll(int n, int n2) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("phasing"));
            }
            return phasingControlTable.getAll(n, n2);
        }

        public static void set(Account account, SetPhasingOnlyAttachment setPhasingOnlyAttachment) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("phasing"));
            }
            PhasingParams phasingParams = setPhasingOnlyAttachment.getPhasingParams();
            long l = account.getId();
            if (phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.NONE) {
                account.removeControl(Account.ControlType.PHASING_ONLY);
                PhasingOnly phasingOnly = PhasingOnly.get(l);
                phasingOnly.params = phasingParams;
                phasingControlTable.delete(phasingOnly);
                if (!phasingOnly.params.getSubPolls().isEmpty()) {
                    phasingControlSubPollTable.delete(phasingOnly);
                }
            } else {
                account.addControl(Account.ControlType.PHASING_ONLY);
                PhasingOnly phasingOnly = PhasingOnly.get(l);
                if (phasingOnly == null) {
                    phasingOnly = new PhasingOnly(l, phasingParams, setPhasingOnlyAttachment.getMaxFees(), setPhasingOnlyAttachment.getMinDuration(), setPhasingOnlyAttachment.getMaxDuration());
                } else {
                    phasingOnly.params = phasingParams;
                    phasingOnly.maxFees = setPhasingOnlyAttachment.getMaxFees();
                    phasingOnly.minDuration = setPhasingOnlyAttachment.getMinDuration();
                    phasingOnly.maxDuration = setPhasingOnlyAttachment.getMaxDuration();
                }
                phasingControlTable.insert(phasingOnly);
                SortedMap<String, PhasingParams> sortedMap = phasingOnly.params.getSubPolls();
                if (!sortedMap.isEmpty()) {
                    phasingControlSubPollTable.insert(phasingOnly, sortedMap.entrySet().stream().map(entry -> new PhasingOnlySubPoll(l, (String)entry.getKey(), (PhasingParams)entry.getValue())).collect(Collectors.toList()));
                }
            }
        }

        public static void importPhasingOnly(long l, long[] lArray, int n, long l2, int n2, int n3) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("phasing"));
            }
            Account.getAccount(l).addControl(Account.ControlType.PHASING_ONLY);
            HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
            if (l2 > 0L) {
                hashMap.put(ChildChain.IGNIS.getId(), l2);
            }
            PhasingOnly phasingOnly = new PhasingOnly(l, new PhasingParams(new VoteWeighting(0, 0L, 0L, 0), (long)n, lArray, null, null, null, null, null), hashMap, (short)n2, (short)n3);
            phasingControlTable.insert(phasingOnly);
        }

        private PhasingOnly(long l, PhasingParams phasingParams, Map<Integer, Long> map, short s, short s2) {
            super(phasingParams);
            this.accountId = l;
            this.dbKey = phasingControlDbKeyFactory.newKey(this.accountId);
            this.maxFees = map;
            this.minDuration = s;
            this.maxDuration = s2;
        }

        private PhasingOnly(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            this.init(resultSet, () -> phasingControlSubPollTable.get(phasingControlSubPollDbKeyFactory.newKey(this)));
            Integer[] integerArray = (Integer[])DbUtils.getArray(resultSet, "max_fees_chains", Integer[].class);
            Long[] longArray = (Long[])DbUtils.getArray(resultSet, "max_fees", Long[].class);
            this.maxFees = new HashMap<Integer, Long>(integerArray.length);
            for (int i = 0; i < integerArray.length; ++i) {
                this.maxFees.put(integerArray[i], longArray[i]);
            }
            this.minDuration = resultSet.getShort("min_duration");
            this.maxDuration = resultSet.getShort("max_duration");
        }

        @Override
        public final String getControlType() {
            return "account";
        }

        @Override
        public final String getDefaultControlVariable() {
            return DEFAULT_ACCOUNT_CONTROL_VARIABLE;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public Map<Integer, Long> getMaxFees() {
            return this.maxFees;
        }

        public short getMinDuration() {
            return this.minDuration;
        }

        public short getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        protected void checkTransaction(ChildTransaction childTransaction) throws NxtException.AccountControlException {
            long l;
            ChildChain childChain = childTransaction.getChain();
            Long l2 = this.maxFees.get(childChain.getId());
            if (l2 != null && (l = Math.addExact(childTransaction.getFee(), childChain.getPhasingPollHome().getSenderPhasedTransactionFees(childTransaction.getSenderId()))) > l2) {
                throw new NxtException.AccountControlException(String.format("Maximum total fees limit of %f %s (%d NQT) exceeded, total fees are %f %s (%d NQT)", (double)l2.longValue() / (double)childChain.ONE_COIN, childChain.getName(), l2, (double)l / (double)childChain.ONE_COIN, childChain.getName(), l));
            }
            if (childTransaction.getType() == VotingTransactionType.PHASING_VOTE_CASTING) {
                return;
            }
            try {
                this.params.checkApprovable();
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                Logger.logDebugMessage("Account control no longer valid: " + notCurrentlyValidException.getMessage());
                return;
            }
            PhasingAppendix phasingAppendix = childTransaction.getPhasing();
            this.checkPhasing(phasingAppendix);
            int n = phasingAppendix.getFinishHeight() - Nxt.getBlockchain().getHeight();
            if (this.maxDuration > 0 && n > this.maxDuration || this.minDuration > 0 && n < this.minDuration) {
                throw new NxtException.AccountControlException("Invalid phasing duration " + n);
            }
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_control_phasing (account_id, whitelist, max_fees_chains, max_fees, expression, min_duration, max_duration, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height, latest) KEY (account_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, Convert.toArray(this.params.getWhitelist()));
                Integer[] integerArray = new Integer[this.maxFees.size()];
                Long[] longArray = new Long[this.maxFees.size()];
                int n2 = 0;
                for (Map.Entry<Integer, Long> entry : this.maxFees.entrySet()) {
                    integerArray[n2] = entry.getKey();
                    longArray[n2] = entry.getValue();
                    ++n2;
                }
                DbUtils.setArray(preparedStatement, ++n, integerArray);
                DbUtils.setArray(preparedStatement, ++n, longArray);
                preparedStatement.setString(++n, this.params.getExpressionStr());
                preparedStatement.setShort(++n, this.minDuration);
                preparedStatement.setShort(++n, this.maxDuration);
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }
}

