/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.PaymentAttachment;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.TransactionType;
import org.json.simple.JSONObject;

public abstract class PaymentTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_PAYMENT_ORDINARY_PAYMENT = 0;
    public static final TransactionType ORDINARY = new PaymentTransactionType(){

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public final AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ORDINARY_PAYMENT;
        }

        @Override
        public String getName() {
            return "OrdinaryPayment";
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(ByteBuffer byteBuffer) {
            return PaymentAttachment.INSTANCE;
        }

        @Override
        public Attachment.EmptyAttachment parseAttachment(JSONObject jSONObject) {
            return PaymentAttachment.INSTANCE;
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            if (childTransactionImpl.getAmount() <= 0L || childTransactionImpl.getAmount() >= 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid ordinary payment");
            }
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ORDINARY;
            }
        }
        return null;
    }

    private PaymentTransactionType() {
    }

    @Override
    public final byte getType() {
        return 0;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean canHaveRecipient() {
        return true;
    }

    @Override
    public final boolean isPhasingSafe() {
        return true;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

