/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import nxt.blockchain.Bundler;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.TransactionType;
import nxt.ms.Currency;
import nxt.ms.CurrencyMintingAttachment;
import nxt.ms.CurrencyTransferAttachment;
import nxt.ms.ExchangeAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.ms.ReserveClaimAttachment;
import nxt.ms.ReserveIncreaseAttachment;
import nxt.util.Convert;

public class CurrencyBundler
implements Bundler.Filter {
    private long currencyId;

    @Override
    public boolean ok(Bundler bundler, ChildTransaction childTransaction) {
        TransactionType transactionType = childTransaction.getType();
        if (transactionType instanceof MonetarySystemTransactionType) {
            long l;
            if (transactionType == MonetarySystemTransactionType.CURRENCY_TRANSFER) {
                CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)childTransaction.getAttachment();
                l = currencyTransferAttachment.getCurrencyId();
            } else if (transactionType == MonetarySystemTransactionType.EXCHANGE_BUY || transactionType == MonetarySystemTransactionType.EXCHANGE_SELL) {
                ExchangeAttachment exchangeAttachment = (ExchangeAttachment)childTransaction.getAttachment();
                l = exchangeAttachment.getCurrencyId();
            } else if (transactionType == MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER) {
                PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)childTransaction.getAttachment();
                l = publishExchangeOfferAttachment.getCurrencyId();
            } else if (transactionType == MonetarySystemTransactionType.RESERVE_INCREASE) {
                ReserveIncreaseAttachment reserveIncreaseAttachment = (ReserveIncreaseAttachment)childTransaction.getAttachment();
                l = reserveIncreaseAttachment.getCurrencyId();
            } else if (transactionType == MonetarySystemTransactionType.RESERVE_CLAIM) {
                ReserveClaimAttachment reserveClaimAttachment = (ReserveClaimAttachment)childTransaction.getAttachment();
                l = reserveClaimAttachment.getCurrencyId();
            } else if (transactionType == MonetarySystemTransactionType.CURRENCY_MINTING) {
                CurrencyMintingAttachment currencyMintingAttachment = (CurrencyMintingAttachment)childTransaction.getAttachment();
                l = currencyMintingAttachment.getCurrencyId();
            } else {
                return false;
            }
            return l == this.currencyId;
        }
        return false;
    }

    @Override
    public void setParameter(String string) {
        long l = Convert.parseUnsignedLong(string);
        if (Currency.getCurrency(l) == null) {
            throw new IllegalArgumentException("Unknown currency " + string);
        }
        this.currencyId = l;
    }

    @Override
    public String getParameter() {
        return Long.toUnsignedString(this.currencyId);
    }

    @Override
    public String getName() {
        return "CurrencyBundler";
    }

    @Override
    public String getDescription() {
        return "Bundles only transactions for MS currency with ID provided as parameter";
    }
}

