/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import nxt.account.Account;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildTransaction;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.dgs.FeedbackAttachment;
import nxt.dgs.PurchaseAttachment;
import nxt.util.Convert;

public class PurchaseBundler
implements Bundler.Filter {
    private long sellerId;

    @Override
    public boolean ok(Bundler bundler, ChildTransaction childTransaction) {
        long l = 0L;
        if (childTransaction.getType() == DigitalGoodsTransactionType.PURCHASE) {
            PurchaseAttachment purchaseAttachment = (PurchaseAttachment)childTransaction.getAttachment();
            DigitalGoodsHome.Goods goods = childTransaction.getChain().getDigitalGoodsHome().getGoods(purchaseAttachment.getGoodsId());
            if (goods != null) {
                l = goods.getSellerId();
            }
        } else if (childTransaction.getType() == DigitalGoodsTransactionType.FEEDBACK) {
            FeedbackAttachment feedbackAttachment = (FeedbackAttachment)childTransaction.getAttachment();
            DigitalGoodsHome.Purchase purchase = childTransaction.getChain().getDigitalGoodsHome().getPurchase(feedbackAttachment.getPurchaseId());
            if (purchase != null) {
                l = purchase.getSellerId();
            }
        }
        return l == this.sellerId;
    }

    @Override
    public String getName() {
        return "PurchaseBundler";
    }

    @Override
    public String getDescription() {
        return "Bundles only purchases of digital goods sold by an account provided as parameter";
    }

    @Override
    public String getParameter() {
        return Convert.rsAccount(this.sellerId);
    }

    @Override
    public void setParameter(String string) {
        long l = Convert.parseAccountId(string);
        if (Account.getAccount(l) == null) {
            throw new IllegalArgumentException("Unknown seller account " + string);
        }
        this.sellerId = l;
    }
}

