/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import nxt.addons.AbstractContractContext;
import nxt.addons.AbstractOperationContext;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.JO;
import nxt.blockchain.Transaction;
import nxt.http.callers.GetBlockCall;
import nxt.http.callers.GetTransactionCall;
import nxt.http.responses.BlockResponse;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;

public class TransactionContext
extends AbstractOperationContext {
    private JO transactionJson;
    private TransactionResponse transactionResponse;
    private JO blockJson;

    public TransactionContext(Transaction transaction, ContractRunnerConfig contractRunnerConfig, JO jO, String string, String string2) {
        super(transaction.getFullHash(), transaction.getChain().getId(), transaction.getBlockId(), contractRunnerConfig, jO, string, string2);
        this.source = AbstractContractContext.EventSource.TRANSACTION;
    }

    @Override
    protected JO getTransactionJson() {
        if (this.transactionJson != null) {
            return this.transactionJson;
        }
        this.transactionJson = GetTransactionCall.create(this.chain).fullHash(Convert.toHexString(this.fullHash)).call();
        return this.transactionJson;
    }

    @Override
    public TransactionResponse getTransaction() {
        if (this.transactionResponse != null) {
            return this.transactionResponse;
        }
        this.transactionResponse = TransactionResponse.create(this.getTransactionJson());
        return this.transactionResponse;
    }

    private JO getBlockJson() {
        if (this.blockJson != null) {
            return this.blockJson;
        }
        this.blockJson = GetBlockCall.create().block(this.blockId).call();
        return this.blockJson;
    }

    @Override
    public BlockResponse getBlock() {
        return BlockResponse.create(this.getBlockJson());
    }

    @Override
    protected JO addTriggerData(JO jO) {
        if (this.chain == 1) {
            jO.put("trigger", this.chain + ":" + Convert.toHexString(this.fullHash));
        }
        return super.addTriggerData(jO);
    }

    @Override
    protected String getReferencedTransaction() {
        if (this.chain == 1) {
            return null;
        }
        return this.chain + ":" + Convert.toHexString(this.fullHash);
    }
}

