/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.TransactionType;

public class TransactionTypeBundler
implements Bundler.Filter {
    private List<TransactionType> types;

    @Override
    public boolean ok(Bundler bundler, ChildTransaction childTransaction) {
        return this.types.contains(childTransaction.getType());
    }

    @Override
    public String getName() {
        return "TransactionTypeBundler";
    }

    @Override
    public String getDescription() {
        return "Bundles only transaction types provided as parameter. The parameter must be comma separated string, which contains <type>:<subtype> pairs specifying the \"type\" and \"subtype\" identifier of thewhitelisted transaction types. The \"type\" and \"subtype\" identifiers can be found in the transactionSubTypes field of the getConstants result.";
    }

    @Override
    public void setParameter(String string2) {
        this.types = Arrays.stream(string2.split(",")).map(string -> {
            String[] stringArray = string.split(":");
            return TransactionType.findTransactionType(Byte.parseByte(stringArray[0].trim()), Byte.parseByte(stringArray[1].trim()));
        }).collect(Collectors.toList());
    }

    @Override
    public String getParameter() {
        return this.types.stream().map(transactionType -> transactionType.getType() + ":" + transactionType.getSubtype()).collect(Collectors.joining(","));
    }
}

