/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.ae.AssetExchangeTransactionType;
import nxt.ae.SetPhasingAssetControlAttachment;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.TransactionType;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.db.VersionedValuesDbTable;
import nxt.shuffling.ShufflingCreationAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingControl;
import nxt.voting.PhasingParams;
import nxt.voting.VoteWeighting;

public class AssetControl {
    private static final Set<TransactionType> ASSET_CONTROL_TRANSACTION_TYPES = Collections.unmodifiableSet(new HashSet<TransactionType>(Arrays.asList(AssetExchangeTransactionType.ASSET_TRANSFER, AssetExchangeTransactionType.ASSET_DELETE, AssetExchangeTransactionType.ASK_ORDER_PLACEMENT, AssetExchangeTransactionType.BID_ORDER_PLACEMENT, AssetExchangeTransactionType.DIVIDEND_PAYMENT, ShufflingTransactionType.SHUFFLING_CREATION)));
    private static final DbKey.LongKeyFactory<PhasingOnly> phasingControlDbKeyFactory = new DbKey.LongKeyFactory<PhasingOnly>("asset_id"){

        @Override
        public DbKey newKey(PhasingOnly phasingOnly) {
            return phasingOnly.dbKey;
        }
    };
    private static final VersionedEntityDbTable<PhasingOnly> phasingControlTable = new VersionedEntityDbTable<PhasingOnly>("public.asset_control_phasing", phasingControlDbKeyFactory){

        @Override
        protected PhasingOnly load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingOnly(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingOnly phasingOnly) throws SQLException {
            phasingOnly.save(connection);
        }
    };
    private static final DbKey.LongKeyFactory<PhasingOnly> phasingControlSubPollDbKeyFactory = new DbKey.LongKeyFactory<PhasingOnly>("asset_id"){

        @Override
        public DbKey newKey(PhasingOnly phasingOnly) {
            return phasingOnly.dbKey == null ? this.newKey(phasingOnly.assetId) : phasingOnly.dbKey;
        }
    };
    private static final VersionedValuesDbTable<PhasingOnly, PhasingOnlySubPoll> phasingControlSubPollTable = new VersionedValuesDbTable<PhasingOnly, PhasingOnlySubPoll>("public.asset_control_phasing_sub_poll", phasingControlSubPollDbKeyFactory){

        @Override
        protected PhasingOnlySubPoll load(Connection connection, ResultSet resultSet) throws SQLException {
            return new PhasingOnlySubPoll(resultSet);
        }

        @Override
        protected void save(Connection connection, PhasingOnly phasingOnly, PhasingOnlySubPoll phasingOnlySubPoll) throws SQLException {
            phasingOnlySubPoll.save(connection);
        }
    };

    public static void init() {
    }

    public static void checkTransaction(ChildTransaction childTransaction) throws NxtException.NotCurrentlyValidException {
        Object object;
        TransactionType transactionType = childTransaction.getType();
        if (!ASSET_CONTROL_TRANSACTION_TYPES.contains(transactionType)) {
            return;
        }
        long l = 0L;
        if (transactionType instanceof AssetExchangeTransactionType) {
            object = (AssetExchangeTransactionType)transactionType;
            l = ((AssetExchangeTransactionType)object).getAssetId(childTransaction);
        } else if (ShufflingTransactionType.SHUFFLING_CREATION.equals(transactionType) && ((ShufflingCreationAttachment)(object = (ShufflingCreationAttachment)childTransaction.getAttachment())).getHoldingType() == HoldingType.ASSET) {
            l = ((ShufflingCreationAttachment)object).getHoldingId();
        }
        if (l == 0L) {
            return;
        }
        object = Asset.getAsset(l);
        if (object == null) {
            throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(l) + " does not exist yet");
        }
        if (((Asset)object).hasPhasingControl()) {
            if (ShufflingTransactionType.SHUFFLING_CREATION.equals(transactionType)) {
                throw new NxtException.NotCurrentlyValidException("Shuffling of asset under asset control is not supported");
            }
            PhasingOnly phasingOnly = PhasingOnly.get(l);
            phasingOnly.checkTransaction(childTransaction);
            PhasingParams phasingParams = phasingOnly.getPhasingParams();
            if (AssetExchangeTransactionType.DIVIDEND_PAYMENT.equals(childTransaction.getType()) && phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.PROPERTY && phasingParams.getRecipientPropertyVoting().getSetterId() != 0L) {
                throw new NxtException.NotCurrentlyValidException("Dividend payment with asset under by-recipient property control is not supported");
            }
        }
    }

    static final class PhasingOnlySubPoll
    extends PhasingControl.SubPoll {
        private final long assetId;

        private PhasingOnlySubPoll(long l, String string, PhasingParams phasingParams) {
            super(string, phasingParams);
            this.assetId = l;
        }

        private PhasingOnlySubPoll(ResultSet resultSet) throws SQLException {
            super(resultSet);
            this.assetId = resultSet.getLong("asset_id");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO asset_control_phasing_sub_poll (asset_id, name, whitelist, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height, latest) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.assetId);
                preparedStatement.setString(++n, this.variableName);
                DbUtils.setArray(preparedStatement, ++n, Convert.toArray(this.params.getWhitelist()));
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }

    public static final class PhasingOnly
    extends PhasingControl {
        public static final String DEFAULT_ASSET_CONTROL_VARIABLE = "ASC";
        private final DbKey dbKey;
        private final long assetId;

        public static PhasingOnly get(long l) {
            return (PhasingOnly)phasingControlTable.getBy(new DbClause.LongClause("asset_id", l).and(new DbClause.ByteClause("voting_model", DbClause.Op.NE, VoteWeighting.VotingModel.NONE.getCode())));
        }

        public static int getCount() {
            return phasingControlTable.getCount();
        }

        public static DbIterator<PhasingOnly> getAll(int n, int n2) {
            return phasingControlTable.getAll(n, n2);
        }

        static void set(SetPhasingAssetControlAttachment setPhasingAssetControlAttachment) {
            PhasingParams phasingParams = setPhasingAssetControlAttachment.getPhasingParams();
            long l = setPhasingAssetControlAttachment.getAssetId();
            Asset asset = Asset.getAsset(l);
            if (phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.NONE) {
                asset.setHasPhasingControl(false);
                PhasingOnly phasingOnly = PhasingOnly.get(l);
                phasingOnly.params = phasingParams;
                phasingControlTable.delete(phasingOnly);
                if (!phasingOnly.params.getSubPolls().isEmpty()) {
                    phasingControlSubPollTable.delete(phasingOnly);
                }
            } else {
                asset.setHasPhasingControl(true);
                PhasingOnly phasingOnly = PhasingOnly.get(l);
                if (phasingOnly == null) {
                    phasingOnly = new PhasingOnly(l, phasingParams);
                } else {
                    phasingOnly.params = phasingParams;
                }
                phasingControlTable.insert(phasingOnly);
                SortedMap<String, PhasingParams> sortedMap = phasingOnly.params.getSubPolls();
                if (!sortedMap.isEmpty()) {
                    phasingControlSubPollTable.insert(phasingOnly, sortedMap.entrySet().stream().map(entry -> new PhasingOnlySubPoll(l, (String)entry.getKey(), (PhasingParams)entry.getValue())).collect(Collectors.toList()));
                }
            }
        }

        private PhasingOnly(long l, PhasingParams phasingParams) {
            super(phasingParams);
            this.assetId = l;
            this.dbKey = phasingControlDbKeyFactory.newKey(this.assetId);
        }

        private PhasingOnly(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.assetId = resultSet.getLong("asset_id");
            this.dbKey = dbKey;
            this.init(resultSet, () -> phasingControlSubPollTable.get(phasingControlSubPollDbKeyFactory.newKey(this)));
        }

        public long getAssetId() {
            return this.assetId;
        }

        @Override
        public final String getControlType() {
            return "asset";
        }

        @Override
        public final String getDefaultControlVariable() {
            return DEFAULT_ASSET_CONTROL_VARIABLE;
        }

        @Override
        protected void checkTransaction(ChildTransaction childTransaction) throws NxtException.AccountControlException {
            try {
                this.params.checkApprovable();
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                Logger.logDebugMessage("Asset control no longer valid: " + notCurrentlyValidException.getMessage());
                return;
            }
            PhasingAppendix phasingAppendix = childTransaction.getPhasing();
            this.checkPhasing(phasingAppendix);
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO asset_control_phasing (asset_id, whitelist, expression, voting_model, quorum, min_balance, holding_id, min_balance_model, sender_property_setter_id, sender_property_name, sender_property_value, recipient_property_setter_id, recipient_property_name, recipient_property_value, height, latest) KEY (asset_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.assetId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, Convert.toArray(this.params.getWhitelist()));
                preparedStatement.setString(++n, this.params.getExpressionStr());
                n = PhasingParams.setCommonColumnValues(this.params, preparedStatement, n);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }
}

