/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.ae.DividendPaymentAttachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class AssetDividendHome {
    private static final Listeners<AssetDividend, Event> listeners = new Listeners();
    private final ChildChain childChain;
    private final DbKey.HashKeyFactory<AssetDividend> dividendDbKeyFactory;
    private final EntityDbTable<AssetDividend> assetDividendTable;

    public static AssetDividendHome forChain(ChildChain childChain) {
        if (childChain.getAssetDividendHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new AssetDividendHome(childChain);
    }

    public static boolean addListener(Listener<AssetDividend> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<AssetDividend> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    private AssetDividendHome(ChildChain childChain) {
        this.childChain = childChain;
        this.dividendDbKeyFactory = new DbKey.HashKeyFactory<AssetDividend>("full_hash", "id"){

            @Override
            public DbKey newKey(AssetDividend assetDividend) {
                return assetDividend.dbKey;
            }
        };
        this.assetDividendTable = new EntityDbTable<AssetDividend>(childChain.getSchemaTable("asset_dividend"), this.dividendDbKeyFactory){

            @Override
            protected AssetDividend load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new AssetDividend(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, AssetDividend assetDividend) throws SQLException {
                assetDividend.save(connection);
            }
        };
    }

    public DbIterator<AssetDividend> getAssetDividends(long l, int n, int n2) {
        return this.assetDividendTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    AssetDividend getLastDividend(long l) {
        try (DbIterator<AssetDividend> dbIterator = this.assetDividendTable.getManyBy(new DbClause.LongClause("asset_id", l), 0, 0);){
            if (dbIterator.hasNext()) {
                AssetDividend assetDividend = dbIterator.next();
                return assetDividend;
            }
        }
        return null;
    }

    void payDividends(Transaction transaction, DividendPaymentAttachment dividendPaymentAttachment) {
        long l = 0L;
        long l2 = transaction.getSenderId();
        long l3 = dividendPaymentAttachment.getAssetId();
        int n = dividendPaymentAttachment.getHeight();
        Account account = Account.getAccount(l2);
        Asset asset = Asset.getAsset(l3);
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transaction);
        HoldingType holdingType = dividendPaymentAttachment.getHoldingType();
        long l4 = dividendPaymentAttachment.getHoldingId();
        long l5 = asset.getQuantityQNT() - account.getAssetBalanceQNT(l3, n);
        long l6 = dividendPaymentAttachment.getAmountNQT();
        long l7 = Convert.unitRateToAmount(l5, asset.getDecimals(), l6, holdingType.getDecimals(l4));
        ArrayList<Account.AccountAsset> arrayList = new ArrayList<Account.AccountAsset>();
        try (DbIterator<Account.AccountAsset> dbIterator = Account.getAssetAccounts(dividendPaymentAttachment.getAssetId(), dividendPaymentAttachment.getHeight(), 0, -1);){
            while (dbIterator.hasNext()) {
                arrayList.add(dbIterator.next());
            }
        }
        long l8 = 0L;
        for (Account.AccountAsset accountAsset : arrayList) {
            long l9;
            if (accountAsset.getAccountId() == l2 || accountAsset.getQuantityQNT() == 0L || (l9 = Convert.unitRateToAmount(accountAsset.getQuantityQNT(), asset.getDecimals(), l6, holdingType.getDecimals(l4))) <= 0L) continue;
            Account account2 = Account.getAccount(accountAsset.getAccountId());
            holdingType.addToBalanceAndUnconfirmedBalance(account2, AccountLedger.LedgerEvent.ASSET_DIVIDEND_PAYMENT, ledgerEventId, l4, l9);
            l += l9;
            ++l8;
            l7 -= l9;
        }
        holdingType.addToBalance(account, AccountLedger.LedgerEvent.ASSET_DIVIDEND_PAYMENT, ledgerEventId, l4, -l);
        if (l7 != 0L) {
            holdingType.addToUnconfirmedBalance(account, AccountLedger.LedgerEvent.ASSET_DIVIDEND_PAYMENT, ledgerEventId, l4, l7);
        }
        AssetDividend assetDividend = new AssetDividend(transaction, dividendPaymentAttachment, l, l8);
        this.assetDividendTable.insert(assetDividend);
        listeners.notify(assetDividend, Event.ASSET_DIVIDEND);
    }

    public final class AssetDividend {
        private final long id;
        private final byte[] hash;
        private final DbKey dbKey;
        private final long holdingId;
        private final HoldingType holdingType;
        private final long assetId;
        private final long amountNQT;
        private final int dividendHeight;
        private final long totalDividend;
        private final long numAccounts;
        private final int timestamp;
        private final int height;

        private AssetDividend(Transaction transaction, DividendPaymentAttachment dividendPaymentAttachment, long l, long l2) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.dbKey = AssetDividendHome.this.dividendDbKeyFactory.newKey(this.hash, this.id);
            this.holdingId = dividendPaymentAttachment.getHoldingId();
            this.holdingType = dividendPaymentAttachment.getHoldingType();
            this.assetId = dividendPaymentAttachment.getAssetId();
            this.amountNQT = dividendPaymentAttachment.getAmountNQT();
            this.dividendHeight = dividendPaymentAttachment.getHeight();
            this.totalDividend = l;
            this.numAccounts = l2;
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
            this.height = Nxt.getBlockchain().getHeight();
        }

        private AssetDividend(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.holdingId = resultSet.getLong("holding_id");
            this.holdingType = HoldingType.get(resultSet.getByte("holding_type"));
            this.assetId = resultSet.getLong("asset_id");
            this.amountNQT = resultSet.getLong("amount");
            this.dividendHeight = resultSet.getInt("dividend_height");
            this.totalDividend = resultSet.getLong("total_dividend");
            this.numAccounts = resultSet.getLong("num_accounts");
            this.timestamp = resultSet.getInt("timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO asset_dividend (id, full_hash, holding_id, holding_type, asset_id, amount, dividend_height, total_dividend, num_accounts, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.holdingId);
                preparedStatement.setByte(++n, this.holdingType.getCode());
                preparedStatement.setLong(++n, this.assetId);
                preparedStatement.setLong(++n, this.amountNQT);
                preparedStatement.setInt(++n, this.dividendHeight);
                preparedStatement.setLong(++n, this.totalDividend);
                preparedStatement.setLong(++n, this.numAccounts);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getHoldingId() {
            return this.holdingId;
        }

        public HoldingType getHoldingType() {
            return this.holdingType;
        }

        public long getAssetId() {
            return this.assetId;
        }

        public long getAmountNQT() {
            return this.amountNQT;
        }

        public int getDividendHeight() {
            return this.dividendHeight;
        }

        public long getTotalDividend() {
            return this.totalDividend;
        }

        public long getNumAccounts() {
            return this.numAccounts;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public int getHeight() {
            return this.height;
        }

        public ChildChain getChildChain() {
            return AssetDividendHome.this.childChain;
        }
    }

    public static enum Event {
        ASSET_DIVIDEND;

    }
}

