/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.account.HoldingType;
import nxt.ae.AskOrderCancellationAttachment;
import nxt.ae.AskOrderPlacementAttachment;
import nxt.ae.Asset;
import nxt.ae.AssetControl;
import nxt.ae.AssetDeleteAttachment;
import nxt.ae.AssetDividendHome;
import nxt.ae.AssetFreezeMonitor;
import nxt.ae.AssetIncreaseAttachment;
import nxt.ae.AssetIssuanceAttachment;
import nxt.ae.AssetPropertyAttachment;
import nxt.ae.AssetPropertyDeleteAttachment;
import nxt.ae.AssetTransfer;
import nxt.ae.AssetTransferAttachment;
import nxt.ae.BidOrderCancellationAttachment;
import nxt.ae.BidOrderPlacementAttachment;
import nxt.ae.DividendPaymentAttachment;
import nxt.ae.OrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.ae.OrderPlacementAttachment;
import nxt.ae.SetPhasingAssetControlAttachment;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.ms.Currency;
import nxt.ms.CurrencyType;
import nxt.util.Convert;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;

public abstract class AssetExchangeTransactionType<Att extends Attachment>
extends ChildTransactionType {
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASSET_ISSUANCE = 0;
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASSET_TRANSFER = 1;
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASK_ORDER_PLACEMENT = 2;
    private static final byte SUBTYPE_ASSET_EXCHANGE_BID_ORDER_PLACEMENT = 3;
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASK_ORDER_CANCELLATION = 4;
    private static final byte SUBTYPE_ASSET_EXCHANGE_BID_ORDER_CANCELLATION = 5;
    private static final byte SUBTYPE_ASSET_EXCHANGE_DIVIDEND_PAYMENT = 6;
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASSET_DELETE = 7;
    private static final byte SUBTYPE_ASSET_EXCHANGE_ASSET_INCREASE = 8;
    private static final byte SUBTYPE_ASSET_EXCHANGE_SET_PHASING_CONTROL = 9;
    private static final byte SUBTYPE_ASSET_EXCHANGE_PROPERTY_SET = 10;
    private static final byte SUBTYPE_ASSET_EXCHANGE_PROPERTY_DELETE = 11;
    public static final TransactionType ASSET_ISSUANCE = new AssetExchangeTransactionType<AssetIssuanceAttachment>(){
        private final Fee SINGLETON_ASSET_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                AssetIssuanceAttachment assetIssuanceAttachment = (AssetIssuanceAttachment)transactionImpl.getAttachment();
                return assetIssuanceAttachment.getDescription().length();
            }
        };
        private final Fee ASSET_ISSUANCE_FEE = (transactionImpl, appendix) -> 10000000000L;

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_ISSUANCE;
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            return childTransaction.getId();
        }

        @Override
        protected void checkLiquid(ChildTransaction childTransaction) {
        }

        @Override
        public String getName() {
            return "AssetIssuance";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.isSingletonIssuance(transaction) ? this.SINGLETON_ASSET_FEE : this.ASSET_ISSUANCE_FEE;
        }

        @Override
        public AssetIssuanceAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AssetIssuanceAttachment(byteBuffer);
        }

        @Override
        public AssetIssuanceAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetIssuanceAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetIssuanceAttachment assetIssuanceAttachment = (AssetIssuanceAttachment)childTransactionImpl.getAttachment();
            Asset.addAsset(childTransactionImpl, assetIssuanceAttachment);
            account.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), childTransactionImpl.getId(), assetIssuanceAttachment.getQuantityQNT());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        protected void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetIssuanceAttachment assetIssuanceAttachment) throws NxtException.ValidationException {
            if (assetIssuanceAttachment.getName().length() < 3 || !AssetIssuanceAttachment.NAME_RW.validate(assetIssuanceAttachment.getName()) || !AssetIssuanceAttachment.DESCRIPTION_RW.validate(assetIssuanceAttachment.getDescription()) || assetIssuanceAttachment.getDecimals() < 0 || assetIssuanceAttachment.getDecimals() > 8 || assetIssuanceAttachment.getQuantityQNT() <= 0L || assetIssuanceAttachment.getQuantityQNT() > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid asset issuance: " + assetIssuanceAttachment.getJSONObject());
            }
            String string = assetIssuanceAttachment.getName().toLowerCase(Locale.ROOT);
            for (int i = 0; i < string.length(); ++i) {
                if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string.charAt(i)) >= 0) continue;
                throw new NxtException.NotValidException("Invalid asset name: " + string);
            }
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (Asset.getAsset(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate asset id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return !this.isSingletonIssuance(transaction) && 1.isDuplicate(ASSET_ISSUANCE, this.getName(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }

        @Override
        public final boolean isGlobal() {
            return true;
        }

        private boolean isSingletonIssuance(Transaction transaction) {
            AssetIssuanceAttachment assetIssuanceAttachment = (AssetIssuanceAttachment)transaction.getAttachment();
            return assetIssuanceAttachment.getQuantityQNT() == 1L && assetIssuanceAttachment.getDecimals() == 0 && assetIssuanceAttachment.getDescription().length() <= 160;
        }
    };
    public static final TransactionType ASSET_TRANSFER = new AssetExchangeTransactionType<AssetTransferAttachment>(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_TRANSFER;
        }

        @Override
        public String getName() {
            return "AssetTransfer";
        }

        @Override
        public AssetTransferAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AssetTransferAttachment(byteBuffer);
        }

        @Override
        public AssetTransferAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetTransferAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)childTransactionImpl.getAttachment();
            long l = account.getUnconfirmedAssetBalanceQNT(assetTransferAttachment.getAssetId());
            if (l >= assetTransferAttachment.getQuantityQNT()) {
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetTransferAttachment.getAssetId(), -assetTransferAttachment.getQuantityQNT());
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)childTransactionImpl.getAttachment();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            account.addToAssetBalanceQNT(this.getLedgerEvent(), ledgerEventId, assetTransferAttachment.getAssetId(), -assetTransferAttachment.getQuantityQNT());
            account2.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), ledgerEventId, assetTransferAttachment.getAssetId(), assetTransferAttachment.getQuantityQNT());
            AssetTransfer.addAssetTransfer(childTransactionImpl, assetTransferAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)childTransactionImpl.getAttachment();
            account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetTransferAttachment.getAssetId(), assetTransferAttachment.getQuantityQNT());
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetTransferAttachment assetTransferAttachment) throws NxtException.ValidationException {
            if (childTransactionImpl.getAmount() != 0L || assetTransferAttachment.getAssetId() == 0L) {
                throw new NxtException.NotValidException("Invalid asset transfer amount or asset: " + assetTransferAttachment.getJSONObject());
            }
            long l = assetTransferAttachment.getQuantityQNT();
            if (l <= 0L || l > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid asset transfer quantity: " + assetTransferAttachment.getJSONObject());
            }
            Asset asset = Asset.getAsset(assetTransferAttachment.getAssetId());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(assetTransferAttachment.getAssetId()) + " does not exist yet");
            }
            if (l > asset.getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Invalid asset transfer quantity: " + assetTransferAttachment.getJSONObject());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            AssetTransferAttachment assetTransferAttachment = (AssetTransferAttachment)childTransaction.getAttachment();
            return assetTransferAttachment.getAssetId();
        }
    };
    public static final TransactionType ASSET_DELETE = new AssetExchangeTransactionType<AssetDeleteAttachment>(){

        @Override
        public final byte getSubtype() {
            return 7;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_DELETE;
        }

        @Override
        public String getName() {
            return "AssetDelete";
        }

        @Override
        public AssetDeleteAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AssetDeleteAttachment(byteBuffer);
        }

        @Override
        public AssetDeleteAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetDeleteAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)childTransactionImpl.getAttachment();
            long l = account.getUnconfirmedAssetBalanceQNT(assetDeleteAttachment.getAssetId());
            if (l >= assetDeleteAttachment.getQuantityQNT()) {
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetDeleteAttachment.getAssetId(), -assetDeleteAttachment.getQuantityQNT());
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)childTransactionImpl.getAttachment();
            account.addToAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetDeleteAttachment.getAssetId(), -assetDeleteAttachment.getQuantityQNT());
            Asset.deleteAsset(childTransactionImpl, assetDeleteAttachment.getAssetId(), assetDeleteAttachment.getQuantityQNT());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)childTransactionImpl.getAttachment();
            account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetDeleteAttachment.getAssetId(), assetDeleteAttachment.getQuantityQNT());
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetDeleteAttachment assetDeleteAttachment) throws NxtException.ValidationException {
            if (assetDeleteAttachment.getAssetId() == 0L) {
                throw new NxtException.NotValidException("Invalid asset identifier: " + assetDeleteAttachment.getJSONObject());
            }
            long l = assetDeleteAttachment.getQuantityQNT();
            if (l <= 0L || l > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid asset delete quantity: " + assetDeleteAttachment.getJSONObject());
            }
            Asset asset = Asset.getAsset(assetDeleteAttachment.getAssetId());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(assetDeleteAttachment.getAssetId()) + " does not exist yet");
            }
            if (l > asset.getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Invalid asset delete quantity: " + assetDeleteAttachment.getJSONObject());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)childTransaction.getAttachment();
            return assetDeleteAttachment.getAssetId();
        }
    };
    public static final TransactionType ASSET_INCREASE = new AssetExchangeTransactionType<AssetIncreaseAttachment>(){

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            return ((AssetIncreaseAttachment)childTransaction.getAttachment()).getAssetId();
        }

        @Override
        public final byte getSubtype() {
            return 8;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_INCREASE;
        }

        @Override
        public String getName() {
            return "AssetIncrease";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return new Fee.ConstantFee(1000000000L);
        }

        @Override
        public AssetIncreaseAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AssetIncreaseAttachment(byteBuffer);
        }

        @Override
        public AssetIncreaseAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetIncreaseAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetIncreaseAttachment assetIncreaseAttachment = (AssetIncreaseAttachment)childTransactionImpl.getAttachment();
            account.addToAssetAndUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), assetIncreaseAttachment.getAssetId(), assetIncreaseAttachment.getQuantityQNT());
            Asset.increaseAsset(childTransactionImpl, assetIncreaseAttachment.getAssetId(), assetIncreaseAttachment.getQuantityQNT());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetIncreaseAttachment assetIncreaseAttachment) throws NxtException.ValidationException {
            if (assetIncreaseAttachment.getAssetId() == 0L) {
                throw new NxtException.NotValidException("Invalid asset identifier: " + assetIncreaseAttachment.getJSONObject());
            }
            long l = assetIncreaseAttachment.getQuantityQNT();
            if (l <= 0L || l > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid asset increase quantity: " + assetIncreaseAttachment.getJSONObject());
            }
            Asset asset = Asset.getAsset(assetIncreaseAttachment.getAssetId());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(assetIncreaseAttachment.getAssetId()) + " does not exist yet");
            }
            if (100000000000000000L - l < asset.getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Invalid asset increase quantity: " + assetIncreaseAttachment.getJSONObject());
            }
            if (asset.getQuantityQNT() == 1L) {
                throw new NxtException.NotCurrentlyValidException("No quantity increase allowed for single share assets");
            }
            if (asset.getQuantityQNT() == 0L) {
                throw new NxtException.NotCurrentlyValidException("No quantity increase allowed for deleted assets");
            }
            if (childTransactionImpl.getSenderId() != asset.getAccountId()) {
                throw new NxtException.NotValidException("Only asset issuer can increase asset quantity");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            AssetIncreaseAttachment assetIncreaseAttachment = (AssetIncreaseAttachment)transaction.getAttachment();
            return 4.isDuplicate(ASSET_INCREASE, Long.toUnsignedString(assetIncreaseAttachment.getAssetId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }

        @Override
        public final boolean isGlobal() {
            return true;
        }
    };
    public static final TransactionType ASK_ORDER_PLACEMENT = new OrderPlacement(){

        @Override
        public final byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_ASK_ORDER_PLACEMENT;
        }

        @Override
        public String getName() {
            return "AskOrderPlacement";
        }

        @Override
        public AskOrderPlacementAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AskOrderPlacementAttachment(byteBuffer);
        }

        @Override
        public AskOrderPlacementAttachment parseAttachment(JSONObject jSONObject) {
            return new AskOrderPlacementAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AskOrderPlacementAttachment askOrderPlacementAttachment = (AskOrderPlacementAttachment)childTransactionImpl.getAttachment();
            long l = account.getUnconfirmedAssetBalanceQNT(askOrderPlacementAttachment.getAssetId());
            if (l >= 0L && l >= askOrderPlacementAttachment.getQuantityQNT()) {
                account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), askOrderPlacementAttachment.getAssetId(), -askOrderPlacementAttachment.getQuantityQNT());
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AskOrderPlacementAttachment askOrderPlacementAttachment = (AskOrderPlacementAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getOrderHome().addAskOrder(childTransactionImpl, askOrderPlacementAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            AskOrderPlacementAttachment askOrderPlacementAttachment = (AskOrderPlacementAttachment)childTransactionImpl.getAttachment();
            account.addToUnconfirmedAssetBalanceQNT(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), askOrderPlacementAttachment.getAssetId(), askOrderPlacementAttachment.getQuantityQNT());
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getOrderHome().getAskOrder(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate ask order id " + childTransactionImpl.getStringId());
            }
        }
    };
    public static final TransactionType BID_ORDER_PLACEMENT = new OrderPlacement(){

        @Override
        public final byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_BID_ORDER_PLACEMENT;
        }

        @Override
        public String getName() {
            return "BidOrderPlacement";
        }

        @Override
        public BidOrderPlacementAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new BidOrderPlacementAttachment(byteBuffer);
        }

        @Override
        public BidOrderPlacementAttachment parseAttachment(JSONObject jSONObject) {
            return new BidOrderPlacementAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            BidOrderPlacementAttachment bidOrderPlacementAttachment = (BidOrderPlacementAttachment)childTransactionImpl.getAttachment();
            ChildChain childChain = childTransactionImpl.getChain();
            Asset asset = Asset.getAsset(bidOrderPlacementAttachment.getAssetId());
            long l = Convert.unitRateToAmount(bidOrderPlacementAttachment.getQuantityQNT(), asset.getDecimals(), bidOrderPlacementAttachment.getPriceNQT(), childChain.getDecimals());
            BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
            if (balance.getUnconfirmedBalance() >= l) {
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -l);
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            BidOrderPlacementAttachment bidOrderPlacementAttachment = (BidOrderPlacementAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getOrderHome().addBidOrder(childTransactionImpl, bidOrderPlacementAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            BidOrderPlacementAttachment bidOrderPlacementAttachment = (BidOrderPlacementAttachment)childTransactionImpl.getAttachment();
            ChildChain childChain = childTransactionImpl.getChain();
            Asset asset = Asset.getAsset(bidOrderPlacementAttachment.getAssetId());
            if (asset == null) {
                return;
            }
            long l = Convert.unitRateToAmount(bidOrderPlacementAttachment.getQuantityQNT(), asset.getDecimals(), bidOrderPlacementAttachment.getPriceNQT(), childChain.getDecimals());
            account.addToUnconfirmedBalance(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), l);
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getOrderHome().getBidOrder(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate bid order id " + childTransactionImpl.getStringId());
            }
        }
    };
    public static final TransactionType ASK_ORDER_CANCELLATION = new OrderCancellation<AskOrderCancellationAttachment>(){

        @Override
        protected OrderHome.Order getOrder(OrderHome orderHome, long l) {
            return orderHome.getAskOrder(l);
        }

        @Override
        public final byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_ASK_ORDER_CANCELLATION;
        }

        @Override
        public String getName() {
            return "AskOrderCancellation";
        }

        @Override
        public AskOrderCancellationAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AskOrderCancellationAttachment(byteBuffer);
        }

        @Override
        public AskOrderCancellationAttachment parseAttachment(JSONObject jSONObject) {
            return new AskOrderCancellationAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AskOrderCancellationAttachment askOrderCancellationAttachment = (AskOrderCancellationAttachment)childTransactionImpl.getAttachment();
            OrderHome orderHome = childTransactionImpl.getChain().getOrderHome();
            OrderHome.Ask ask = orderHome.getAskOrder(askOrderCancellationAttachment.getOrderId());
            if (ask == null) {
                return;
            }
            ((OrderHome.Order)ask).cancelOrder(AccountLedger.newEventId(childTransactionImpl));
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, AskOrderCancellationAttachment askOrderCancellationAttachment) throws NxtException.ValidationException {
            OrderHome.Ask ask = childTransactionImpl.getChain().getOrderHome().getAskOrder(askOrderCancellationAttachment.getOrderId());
            if (ask == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid ask order: " + Long.toUnsignedString(askOrderCancellationAttachment.getOrderId()));
            }
            if (ask.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Order " + Long.toUnsignedString(askOrderCancellationAttachment.getOrderId()) + " was created by account " + Convert.rsAccount(ask.getAccountId()));
            }
        }
    };
    public static final TransactionType BID_ORDER_CANCELLATION = new OrderCancellation<BidOrderCancellationAttachment>(){

        @Override
        protected OrderHome.Order getOrder(OrderHome orderHome, long l) {
            return orderHome.getBidOrder(l);
        }

        @Override
        public final byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_BID_ORDER_CANCELLATION;
        }

        @Override
        public String getName() {
            return "BidOrderCancellation";
        }

        @Override
        public BidOrderCancellationAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new BidOrderCancellationAttachment(byteBuffer);
        }

        @Override
        public BidOrderCancellationAttachment parseAttachment(JSONObject jSONObject) {
            return new BidOrderCancellationAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            BidOrderCancellationAttachment bidOrderCancellationAttachment = (BidOrderCancellationAttachment)childTransactionImpl.getAttachment();
            OrderHome orderHome = childTransactionImpl.getChain().getOrderHome();
            OrderHome.Bid bid = orderHome.getBidOrder(bidOrderCancellationAttachment.getOrderId());
            if (bid == null) {
                return;
            }
            ((OrderHome.Order)bid).cancelOrder(AccountLedger.newEventId(childTransactionImpl));
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, BidOrderCancellationAttachment bidOrderCancellationAttachment) throws NxtException.ValidationException {
            OrderHome.Bid bid = childTransactionImpl.getChain().getOrderHome().getBidOrder(bidOrderCancellationAttachment.getOrderId());
            if (bid == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid bid order: " + Long.toUnsignedString(bidOrderCancellationAttachment.getOrderId()));
            }
            if (bid.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Order " + Long.toUnsignedString(bidOrderCancellationAttachment.getOrderId()) + " was created by account " + Convert.rsAccount(bid.getAccountId()));
            }
        }
    };
    public static final TransactionType DIVIDEND_PAYMENT = new AssetExchangeTransactionType<DividendPaymentAttachment>(){

        @Override
        public final byte getSubtype() {
            return 6;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_DIVIDEND_PAYMENT;
        }

        @Override
        public String getName() {
            return "DividendPayment";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return new Fee.ConstantFee(10000000L);
        }

        @Override
        public DividendPaymentAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new DividendPaymentAttachment(byteBuffer);
        }

        @Override
        public DividendPaymentAttachment parseAttachment(JSONObject jSONObject) {
            return new DividendPaymentAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)childTransactionImpl.getAttachment();
            long l = dividendPaymentAttachment.getAssetId();
            Asset asset = Asset.getAsset(l, dividendPaymentAttachment.getHeight());
            if (asset == null) {
                return true;
            }
            HoldingType holdingType = dividendPaymentAttachment.getHoldingType();
            long l2 = asset.getQuantityQNT() - account.getAssetBalanceQNT(l, dividendPaymentAttachment.getHeight());
            long l3 = Convert.unitRateToAmount(l2, asset.getDecimals(), dividendPaymentAttachment.getAmountNQT(), holdingType.getDecimals(dividendPaymentAttachment.getHoldingId()));
            if (l3 == 0L) {
                return true;
            }
            if (holdingType.getUnconfirmedBalance(account, dividendPaymentAttachment.getHoldingId()) >= l3) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), dividendPaymentAttachment.getHoldingId(), -l3);
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getAssetDividendHome().payDividends(childTransactionImpl, dividendPaymentAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)childTransactionImpl.getAttachment();
            long l = dividendPaymentAttachment.getAssetId();
            Asset asset = Asset.getAsset(l, dividendPaymentAttachment.getHeight());
            if (asset == null) {
                return;
            }
            HoldingType holdingType = dividendPaymentAttachment.getHoldingType();
            long l2 = asset.getQuantityQNT() - account.getAssetBalanceQNT(l, dividendPaymentAttachment.getHeight());
            long l3 = Convert.unitRateToAmount(l2, asset.getDecimals(), dividendPaymentAttachment.getAmountNQT(), holdingType.getDecimals(dividendPaymentAttachment.getHoldingId()));
            if (l3 > 0L) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), dividendPaymentAttachment.getHoldingId(), l3);
            }
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, DividendPaymentAttachment dividendPaymentAttachment) throws NxtException.ValidationException {
            if (dividendPaymentAttachment.getHeight() > Nxt.getBlockchain().getHeight()) {
                throw new NxtException.NotCurrentlyValidException("Invalid dividend payment height: " + dividendPaymentAttachment.getHeight() + ", must not exceed current blockchain height " + Nxt.getBlockchain().getHeight());
            }
            if (dividendPaymentAttachment.getHeight() <= dividendPaymentAttachment.getFinishValidationHeight(childTransactionImpl) - 1441) {
                throw new NxtException.NotCurrentlyValidException("Invalid dividend payment height: " + dividendPaymentAttachment.getHeight() + ", must be less than " + 1441 + " blocks before " + dividendPaymentAttachment.getFinishValidationHeight(childTransactionImpl));
            }
            Asset asset = Asset.getAsset(dividendPaymentAttachment.getAssetId(), dividendPaymentAttachment.getHeight());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(dividendPaymentAttachment.getAssetId()) + " for dividend payment doesn't exist yet");
            }
            if (asset.getAccountId() != childTransactionImpl.getSenderId() || dividendPaymentAttachment.getAmountNQT() <= 0L) {
                throw new NxtException.NotValidException("Invalid dividend payment sender or amount " + dividendPaymentAttachment.getJSONObject());
            }
            AssetDividendHome.AssetDividend assetDividend = childTransactionImpl.getChain().getAssetDividendHome().getLastDividend(dividendPaymentAttachment.getAssetId());
            if (assetDividend != null && assetDividend.getHeight() > Nxt.getBlockchain().getHeight() - Constants.MIN_DIVIDEND_PAYMENT_INTERVAL) {
                throw new NxtException.NotCurrentlyValidException("Last dividend payment for asset " + Long.toUnsignedString(dividendPaymentAttachment.getAssetId()) + " was less than " + Constants.MIN_DIVIDEND_PAYMENT_INTERVAL + " blocks ago at " + assetDividend.getHeight() + ", current height is " + Nxt.getBlockchain().getHeight());
            }
            HoldingType holdingType = dividendPaymentAttachment.getHoldingType();
            switch (holdingType) {
                case COIN: {
                    if (dividendPaymentAttachment.getHoldingId() == (long)childTransactionImpl.getChain().getId()) break;
                    throw new NxtException.NotValidException("Holding id " + Long.toUnsignedString(dividendPaymentAttachment.getHoldingId()) + " does not match chain id " + childTransactionImpl.getChain().getId());
                }
                case ASSET: {
                    Asset asset2 = Asset.getAsset(dividendPaymentAttachment.getHoldingId());
                    if (asset2 != null) break;
                    throw new NxtException.NotCurrentlyValidException("Unknown asset " + Long.toUnsignedString(dividendPaymentAttachment.getHoldingId()));
                }
                case CURRENCY: {
                    Currency currency = Currency.getCurrency(dividendPaymentAttachment.getHoldingId());
                    CurrencyType.validate(currency, (Transaction)childTransactionImpl);
                    if (currency.isActive()) break;
                    throw new NxtException.NotCurrentlyValidException("Currency is not active: " + currency.getCode());
                }
                default: {
                    throw new RuntimeException("Unsupported holding type " + (Object)((Object)holdingType));
                }
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)transaction.getAttachment();
            return 9.isDuplicate(DIVIDEND_PAYMENT, Long.toUnsignedString(dividendPaymentAttachment.getAssetId()), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            DividendPaymentAttachment dividendPaymentAttachment = (DividendPaymentAttachment)childTransaction.getAttachment();
            if (dividendPaymentAttachment.getHoldingType() == HoldingType.ASSET) {
                return dividendPaymentAttachment.getHoldingId();
            }
            return 0L;
        }

        @Override
        protected void checkLiquid(ChildTransaction childTransaction) throws NxtException.NotCurrentlyValidException {
            long l = this.getAssetId(childTransaction);
            if (l != 0L) {
                AssetFreezeMonitor.checkLiquid(l);
            }
            long l2 = ((DividendPaymentAttachment)childTransaction.getAttachment()).getAssetId();
            AssetFreezeMonitor.checkLiquid(l2);
        }
    };
    public static final TransactionType SET_PHASING_CONTROL = new AssetExchangeTransactionType<SetPhasingAssetControlAttachment>(){

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return new Fee.ConstantFee(1000000000L);
        }

        @Override
        public byte getSubtype() {
            return 9;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_SET_PHASING_CONTROL;
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new SetPhasingAssetControlAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new SetPhasingAssetControlAttachment(jSONObject);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }

        @Override
        public final boolean isGlobal() {
            return true;
        }

        @Override
        public String getName() {
            return "SetPhasingAssetControl";
        }

        @Override
        protected void validateAttachment(ChildTransactionImpl childTransactionImpl, SetPhasingAssetControlAttachment setPhasingAssetControlAttachment) throws NxtException.ValidationException {
            VoteWeighting.VotingModel votingModel = setPhasingAssetControlAttachment.getPhasingParams().getVoteWeighting().getVotingModel();
            setPhasingAssetControlAttachment.getPhasingParams().validateRestrictableParams();
            Asset asset = Asset.getAsset(setPhasingAssetControlAttachment.getAssetId());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(setPhasingAssetControlAttachment.getAssetId()) + " does not exist yet");
            }
            if (votingModel == VoteWeighting.VotingModel.NONE) {
                if (!asset.hasPhasingControl()) {
                    throw new NxtException.NotCurrentlyValidException("Phasing asset control is not currently enabled");
                }
            } else if (votingModel == VoteWeighting.VotingModel.TRANSACTION || votingModel == VoteWeighting.VotingModel.HASH) {
                throw new NxtException.NotValidException("Invalid voting model " + (Object)((Object)votingModel) + " for asset control");
            }
            if (asset.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Asset control can only be set by the asset issuer");
            }
            if (!asset.hasPhasingControl()) {
                Account.AccountAsset accountAsset = Account.getAccountAsset(childTransactionImpl.getSenderId(), setPhasingAssetControlAttachment.getAssetId());
                long l = asset.getQuantityQNT();
                if (accountAsset == null || accountAsset.getQuantityQNT() < l || accountAsset.getUnconfirmedQuantityQNT() < l) {
                    throw new NxtException.NotCurrentlyValidException("Adding asset control requires the asset issuer to own all asset units");
                }
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            SetPhasingAssetControlAttachment setPhasingAssetControlAttachment = (SetPhasingAssetControlAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(SET_PHASING_CONTROL, Long.toUnsignedString(setPhasingAssetControlAttachment.getAssetId()), map, true);
        }

        @Override
        protected boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        protected void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            SetPhasingAssetControlAttachment setPhasingAssetControlAttachment = (SetPhasingAssetControlAttachment)childTransactionImpl.getAttachment();
            AssetControl.PhasingOnly.set(setPhasingAssetControlAttachment);
        }

        @Override
        protected void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            SetPhasingAssetControlAttachment setPhasingAssetControlAttachment = (SetPhasingAssetControlAttachment)childTransaction.getAttachment();
            return setPhasingAssetControlAttachment.getAssetId();
        }
    };
    public static final TransactionType ASSET_PROPERTY_SET = new AssetPropertyTransactionType<AssetPropertyAttachment>(){
        private final Fee ASSET_PROPERTY_FEE = new Fee.SizeBasedFee(10000000L, 10000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                AssetPropertyAttachment assetPropertyAttachment = (AssetPropertyAttachment)transactionImpl.getAttachment();
                return assetPropertyAttachment.getValue().length();
            }
        };

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            return ((AssetPropertyAttachment)childTransaction.getAttachment()).getAssetId();
        }

        @Override
        public byte getSubtype() {
            return 10;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_PROPERTY_SET;
        }

        @Override
        public String getName() {
            return "AssetProperty";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.ASSET_PROPERTY_FEE;
        }

        @Override
        public AssetPropertyAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AssetPropertyAttachment(byteBuffer);
        }

        @Override
        public AssetPropertyAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetPropertyAttachment(jSONObject);
        }

        @Override
        protected void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetPropertyAttachment assetPropertyAttachment) throws NxtException.ValidationException {
            if (!AssetPropertyAttachment.PROPERTY_NAME_RW.validate(assetPropertyAttachment.getProperty()) || assetPropertyAttachment.getProperty().length() == 0 || !AssetPropertyAttachment.PROPERTY_VALUE_RW.validate(assetPropertyAttachment.getValue())) {
                throw new NxtException.NotValidException("Invalid asset property: " + assetPropertyAttachment.getJSONObject());
            }
            this.checkRecipient(Asset.getAsset(assetPropertyAttachment.getAssetId()), childTransactionImpl.getRecipientId());
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Asset property transaction cannot be used to send money");
            }
        }

        @Override
        protected void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetPropertyAttachment assetPropertyAttachment = (AssetPropertyAttachment)childTransactionImpl.getAttachment();
            Asset.getAsset(assetPropertyAttachment.getAssetId()).setProperty(childTransactionImpl.getId(), account, assetPropertyAttachment.getProperty(), assetPropertyAttachment.getValue());
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (Asset.getProperty(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate asset property id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType ASSET_PROPERTY_DELETE = new AssetPropertyTransactionType<AssetPropertyDeleteAttachment>(){

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            AssetPropertyDeleteAttachment assetPropertyDeleteAttachment = (AssetPropertyDeleteAttachment)childTransaction.getAttachment();
            Asset.AssetProperty assetProperty = Asset.getProperty(assetPropertyDeleteAttachment.getPropertyId());
            return assetProperty != null ? assetProperty.getAssetId() : 0L;
        }

        @Override
        public byte getSubtype() {
            return 11;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ASSET_PROPERTY_DELETE;
        }

        @Override
        public String getName() {
            return "AssetPropertyDelete";
        }

        @Override
        public AssetPropertyDeleteAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new AssetPropertyDeleteAttachment(byteBuffer);
        }

        @Override
        public AssetPropertyDeleteAttachment parseAttachment(JSONObject jSONObject) {
            return new AssetPropertyDeleteAttachment(jSONObject);
        }

        @Override
        protected void validateAttachment(ChildTransactionImpl childTransactionImpl, AssetPropertyDeleteAttachment assetPropertyDeleteAttachment) throws NxtException.ValidationException {
            Asset.AssetProperty assetProperty = Asset.getProperty(assetPropertyDeleteAttachment.getPropertyId());
            if (assetProperty == null) {
                throw new NxtException.NotCurrentlyValidException("No such property " + Long.toUnsignedString(assetPropertyDeleteAttachment.getPropertyId()));
            }
            Asset asset = Asset.getAsset(assetProperty.getAssetId());
            if (asset.getAccountId() != childTransactionImpl.getSenderId() && assetProperty.getSetterId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotValidException("Account " + Long.toUnsignedString(childTransactionImpl.getSenderId()) + " cannot delete property " + Long.toUnsignedString(assetPropertyDeleteAttachment.getPropertyId()));
            }
            this.checkRecipient(asset, childTransactionImpl.getRecipientId());
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Asset property transaction cannot be used to send money");
            }
        }

        @Override
        protected void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AssetPropertyDeleteAttachment assetPropertyDeleteAttachment = (AssetPropertyDeleteAttachment)childTransactionImpl.getAttachment();
            Asset.deleteProperty(assetPropertyDeleteAttachment.getPropertyId());
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return true;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ASSET_ISSUANCE;
            }
            case 1: {
                return ASSET_TRANSFER;
            }
            case 2: {
                return ASK_ORDER_PLACEMENT;
            }
            case 3: {
                return BID_ORDER_PLACEMENT;
            }
            case 4: {
                return ASK_ORDER_CANCELLATION;
            }
            case 5: {
                return BID_ORDER_CANCELLATION;
            }
            case 6: {
                return DIVIDEND_PAYMENT;
            }
            case 7: {
                return ASSET_DELETE;
            }
            case 8: {
                return ASSET_INCREASE;
            }
            case 9: {
                return SET_PHASING_CONTROL;
            }
            case 10: {
                return ASSET_PROPERTY_SET;
            }
            case 11: {
                return ASSET_PROPERTY_DELETE;
            }
        }
        return null;
    }

    private AssetExchangeTransactionType() {
    }

    @Override
    public final byte getType() {
        return 2;
    }

    public abstract long getAssetId(ChildTransaction var1);

    @Override
    protected final void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
        this.checkLiquid(childTransactionImpl);
        this.validateAttachment(childTransactionImpl, childTransactionImpl.getAttachment());
    }

    protected void checkLiquid(ChildTransaction childTransaction) throws NxtException.NotCurrentlyValidException {
        AssetFreezeMonitor.checkLiquid(this.getAssetId(childTransaction));
    }

    protected abstract void validateAttachment(ChildTransactionImpl var1, Att var2) throws NxtException.ValidationException;

    private static abstract class AssetPropertyTransactionType<Att extends Attachment>
    extends AssetExchangeTransactionType<Att> {
        private AssetPropertyTransactionType() {
        }

        final void checkRecipient(Asset asset, long l) throws NxtException.NotValidException {
            if (l != asset.getAccountId()) {
                throw new NxtException.NotValidException(String.format("Property transaction recipient must be asset issuer(%s), but was %s", Long.toUnsignedString(asset.getAccountId()), Long.toUnsignedString(l)));
            }
        }

        @Override
        public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public final boolean isGlobal() {
            return true;
        }

        @Override
        protected final void checkLiquid(ChildTransaction childTransaction) {
        }
    }

    private static abstract class OrderCancellation<Att extends Attachment>
    extends AssetExchangeTransactionType<Att> {
        private OrderCancellation() {
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            OrderCancellationAttachment orderCancellationAttachment = (OrderCancellationAttachment)childTransaction.getAttachment();
            OrderHome orderHome = childTransaction.getChain().getOrderHome();
            OrderHome.Order order = this.getOrder(orderHome, orderCancellationAttachment.getOrderId());
            return order != null ? order.getAssetId() : 0L;
        }

        protected abstract OrderHome.Order getOrder(OrderHome var1, long var2);

        @Override
        public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            OrderCancellationAttachment orderCancellationAttachment = (OrderCancellationAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(ASK_ORDER_CANCELLATION, Long.toUnsignedString(orderCancellationAttachment.getOrderId()), map, true);
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }
    }

    private static abstract class OrderPlacement
    extends AssetExchangeTransactionType<OrderPlacementAttachment> {
        private OrderPlacement() {
        }

        @Override
        public final void validateAttachment(ChildTransactionImpl childTransactionImpl, OrderPlacementAttachment orderPlacementAttachment) throws NxtException.ValidationException {
            if (orderPlacementAttachment.getPriceNQT() <= 0L || orderPlacementAttachment.getPriceNQT() > 100000000000000000L || orderPlacementAttachment.getAssetId() == 0L) {
                throw new NxtException.NotValidException("Invalid asset order placement: " + orderPlacementAttachment.getJSONObject());
            }
            long l = orderPlacementAttachment.getQuantityQNT();
            if (l <= 0L || l > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid asset order placement quantity: " + orderPlacementAttachment.getJSONObject());
            }
            Asset asset = Asset.getAsset(orderPlacementAttachment.getAssetId());
            if (asset == null) {
                throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(orderPlacementAttachment.getAssetId()) + " does not exist yet");
            }
            if (l > asset.getQuantityQNT()) {
                throw new NxtException.NotCurrentlyValidException("Invalid asset order placement quantity: " + orderPlacementAttachment.getJSONObject());
            }
            long l2 = Convert.unitRateToAmount(orderPlacementAttachment.getQuantityQNT(), asset.getDecimals(), orderPlacementAttachment.getPriceNQT(), childTransactionImpl.getChain().getDecimals());
            if (l2 == 0L) {
                throw new NxtException.NotValidException("Asset order has no value: " + orderPlacementAttachment.getJSONObject());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }

        @Override
        public long getAssetId(ChildTransaction childTransaction) {
            OrderPlacementAttachment orderPlacementAttachment = (OrderPlacementAttachment)childTransaction.getAttachment();
            return orderPlacementAttachment.getAssetId();
        }
    }
}

