/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public class AssetPropertyAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw PROPERTY_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 32);
    public static final StringRw PROPERTY_VALUE_RW = new StringRw(LengthRwPrimitiveType.UBYTE, 160);
    private final long assetId;
    private final String property;
    private final String value;

    AssetPropertyAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.assetId = byteBuffer.getLong();
        this.property = PROPERTY_NAME_RW.readFromBuffer(byteBuffer).trim();
        this.value = PROPERTY_VALUE_RW.readFromBuffer(byteBuffer).trim();
    }

    AssetPropertyAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.assetId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"asset"));
        this.property = Convert.nullToEmpty((String)jSONObject.get((Object)"property")).trim();
        this.value = Convert.nullToEmpty((String)jSONObject.get((Object)"value")).trim();
    }

    public AssetPropertyAttachment(long l, String string, String string2) {
        this.assetId = l;
        this.property = string.trim();
        this.value = Convert.nullToEmpty(string2).trim();
    }

    @Override
    protected int getMySize() {
        return 8 + PROPERTY_NAME_RW.getSize(this.property) + PROPERTY_VALUE_RW.getSize(this.value);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.assetId);
        PROPERTY_NAME_RW.writeToBuffer(this.property, byteBuffer);
        PROPERTY_VALUE_RW.writeToBuffer(this.value, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(this.assetId));
        jSONObject.put((Object)"property", (Object)this.property);
        jSONObject.put((Object)"value", (Object)this.value);
    }

    @Override
    public TransactionType getTransactionType() {
        return AssetExchangeTransactionType.ASSET_PROPERTY_SET;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }
}

