/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.ae.AssetTransferAttachment;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.EntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class AssetTransfer {
    private static final Listeners<AssetTransfer, Event> listeners = new Listeners();
    private static final DbKey.HashKeyFactory<AssetTransfer> transferDbKeyFactory = new DbKey.HashKeyFactory<AssetTransfer>("full_hash", "id"){

        @Override
        public DbKey newKey(AssetTransfer assetTransfer) {
            return assetTransfer.dbKey;
        }
    };
    private static final EntityDbTable<AssetTransfer> assetTransferTable = new EntityDbTable<AssetTransfer>("public.asset_transfer", transferDbKeyFactory){

        @Override
        protected AssetTransfer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new AssetTransfer(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, AssetTransfer assetTransfer) throws SQLException {
            assetTransfer.save(connection);
        }
    };
    private final long id;
    private final byte[] hash;
    private final DbKey dbKey;
    private final int chainId;
    private final long assetId;
    private final int height;
    private final long senderId;
    private final long recipientId;
    private final long quantityQNT;
    private final int timestamp;

    public static DbIterator<AssetTransfer> getAllTransfers(int n, int n2) {
        return assetTransferTable.getAll(n, n2);
    }

    public static int getCount() {
        return assetTransferTable.getCount();
    }

    public static boolean addListener(Listener<AssetTransfer> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<AssetTransfer> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static DbIterator<AssetTransfer> getAssetTransfers(long l, int n, int n2) {
        return assetTransferTable.getManyBy(new DbClause.LongClause("asset_id", l), n, n2);
    }

    public static DbIterator<AssetTransfer> getAccountAssetTransfers(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = assetTransferTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM asset_transfer WHERE sender_id = ? UNION ALL SELECT * FROM asset_transfer WHERE recipient_id = ? AND sender_id <> ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return assetTransferTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static DbIterator<AssetTransfer> getAccountAssetTransfers(long l, long l2, int n, int n2) {
        Connection connection = null;
        try {
            connection = assetTransferTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM asset_transfer WHERE sender_id = ? AND asset_id = ? UNION ALL SELECT * FROM asset_transfer WHERE recipient_id = ? AND sender_id <> ? AND asset_id = ? ORDER BY height DESC, db_id DESC" + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return assetTransferTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public static int getTransferCount(long l) {
        return assetTransferTable.getCount(new DbClause.LongClause("asset_id", l));
    }

    static AssetTransfer addAssetTransfer(Transaction transaction, AssetTransferAttachment assetTransferAttachment) {
        AssetTransfer assetTransfer = new AssetTransfer(transaction, assetTransferAttachment);
        assetTransferTable.insert(assetTransfer);
        listeners.notify(assetTransfer, Event.ASSET_TRANSFER);
        return assetTransfer;
    }

    public static void init() {
    }

    private AssetTransfer(Transaction transaction, AssetTransferAttachment assetTransferAttachment) {
        this.id = transaction.getId();
        this.hash = transaction.getFullHash();
        this.dbKey = transferDbKeyFactory.newKey(this.hash, this.id);
        this.chainId = transaction.getChain().getId();
        this.height = Nxt.getBlockchain().getHeight();
        this.assetId = assetTransferAttachment.getAssetId();
        this.senderId = transaction.getSenderId();
        this.recipientId = transaction.getRecipientId();
        this.quantityQNT = assetTransferAttachment.getQuantityQNT();
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
    }

    private AssetTransfer(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.hash = resultSet.getBytes("full_hash");
        this.dbKey = dbKey;
        this.chainId = resultSet.getInt("chain_id");
        this.assetId = resultSet.getLong("asset_id");
        this.senderId = resultSet.getLong("sender_id");
        this.recipientId = resultSet.getLong("recipient_id");
        this.quantityQNT = resultSet.getLong("quantity");
        this.timestamp = resultSet.getInt("timestamp");
        this.height = resultSet.getInt("height");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO asset_transfer (id, full_hash, chain_id, asset_id, sender_id, recipient_id, quantity, timestamp, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setBytes(++n, this.hash);
            preparedStatement.setInt(++n, this.chainId);
            preparedStatement.setLong(++n, this.assetId);
            preparedStatement.setLong(++n, this.senderId);
            preparedStatement.setLong(++n, this.recipientId);
            preparedStatement.setLong(++n, this.quantityQNT);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, this.height);
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public byte[] getFullHash() {
        return this.hash;
    }

    public int getChainId() {
        return this.chainId;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public long getSenderId() {
        return this.senderId;
    }

    public long getRecipientId() {
        return this.recipientId;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum Event {
        ASSET_TRANSFER;

    }
}

