/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.nio.ByteBuffer;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class AssetTransferAttachment
extends Attachment.AbstractAttachment {
    private final long assetId;
    private final long quantityQNT;

    AssetTransferAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.assetId = byteBuffer.getLong();
        this.quantityQNT = byteBuffer.getLong();
    }

    AssetTransferAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.assetId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"asset"));
        this.quantityQNT = Convert.parseLong(jSONObject.get((Object)"quantityQNT"));
    }

    public AssetTransferAttachment(long l, long l2) {
        this.assetId = l;
        this.quantityQNT = l2;
    }

    @Override
    protected int getMySize() {
        return 16;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.assetId);
        byteBuffer.putLong(this.quantityQNT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"asset", (Object)Long.toUnsignedString(this.assetId));
        jSONObject.put((Object)"quantityQNT", (Object)this.quantityQNT);
    }

    @Override
    public TransactionType getTransactionType() {
        return AssetExchangeTransactionType.ASSET_TRANSFER;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }
}

