/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public interface Attachment
extends Appendix {
    public TransactionType getTransactionType();

    public static abstract class PropertyDeleteAttachment
    extends AbstractAttachment {
        private final long propertyId;

        protected PropertyDeleteAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.propertyId = byteBuffer.getLong();
        }

        protected PropertyDeleteAttachment(JSONObject jSONObject) {
            super(jSONObject);
            this.propertyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"property"));
        }

        public PropertyDeleteAttachment(long l) {
            this.propertyId = l;
        }

        @Override
        protected int getMySize() {
            return 8;
        }

        @Override
        protected void putMyBytes(ByteBuffer byteBuffer) {
            byteBuffer.putLong(this.propertyId);
        }

        @Override
        protected void putMyJSON(JSONObject jSONObject) {
            jSONObject.put((Object)"property", (Object)Long.toUnsignedString(this.propertyId));
        }

        public long getPropertyId() {
            return this.propertyId;
        }
    }

    public static abstract class EmptyAttachment
    extends AbstractAttachment {
        protected EmptyAttachment() {
            super(0);
        }

        @Override
        protected final int getMySize() {
            return 0;
        }

        @Override
        protected final void putMyBytes(ByteBuffer byteBuffer) {
        }

        @Override
        protected final void putMyJSON(JSONObject jSONObject) {
        }

        @Override
        public final boolean verifyVersion() {
            return this.getVersion() == 0;
        }
    }

    public static abstract class AbstractAttachment
    extends Appendix.AbstractAppendix
    implements Attachment {
        protected AbstractAttachment(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        protected AbstractAttachment(JSONObject jSONObject) {
            super(jSONObject);
        }

        protected AbstractAttachment(int n) {
            super(n);
        }

        protected AbstractAttachment() {
        }

        @Override
        public final int getAppendixType() {
            return 0;
        }

        @Override
        public final String getAppendixName() {
            return this.getTransactionType().getName();
        }

        @Override
        public final void validate(Transaction transaction) throws NxtException.ValidationException {
            this.getTransactionType().validateAttachment(transaction);
        }

        @Override
        public final void validateId(Transaction transaction) throws NxtException.ValidationException {
            this.getTransactionType().validateId(transaction);
        }

        @Override
        public final void apply(Transaction transaction, Account account, Account account2) {
            this.getTransactionType().apply((TransactionImpl)transaction, account, account2);
        }

        @Override
        public final Fee getBaselineFee(Transaction transaction) {
            return this.getTransactionType().getBaselineFee(transaction);
        }

        @Override
        public final Fee getNextFee(Transaction transaction) {
            return this.getTransactionType().getNextFee(transaction);
        }

        @Override
        public final int getBaselineFeeHeight() {
            return this.getTransactionType().getBaselineFeeHeight();
        }

        @Override
        public final int getNextFeeHeight() {
            return this.getTransactionType().getNextFeeHeight();
        }

        @Override
        public final boolean isPhasable() {
            return !(this instanceof Appendix.Prunable) && this.getTransactionType().isPhasable();
        }

        @Override
        public final boolean isAllowed(Chain chain) {
            return chain.isAllowed(this.getTransactionType());
        }

        public final int getFinishValidationHeight(Transaction transaction) {
            return this.isPhased(transaction) ? ((ChildTransaction)transaction).getPhasing().getFinishHeight() - 1 : Nxt.getBlockchain().getHeight();
        }
    }
}

