/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import nxt.NxtException;
import nxt.account.BalanceHome;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.http.APIEnum;
import nxt.http.APITag;
import nxt.messaging.PrunableMessageHome;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class Chain {
    public final long ONE_COIN;
    private final String name;
    private final int id;
    private final int decimals;
    private final long totalAmount;
    private final TransactionHome transactionHome;
    private final BalanceHome balanceHome;
    private final PrunableMessageHome prunableMessageHome;
    private final Set<APIEnum> disabledAPIs;
    private final Set<APITag> disabledAPITags;

    public static Chain getChain(String string) {
        if ("ARDR".equals(string)) {
            return FxtChain.FXT;
        }
        return ChildChain.getChildChain(string);
    }

    public static Chain getChain(int n) {
        if (FxtChain.FXT.getId() == n) {
            return FxtChain.FXT;
        }
        return ChildChain.getChildChain(n);
    }

    Chain(int n, String string, int n2, long l, EnumSet<APIEnum> object, EnumSet<APITag> enumSet) {
        this.id = n;
        this.name = string;
        this.decimals = n2;
        this.ONE_COIN = Convert.decimalMultiplier(n2);
        this.totalAmount = l;
        this.transactionHome = TransactionHome.forChain(this);
        this.balanceHome = BalanceHome.forChain(this);
        this.prunableMessageHome = PrunableMessageHome.forChain(this);
        object = ((EnumSet)object).clone();
        for (APIEnum aPIEnum : APIEnum.values()) {
            if (Collections.disjoint(aPIEnum.getHandler().getAPITags(), enumSet)) continue;
            ((AbstractCollection)object).add(aPIEnum);
        }
        this.disabledAPIs = Collections.unmodifiableSet(object);
        this.disabledAPITags = Collections.unmodifiableSet(enumSet);
    }

    public final String getName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    public final int getDecimals() {
        return this.decimals;
    }

    public final long getTotalAmount() {
        return this.totalAmount;
    }

    public String getDbSchema() {
        return this.name;
    }

    public final String getSchemaTable(String string) {
        if (string.contains(".")) {
            throw new IllegalArgumentException("Schema already specified: " + string);
        }
        return this.getDbSchema() + "." + string.toUpperCase(Locale.ROOT);
    }

    public final TransactionHome getTransactionHome() {
        return this.transactionHome;
    }

    public final BalanceHome getBalanceHome() {
        return this.balanceHome;
    }

    public PrunableMessageHome getPrunableMessageHome() {
        return this.prunableMessageHome;
    }

    public abstract boolean isAllowed(TransactionType var1);

    public abstract Set<TransactionType> getDisabledTransactionTypes();

    public Set<APIEnum> getDisabledAPIs() {
        return this.disabledAPIs;
    }

    public Set<APITag> getDisabledAPITags() {
        return this.disabledAPITags;
    }

    public abstract TransactionImpl.BuilderImpl newTransactionBuilder(byte[] var1, long var2, long var4, short var6, Attachment var7);

    abstract TransactionImpl.BuilderImpl newTransactionBuilder(byte var1, byte[] var2, long var3, long var5, short var7, List<Appendix.AbstractAppendix> var8, JSONObject var9);

    abstract TransactionImpl.BuilderImpl newTransactionBuilder(byte var1, byte[] var2, long var3, long var5, short var7, List<Appendix.AbstractAppendix> var8, ByteBuffer var9);

    abstract TransactionImpl.BuilderImpl newTransactionBuilder(byte var1, long var2, long var4, short var6, List<Appendix.AbstractAppendix> var7, ResultSet var8);

    abstract UnconfirmedTransaction newUnconfirmedTransaction(ResultSet var1) throws SQLException, NxtException.NotValidException;

    public String toString() {
        return this.name + " (" + this.id + ")";
    }
}

